use Net::LDAP;
use LWP::Simple;
use LWP::UserAgent;
use HTTP::Request;

require "emd_common.pl";



my $host=$ARGV[0];
my $port=$ARGV[1];
my $username=$ARGV[2];
my $passwd=$ARGV[3];
my $base=$ARGV[4];

EMD_PERL_DEBUG("entering script\n");
my $ldap = Net::LDAP->new($host,port=>$port);

if ( not $ldap ) {
    $errtxt = "Could not connect to ldap server, please check machine name and port number";
    EMD_PERL_ERROR("Connection error: $errtxt\n");
    die ("em_error=$errtxt\n");
}
$bindmesg = $ldap->bind($username,password=>$passwd);
$bindCode = $bindmesg->code();
print "The bindCode is $bindCode\n";
if ($bindCode != 0) {
    $errtxt = $bindmesg->error_text();
    EMD_PERL_ERROR("Connection error: $errtxt\n");
    die ("em_error=$errtxt\n");
}

my $filter="(objectclass=oblixAAAServerConfigInfo)";
#	my $base="o=Oblix, dc=oampolicy,dc=com";
my $scopeOfOper = "sub";


my $searchMsg = $ldap->search(filter=>$filter, base=>$base, scope=>$scopeOfOper);
#my $searchMsg = $ldap->search(base=>$base);
#print "$searchMsg\n";
my @propName = ("obname","obHostName","obPort","obDebug","obthreads","obisencrypted","obmaxaaasessiontime","obauditflag","obmaxauditfilesize","obauditfilerotationinterval","obauditbuffersize","obmaxusercacheelems","obusercachetimeout","obmaxpolicycacheelems","obpolicycachetimeout","obengineconfigrefreshperiod","oburlprefixreloadinterval","obpasswordpolicyreloadinterval","obsessiontokencache","obmaxsessiontokencacheelems","obsnmpenabled","obsnmpagentport");
my $max = $searchMsg->count;
my @webgates;
my $res;
for ( $i = 0 ; $i < $max ; $i++ ) {
    my $entry = $searchMsg->entry ( $i );
    {
        my $res;
        foreach $pName (@propName)
        {
            foreach $attr ( $entry->attributes ) 
            {
                if (lc($attr)  eq lc($pName))
                {
                    #print $attr."--".$entry->get_value( $attr )."\n";
                     $res = $res."|".$entry->get_value( $attr );
                }
            }
        }
        $res = substr($res, 1);
        print "em_result=".$res."\n";
    }
}
