use Net::LDAP;
use LWP::Simple;
use LWP::UserAgent;
use HTTP::Request;

require "emd_common.pl";

my $host=$ARGV[0];
my $port=$ARGV[1];
my $username=$ARGV[2];
my $passwd=$ARGV[3];
my $base=$ARGV[4];

my $ldap = Net::LDAP->new($host,port=>$port);

	if ( not $ldap ) {
		$errtxt = "Could not connect to ldap server, please check machine name and port number";
                EMD_PERL_ERROR("Connection error: $errtxt\n");
                die ("em_error=$errtxt\n");
	}
	$bindmesg = $ldap->bind($username,password=>$passwd);
	$bindCode = $bindmesg->code();
	print "The bindCode is $bindCode\n";
	if ($bindCode != 0) {
		$errtxt = $bindmesg->error_text();
                EMD_PERL_ERROR("Connection error: $errtxt\n");
                die ("em_error=$errtxt\n");
	}

	my $filter="(objectclass=oblixWebgateConfigInfo)";
#	my $base="o=Oblix, dc=oampolicy,dc=com";
	my $scopeOfOper = "sub";


	my $searchMsg = $ldap->search(filter=>$filter, base=>$base, scope=>$scopeOfOper);
	#my $searchMsg = $ldap->search(base=>$base);
	#print "$searchMsg\n";
		my @propName = ("obname","obHostName","obPort");
my $max = $searchMsg->count;
print "$max\n";
	 my @webgates;
 for ( $i = 0 ; $i < $max ; $i++ ) {
   my $entry = $searchMsg->entry ( $i );
    {
	 my $res;
	     foreach $pName (@propName)
	     {
       foreach $attr ( $entry->attributes ) {
	       if ($attr  eq $pName)
	       {
		       # print $attr."--".$entry->get_value( $attr )."\n";
	   $res = $res."|".$entry->get_value( $attr );
   		}
	}
   }
$res = substr($res, 1);
push(@webgates, $res);
}
 }

 foreach (@webgates)
 {
	 my @vals = split(/\|/, $_);
	 print "$vals[1]$vals[2]\n";
	 my $browser= LWP::UserAgent->new;
	 my $request = HTTP::Request->new(GET => 'http://'.$vals[1].":".$vals[2].'/access/oblix/apps/webgate/bin/webgate.cgi?progid=1');
	 my $response = $browser->request($request);
	 if ($response->is_success) {
		 $_ = $_.'|1';
	 }
	 else
	 {
		 $_ = $_.'|0';
	 }
	  print "$_\n";
 }
	

