# $Header: oc4jresponse.pl 15-may-2003.13:13:00 klmichae Exp $
#
# oc4jresponse.pl
# 
# Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      oc4jresponse.pl - gets the up/down status for the oc4j instance
#
#    DESCRIPTION
#      oc4jresponse.pl <oracle_home> <oc4j-instance-name>
#
#      where
#         <oracle_home> is the oracle home in which oc4j is running
#         <oc4j-instance-name> is the instance name of the oc4j (such as home)
#
#    returns: 
#      em_result=<isUp>
#
#      where:
#         <isUp> is 1 if the ohs is up or 0 if it is down
#
#    NOTES
#
#
#    MODIFIED   (MM/DD/YY)
#    klmichae   05/15/03 - remove calls to opmnadmin
#    klmichae   10/09/02 - klmichae_apache_status
#    klmichae   10/08/02 - Initial revision

use strict;
require "iasresourceusage.pl";

  # Get the pids for the oc4j process
  my $oc4jPids = getOc4jPids( $ARGV[0], $ARGV[1] );

  # If we found a pid, the OC4J is up
  if( $oc4jPids eq "" )
  {
    print "em_result=0\n";
  } else {
    print "em_result=1\n";
  }

