#!/usr/bin/perl

# $Header: emas/sysman/admin/scripts/oifDiscovery.pl /st_emasgc_11.1/1 2010/01/19 14:25:25 rayleung Exp $
#
# top_recipent_name.pl
# 
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#  NAME
#  oifDiscovery.pl - 
#
#  NOTE
#  This script is use to discover the associated targets of OIF and configuration parameters   
#  
#    MODIFIED   (MM/DD/YY)
#    rayleung    01/13/10 - Bug 9269512
#    nsarkar     02/07/07 - 
#    aachanda    06/08/31 - Creation

use File::Find;
use strict;
use warnings;
use XML::Parser;
my %elements;
my $jndiname;
my $dburl;
my @element_stack;
my $fedtype;
my $usertype;
my @values;
my $configfile;
my $dfile;
my $appDataFile;
my $oifDataSourceFile;
my $appServerDSFile;
my $datafile;

my $ohome = $ARGV[0];
my $OSNAME = $^O;
if(($OSNAME eq "MSWin32") or ($OSNAME eq "Windows_NT")) {
	   $configfile = '\\fed\\conf\\config.xml';
	   $dfile = '\\fed\\conf\\data-store.xml';
	   $appDataFile = '\\j2ee\\home\\config';
	   $oifDataSourceFile =$ohome.'\\j2ee\\OC4J_FED\\application-deployments\\fed\\data-sources.xml';
	   $appServerDSFile =$ohome.'\\j2ee\\OC4J_FED\\config\\data-sources.xml';
       $datafile = $ohome.$dfile;	
} else {
 $configfile = '/fed/conf/config.xml';
 $dfile = '/fed/conf/data-store.xml';
 $appDataFile = '/j2ee/home/config';
 $oifDataSourceFile =$ohome.'/j2ee/OC4J_FED/application-deployments/fed/data-sources.xml';
 $appServerDSFile =$ohome.'/j2ee/OC4J_FED/config/data-sources.xml';
 $datafile = $ohome.$dfile;
}


my $parser = new XML::Parser(Handlers => { Start => \&handler_start,
                                           End   => \&handle_end,
                                           Char  => \&handle_char});


my $cfile = $ohome.$configfile;
my $appdatafile =$ohome.$appDataFile;

my ($keyword,$port,$isIdPenabled,$isSPenabled,$userdata,$feddata,$soapport,$serverid,$idpproviderid,$spproviderid,$key);
my ($fedport,$fedhost,$userport,$userhost,$dbsid);

$keyword = "<property name=\"port\">";
$port = &getOIFInfo($cfile,$keyword);
#print " Port = $port \n";

$keyword = "<property name=\"soapport\">";
$soapport = &getOIFInfo($cfile,$keyword);
#print " SOAPPort = $soapport \n";

$keyword = "<property name=\"idpenabled\">";
$isIdPenabled = &getOIFInfo($cfile,$keyword);
#print "IsIdPEnabled = $isIdPenabled \n";

$keyword = "<property name=\"spenabled\">";
$isSPenabled = &getOIFInfo($cfile,$keyword);
#print "isSPenabled = $isSPenabled \n";


$keyword = "<Config name=\"idpglobal\">";
$key = "<property name=\"providerid\">";
$idpproviderid =&getProviderID($cfile,$keyword,$key);
#print "idpproviderid = $idpproviderid \n";


$keyword = "<Config name=\"spglobal\">";
$key = "<property name=\"providerid\">";
$spproviderid =&getProviderID($cfile,$keyword,$key);
#print "spproviderid = $spproviderid \n";


open(HANDLE,$datafile);
$keyword = "<DiscoveryProvider type=\"UserDiscovery\">";
$userdata = &getUserDataStore(*HANDLE,$keyword);
#print "$userdata\n";
close(HANDLE);

open(HANDLE,$datafile);
$keyword = "<DiscoveryProvider type=\"ProviderFederationDiscovery\" setter=\"setPersistentProviderFederationDiscovery\">";
$feddata = &getFedDataStore(*HANDLE,$keyword);
#print "$feddata\n";
close(HANDLE);

open(HANDLE,$datafile);
$keyword = "<DiscoveryProvider type=\"ProviderFederationDiscovery\" setter=\"setPersistentProviderFederationDiscovery\">";
$serverid = &getServerID(*HANDLE,$keyword);
#print "$serverid\n";
close(HANDLE);


@values = split(':', $userdata);
$userhost=$values[0];
$userport=$values[1];
#Bug 9269512 - for basic install mode which LDAP was not specified
unless(defined($userhost))
{
  $userhost='null';
}
unless(defined($userport))
{
  $userport='null';
}

if($usertype eq 'DB')
{
  $dbsid = $values[2];
}
else
{
  $dbsid = 'null';
}
@values = split(':', $feddata);
$fedhost=$values[0];
$fedport=$values[1];
unless(defined($fedhost))
{
  $fedhost='null';
}
unless(defined($fedport))
{
  $fedport='null';
}

#print "$temp\n";
#print "$userhost\n";
#print "$userport\n";
#print "$fedhost\n";
#print "$fedport\n";
#print "$port|$isIdPenabled|$isSPenabled|$userdata|$feddata|$soapport|$serverid|$spproviderid|$idpproviderid";

print "$port|$isIdPenabled|$isSPenabled|$soapport|$serverid|$spproviderid|$idpproviderid|$userhost|$userport|$usertype|$fedhost|$fedport|$fedtype|$dbsid";


sub getOIFInfo
{
  my ($val);
  my ($data, $key) = @_;
  open(CONFIGFILE,$cfile);
  while(my $line = <CONFIGFILE>)
  {
	# Extracting the server port
    if (index($line,$key) != -1)
	{
	 if ($line =~ s/.*>(.*)<.*/$1/ ) {
      $val = $1;  		  
	 }
   }	 
  }
 close(CONFIGFILE);
 return $val;
}


sub getUserDataStore
{
  local(*FH) = shift;
  my $key = shift;
  my ($userdata,$nextline);
  while(my $line=<FH>) 
  { 
    chomp($line); 
    if (index($line,$key) != -1) { 
    $nextline = <FH>;   
	if (index($nextline,"OIDUserDiscoveryProvider") != -1)
    {
      $userdata = &getDependencyInfo(*FH,"setOIDConnectionManager","setServerUrls");
	  $userdata = parseUrl($userdata."/");
	  $usertype ="OID";
    }
	elsif(index($nextline,"LDAPUserDiscoveryProvider") != -1)
    {
	   $userdata = &getDependencyInfo(*FH,"setLDAPConnectionManager","setServerUrls");      
	   $userdata = parseUrl($userdata."/");
	 #  $jndiname ='jdbc/OracleCoreDS';
	 #  $parser->parsefile($appServerDSFile);	 	  
	   $usertype ="LDAP";
	}
    elsif(index($nextline,"RDBMSUserDiscoveryProvider") != -1)
    {       
	  $jndiname = &getDependencyInfo(*FH,"setRDBMSConnectionManager","setJndiName"); 
	  $parser->parsefile($appServerDSFile);
	  my @uservalues = split('@',$dburl);
	  $userdata = $uservalues[1];
	  $usertype ="DB";
	}
    }
   } 
  return $userdata;
}


sub getFedDataStore
{
   local(*FH) = shift;
   my $key = shift;
   my ($feddata,$nextline);
   while(my $line=<FH>) 
   { 
    chomp($line); 
    if (index($line,$key) != -1) { 
      $nextline = <FH>;   
	   if (index($nextline,"LDAPProviderFederationDiscoveryProvider") != -1)
       {
         $feddata = &getDependencyInfo(*FH,"setLDAPConnectionManager","setServerUrls");
		 $feddata = parseUrl($feddata."/");
		 $fedtype ="LDAP";
       }
	 }
   }
   return $feddata;
}

sub parseUrl()
{ 
  my ($line) = @_;
  my $val = '';
  if ($line =~ s/.*\/\/([^\/]*)\/.*/$1/ ) {
     $val = $1;  		
  }  
 return $val
}

sub getServerID
{
   local(*FH) = shift;
   my $key = shift;
   my ($serverid,$nextline);
   while(my $line=<FH>) 
	{
	  chomp($line); 
	  if (index($line,$key) != -1) { 
      $nextline = <FH>;   
	   if (index($nextline,"LDAPProviderFederationDiscoveryProvider") != -1)
       {
         $serverid = &getDependencyInfo(*FH,"setServerID","setProviderID");
       }
	  }
    }
   return $serverid;
}


sub getDependencyInfo
{
	local(*FILE) = shift;
	my $depkey = shift;
	my $parmkey =shift;
	my $serv = '';
	OUTER:while(my $depline= <FILE>)
	  {
	   if (index($depline,$depkey) != -1)
	   {
		 while(my $newline=<FILE>)
		  {
            if (index($newline,$parmkey) != -1)
		    {
              if ($newline =~ s/.*>(.*)<.*/$1/ )
		 	   {
             	   $serv = $1;  
				  # print "$serv\n";
				   last OUTER;
			   }
			}
		  }
		}
      }      
   return $serv;
}

sub getProviderID
{
  my ($providerid,$nextline);
  my ($file, $keyword,$key) = @_;
  open(CONFIGFILE,$file);
  OUTER:while(my $line = <CONFIGFILE>)
  {
    $line =~ s/^\s+//;
    $line =~ s/\s+$//;
    if (index($line,$keyword) != -1)
    {
      $nextline = <CONFIGFILE>;   
      $nextline =~ s/^\s+//;
      $nextline =~ s/\s+$//;
      if(index($nextline,$key) != -1)
      {
        if ($nextline =~ s/.*>(.*)<.*/$1/ )
        {
          $providerid = $1;  
	  last OUTER;
	}
      }
    }
 }  
  return $providerid;
}


sub handler_start
{
  my ($expat,$element, %attrs) = @_;
  my $line = $expat->current_line;
  my $found = '0';
  push( @element_stack, { element=>$element, line=>$line});
  if(%attrs)
  {
    OUTER:while(my($key,$value)=each(%attrs))
    {    
	  if((($key eq 'location') && ($value eq $jndiname))|| ($key eq 'ejb-location') && ($value eq $jndiname)){
            $found ='1';
	   }
	  if(($found eq '1') && ($key eq 'url'))
	   {
          $dburl = $value;  
		  #print "\t$value\n";
		  last OUTER;
	   }         
    }     
 }
}



sub handle_char
{
   my($parseint,$data)=@_;
   
}

sub handle_end
{
}



