#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/otd/fg-prop.pl /main/2 2012/05/29 03:13:21 gannaray Exp $
#
# fg-prop.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      fg-prop.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    gannaray    05/21/12 - Username,passwd through STDIN
#    gannaray    02/28/12 - Creation
# 

use IPC::Open3;
use otd::otdCommon;

my $home = $ARGV[0];
my $host = $ARGV[1];
my $port = $ARGV[2];
my $config_name= $ARGV[3];
my $user;
my $pwd;



my @lines = ();
my @listeners = ();

## Get username password
my @temp_res = getUserPassword();
$user = $temp_res[0];
$pwd = $temp_res[1];

get_fg();


################################### Get All Failover Group Properties ########################
############################################ get_fg () ###################################
sub get_fg {
    my $cmd = "$home/bin/tadm list-failover-groups --host=$host --port=$port --user=$user --config=$config_name";
    
    my @lines = get_lines($cmd,$pwd);

    foreach $line (@lines){
        my %fg_prop = get_fg_prop($line);
        my $size = scalar(keys %fg_prop);
        if($size > 0)
        {
        print "$fg_prop{\"virtual-ip\"},$fg_prop{\"network-prefix-length\"},$fg_prop{\"primary-node\"},"
            ."$fg_prop{\"backup-node\"},$fg_prop{\"primary-nic\"},$fg_prop{\"backup-nic\"}\n";
        }
    }
}

####################### Get Failover Group Prop ######################
#########################  get_fg_prop(<vip>) ##############################
sub get_fg_prop 
{
    my $vip = $_[0];
    $fg_cmd = "$home/bin/tadm get-failover-group-prop --host=$host --port=$port --user=$user --config=$config_name --virtual-ip=$vip";
    %fg_prop = get_property_map($fg_cmd);
    return %fg_prop;
}

###################### Get Property Map ###############################
##################### get_property_map($cmd) ##################
sub get_property_map
{
    my $cmd = $_[0];
    my @lines = get_lines($cmd,$pwd);
    %prop_map = ();
    
    foreach(@lines){
        my @parts = split(/=/, $_);
        $flag=0;
        
        for($i=0;$i<@parts;++$i){
            if($i==0){
                $prop_key = $parts[$i];
                chomp $prop_key;
            }
            else {
                $prop_map{$prop_key}=$parts[$i];
                chomp $prop_map{$prop_key};
            }
        }
    }
    return %prop_map;
}

##################### Run a command and get output lines ##############################
##################### &get_line ( <command>, <password> ) ################
sub get_lines
{
	my $cmd = $_[0];
	my $pwd = $_[1];
	my @lines = ();
	my $i=0;

	local (*HANDLE_IN, *HANDLE_OUT, *HANDLE_ERR);
	
	my $pid = open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_ERR, "$cmd") ;
	print HANDLE_IN "$pwd\r\n";

	my @err_lines = <HANDLE_ERR>;
	my $err_size = scalar @err_lines;

	if ($err_size==0){ 
		@lines = <HANDLE_OUT>;
	}
	else{
		$lines[0] = "Error";
	}
	
	close(HANDLE_IN)  or die "Can't close filehandle! $!";
	close(HANDLE_OUT)  or die "Can't close filehandle! $!";
	close(HANDLE_ERR)  or die "Can't close filehandle! $!";
	
	return @lines;
}
