#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/otd/list-prop.pl /main/1 2012/04/15 03:56:27 rahgupta Exp $
#
# list-prop.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      list-prop.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    gannaray    10/06/11 - Creation
# 

use IPC::Open3;

my $home = $ARGV[0];
my $host = $ARGV[1];
my $port = $ARGV[2];
my $user = $ARGV[3];
my $pwd = $ARGV[4];
my $config_name= $ARGV[5];


my @lines = ();
my @listeners = ();

get_listeners();

############# Get All Listeners in the configuration and their properties ###############
############# Usage: get_listeners() ###################
sub get_listeners()
{
    my $cmd = "$home/bin/tadm list-http-listeners --host=$host --port=$port --user=$user --config=$config_name";
    
    my @lines = get_lines($cmd,$pwd);
    foreach $line (@lines){
        my %prop_map = get_list_prop($line);
        print "$prop_map{\"name\"},$prop_map{\"ip\"},$prop_map{\"port\"},$prop_map{\"enabled\"},".
                "$prop_map{\"server-cert-nickname\"}\n";
    }
}

#### Get normal and ssl properties of given listener ####
#### Usage: get_list_prop(<list name>) ####
sub get_list_prop {
    my $name = $_[0];
    my $cmd1 = "$home/bin/tadm get-http-listener-prop --host=$host --port=$port --user=$user --config=$config_name --http-listener=$name";
    my $cmd2 = "$home/bin/tadm get-ssl-prop --host=$host --port=$port --user=$user --config=$config_name --http-listener=$name";
    
    my %prop_map = get_property_map($cmd1);
    my %prop_map2 = get_property_map($cmd2);
    
    $prop_map{"enabled"}=$prop_map2{"enabled"};
    $prop_map{"server-cert-nickname"}=$prop_map2{"server-cert-nickname"};
    return %prop_map;
}

###################### Get Property Map ###############################
##################### get_property_map($cmd) ##################
sub get_property_map
{
    my $cmd = $_[0];
    my @lines = get_lines($cmd,$pwd);
    %prop_map = ();
    
    foreach(@lines){
        my @parts = split(/=/, $_);
        $flag=0;
        
        for($i=0;$i<@parts;++$i){
            if($i==0){
                $prop_key = $parts[$i];
                chomp $prop_key;
            }
            else {
                $prop_map{$prop_key}=$parts[$i];
                chomp $prop_map{$prop_key};
            }
        }
    }
    return %prop_map;
}


##################### Run a command and get output lines ##############################
##################### &get_line ( <command>, <password> ) ################
sub get_lines
{
	my $cmd = $_[0];
	my $pwd = $_[1];
	my @lines = ();
	my $i=0;

	local (*HANDLE_IN, *HANDLE_OUT, *HANDLE_ERR);
	
	my $pid = open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_ERR, "$cmd") ;
	print HANDLE_IN "$pwd\r\n";

	my @err_lines = <HANDLE_ERR>;
	my $err_size = scalar @err_lines;

	if ($err_size==0){ 
		@lines = <HANDLE_OUT>;
	}
	else{
		$lines[0] = "Error";
	}
	
	close(HANDLE_IN)  or die "Can't close filehandle! $!";
	close(HANDLE_OUT)  or die "Can't close filehandle! $!";
	close(HANDLE_ERR)  or die "Can't close filehandle! $!";
	
	return @lines;
}
