#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/otd/mgmt_otd_listeners.pl /main/2 2012/05/29 03:13:21 gannaray Exp $
#
# mgmt_otd_listeners.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      mgmt_otd_listeners.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    gannaray    05/21/12 - Getting username,pwd through STDIN
#    nikhpand    12/02/11 - new collection script
#    nikhpand    12/02/11 - Creation
# 


use IPC::Open3;
use otd::otdCommon;

my $home = $ARGV[0];
my $host = $ARGV[1];
my $port = $ARGV[2];
my $config_name= $ARGV[3];
my $user;
my $pwd;


my %hash = ();

## Get username password
my @temp_res = getUserPassword();
$user = $temp_res[0];
$pwd = $temp_res[1];


get_hl();

sub get_hl()
{
   my $cmd = "$home/bin/tadm list-http-listeners --host=$host --port=$port --user=$user --config=$config_name";
   my @hls = get_lines($cmd,$pwd);

   foreach $hl (@hls){
	get_hl_props($hl);
   }
}

############# Get All Listeners in the configuration and their properties ###############
############# Usage: get_listeners() ###################
sub get_hl_props
{
    my $hl = $_[0];

    my $cmd = "$home/bin/tadm get-http-listener-prop --host=$host --port=$port --user=$user --config=$config_name --http-listener=$hl";
   # my $cmd = "/scratch/nikhpand/view_storage/nikhpand_otd10/oracle/work/otd/home/bin/tadm get-thread-pool-prop --host=localhost --port=1895 --user=admin --config=test";
    
  
    my @lines = get_lines($cmd,$pwd);
    foreach $line (@lines){
	 my @values = split('=', $line); 
	 $hash{$values[0]} = $values[1];    
	 	 
    }


my $temp="em_result=$hl|$hash{'enabled'}|$hash{'ip'}|$hash{'port'}|$hash{'server-name'}|$hash{'default-virtual-server-name'}|$hash{'acceptor-threads'}|$hash{'family'}|$hash{'listen-queue-size'}|$hash{'handle-protocol-mismatch'}|$hash{'blocking-io'}";

$temp=~ s/\n//g;
$temp=$temp."\n";

print $temp;

}



##################### Run a command and get output lines ##############################
##################### &get_line ( <command>, <password> ) ################
sub get_lines
{
	my $cmd = $_[0];
	my $pwd = $_[1];
	my @lines = ();
	my $i=0;

	local (*HANDLE_IN, *HANDLE_OUT, *HANDLE_ERR);
	

	my $pid = open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_ERR, "$cmd") ;
	print HANDLE_IN "$pwd\r\n";

	my @err_lines = <HANDLE_ERR>;
	my $err_size = scalar @err_lines;

	if ($err_size==0){ 
		@lines = <HANDLE_OUT>;
	}
	else{
		$lines[0] = "Error";
	}
	
	close(HANDLE_IN)  or die "Can't close filehandle! $!";
	close(HANDLE_OUT)  or die "Can't close filehandle! $!";
	close(HANDLE_ERR)  or die "Can't close filehandle! $!";
	
	return @lines;
}
