#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/otd/mgmt_otd_origin_servers_ocm.pl /main/1 2012/04/15 03:56:27 rahgupta Exp $
#
# mgmt_otd_origin_servers_ocm.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      mgmt_otd_origin_servers_ocm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nikhpand    01/13/12 - new OCM collector script
#    nikhpand    01/13/12 - Creation
# 



use pm::simpleXPath;
use pm::asecm;

my $home = $ARGV[0];

my $config_name= $ARGV[1];


my $dataSource;
my $dataSource1;
my %thisHash;




setMetricFormat(
        { 'type' => 'string' },             # Server Pool Name
        { 'type' => 'string' },             # Host
        { 'type' => 'number' },             # Port
        { 'type' => 'string' },             # Enabled	
        { 'type' => 'string' },             # Backup 
        { 'type' => 'number' },             # Weight
        { 'type' => 'number' },             # Maximum Connections
        { 'type' => 'string' },             # Ramp Up Time	

);


my @dataSources = simpleXPathQueryForNodes(
       "$home/admin-server/config-store/$config_name/config/server.xml",
        "server/origin-server-pool/origin-server"
    );


for $dataSource (@dataSources)
{

# test start
my %thisHash1;

my @dataSources1 = getAncestors($dataSource,"origin-server-pool");

for $dataSource1 (@dataSources1)
    {
   
    $name3 = $dataSource1->{'type'};
    $name4=$dataSource1->{'children'};
   
    my $length1=@$name4;
   
    my $j;
    for($j=0;$j<$length1;$j++)
    {
        my @values1 = values % {$$name4[$j] };
        my $tempval1=${$values1[1]}[0]->{'text'};
        $tempval1=~ s/\n//g;
        $tempval1=~ s/ //g;
   
        if($tempval1 ne "")
        {
            $thisHash1{$$name4[$j]->{'tagName'}}=${$values1[1]}[0]->{'text'};
   
        }
    }
    }


# test end
   
    $name = $dataSource->{'type'};
    $name2=$dataSource->{'children'};
   
    

    my $length=@$name2;
   
    my $i;
    for($i=0;$i<$length;$i++)
    {
        my @values = values % {$$name2[$i] };


        my $tempval=${$values[1]}[0]->{'text'};
        $tempval=~ s/\n//g;
        $tempval=~ s/ //g;


   
        if($tempval ne "")
        {
            $thisHash{$$name2[$i]->{'tagName'}}=${$values[1]}[0]->{'text'};
   
        }
	

    }



     printMetricResult(		
		$thisHash1{'name'},
		$thisHash{'host'},
		$thisHash{'port'},
		$thisHash{'enabled'},
		$thisHash{'backup'},
		$thisHash{'weight'},
		$thisHash{'max-connections'},
		$thisHash{'ramp-up-time'},);
    
}




sub getAncestors
{
    my $nodeRef = $_[0];
    my $tagName = $_[1];
    
    my @results;
    
    while ($nodeRef && $$nodeRef{'type'} eq 'element')
    {
        if ($tagName eq '*' || $tagName eq $$nodeRef{'tagName'})
        {
            unshift(@results, $nodeRef);
        }
        $nodeRef = $$nodeRef{'parent'};
    }
    
    return @results;
}

