#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/otd/mgmt_otd_server_pools.pl /main/2 2012/05/29 03:13:21 gannaray Exp $
#
# mgmt_otd_server_pools.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      mgmt_otd_server_pools.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    gannaray    05/21/12 - Username,passwd from STDIN
#    nikhpand    12/02/11 - new collection script
#    nikhpand    12/02/11 - Creation
# 


use IPC::Open3;
use otd::otdCommon;

my $home = $ARGV[0];
my $host = $ARGV[1];
my $port = $ARGV[2];
my $config_name= $ARGV[3];


my %hash = ();
my %hash1 = ();


## Get username,pwd
my @temp_res = getUserPassword();
$user = $temp_res[0];
$pwd = $temp_res[1];


get_osp();

sub get_osp()
{
   my $cmd = "$home/bin/tadm list-origin-server-pools --host=$host --port=$port --user=$user --config=$config_name";
   my @osps = get_lines($cmd,$pwd);

   foreach $osp (@osps){
	get_osp_props($osp);
   }
}

############# Get All Listeners in the configuration and their properties ###############
############# Usage: get_listeners() ###################
sub get_osp_props
{
    my $osp = $_[0];

    my $cmd = "$home/bin/tadm get-origin-server-pool-prop --host=$host --port=$port --user=$user --config=$config_name --origin-server-pool=$osp";
   # my $cmd = "/scratch/nikhpand/view_storage/nikhpand_otd10/oracle/work/otd/home/bin/tadm get-thread-pool-prop --host=localhost --port=1895 --user=admin --config=test";
    
  
    my @lines = get_lines($cmd,$pwd);
    foreach $line (@lines){
	 my @values = split('=', $line); 
	 $hash{$values[0]} = $values[1];    
	 	 
    }

     $cmd = "$home/bin/tadm get-health-check-prop --host=$host --port=$port --user=$user --config=$config_name --origin-server-pool=$osp";
   # my $cmd = "/scratch/nikhpand/view_storage/nikhpand_otd10/oracle/work/otd/home/bin/tadm get-thread-pool-prop --host=localhost --port=1895 --user=admin --config=test";
    
  
      @lines = get_lines($cmd,$pwd);
    foreach $line (@lines){
	 my @values = split('=', $line); 
	 $hash1{$values[0]} = $values[1];    
	 	 
    }

my $temp="em_result=$osp|$hash{'type'}|$hash{'family'}|$hash{'load-distribution'}|$hash1{'interval'}|$hash1{'timeout'}|$hash1{'request-method'}|$hash1{'request-uri'}|$hash1{'dynamic-server-discovery'}|$hash1{'failover-threshold'}|$hash1{'response-code-match'}|$hash1{'response-body-match'}|$hash1{'response-body-match-size'}";

$temp=~ s/\n//g;
$temp=$temp."\n";

   %hash = ();
   %hash1 = ();

print $temp;

}

##################### Run a command and get output lines ##############################
##################### &get_line ( <command>, <password> ) ################
sub get_lines
{
	my $cmd = $_[0];
	my $pwd = $_[1];
	my @lines = ();
	my $i=0;

	local (*HANDLE_IN, *HANDLE_OUT, *HANDLE_ERR);
	

	my $pid = open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_ERR, "$cmd") ;
	print HANDLE_IN "$pwd\r\n";

	my @err_lines = <HANDLE_ERR>;
	my $err_size = scalar @err_lines;

	if ($err_size==0){ 
		@lines = <HANDLE_OUT>;
	}
	else{
		$lines[0] = "Error";
	}
	
	close(HANDLE_IN)  or die "Can't close filehandle! $!";
	close(HANDLE_OUT)  or die "Can't close filehandle! $!";
	close(HANDLE_ERR)  or die "Can't close filehandle! $!";
	
	return @lines;
}
