#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/otd/mgmt_otd_server_pools_ocm.pl /main/1 2012/04/15 03:56:27 rahgupta Exp $
#
# mgmt_otd_server_pools_ocm.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      mgmt_otd_server_pools_ocm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nikhpand    01/13/12 - new OCM collector script
#    nikhpand    01/13/12 - Creation
# 




use pm::simpleXPath;
use pm::asecm;

my $home = $ARGV[0];

my $config_name= $ARGV[1];


my $dataSource;
my $dataSource1;
my $dataSource2;
my %thisHash;
my %thisHash2;




setMetricFormat(
        { 'type' => 'string' },             # Server Pool Name
        { 'type' => 'string' },             # Type
        { 'type' => 'string' },             # Protocol Family
        { 'type' => 'string' },             # Load Distribution
        { 'type' => 'number' },             # Interval
        { 'type' => 'number' },             # Timeout
        { 'type' => 'string' },             # Request Method 
        { 'type' => 'string' },             # Request URI
        { 'type' => 'string' },             # Dynamic Server Discovery
        { 'type' => 'number' },             # Failover Threshold
        { 'type' => 'string' },             # Acceptable Response Codes
        { 'type' => 'string' },             # Acceptable Response Body
        { 'type' => 'number' },             # Maximum Matching Body Size 

);

my @dataSources2 = simpleXPathQueryForNodes(
       "$home/admin-server/config-store/$config_name/config/server.xml",
        "server/origin-server-pool"
    );


my @dataSources = simpleXPathQueryForNodes(
       "$home/admin-server/config-store/$config_name/config/server.xml",
        "server/origin-server-pool/health-check"
    );

my $len=@dataSources;


if($len>0)
{
for $dataSource (@dataSources)
{

# test start
my %thisHash1;

my @dataSources1 = getAncestors($dataSource,"origin-server-pool");

for $dataSource1 (@dataSources1)
    {
   
    $name3 = $dataSource1->{'type'};
    $name4=$dataSource1->{'children'};
   
    my $length1=@$name4;
   
    my $j;
    for($j=0;$j<$length1;$j++)
    {
        my @values1 = values % {$$name4[$j] };
        my $tempval1=${$values1[1]}[0]->{'text'};
        $tempval1=~ s/\n//g;
        $tempval1=~ s/ //g;
   
        if($tempval1 ne "")
        {
            $thisHash1{$$name4[$j]->{'tagName'}}=${$values1[1]}[0]->{'text'};
   
        }
    }
    }


# test end
   
    $name = $dataSource->{'type'};
    $name2=$dataSource->{'children'};
   
    

    my $length=@$name2;
   
    my $i;
    for($i=0;$i<$length;$i++)
    {
        my @values = values % {$$name2[$i] };


        my $tempval=${$values[1]}[0]->{'text'};
        $tempval=~ s/\n//g;
        $tempval=~ s/ //g;


   
        if($tempval ne "")
        {
            $thisHash{$$name2[$i]->{'tagName'}}=${$values[1]}[0]->{'text'};
   
        }
	

    }



 	printMetricResult(		
		$thisHash1{'name'},
		$thisHash1{'type'},
		$thisHash1{'family'},
		$thisHash1{'load-distribution'},
                $thisHash{'interval'},
		$thisHash{'timeout'},
                $thisHash{'request-method'},
                $thisHash{'request-uri'},
		$thisHash{'dynamic-server-discovery'},
                $thisHash{'failover-threshold'},
                $thisHash{'response-code-match'},
		$thisHash{'response-body-match'},	
		$thisHash{'response-body-match-size'},);

    
}

}
if($len==0)
{



for $dataSource2 (@dataSources2)
    {
   
    $name5 = $dataSource2->{'type'};
    $name6=$dataSource2->{'children'};
   
    my $length2=@$name6;

  

    my $k;
    for($k=0;$k<$length2;$k++)
    {
        my @values2 = values % {$$name6[$k] };
        my $tempval2=${$values2[1]}[0]->{'text'};
        $tempval2=~ s/\n//g;
        $tempval2=~ s/ //g;
   
        if($tempval2 ne "")
        {
            $thisHash2{$$name6[$k]->{'tagName'}}=${$values2[1]}[0]->{'text'};
   
        }
    }


 	printMetricResult(		
		$thisHash2{'name'},
		$thisHash2{'type'},
		$thisHash2{'family'},
		$thisHash2{'load-distribution'},);
                


    }




}


sub getAncestors
{
    my $nodeRef = $_[0];
    my $tagName = $_[1];
    
    my @results;
    
    while ($nodeRef && $$nodeRef{'type'} eq 'element')
    {
        if ($tagName eq '*' || $tagName eq $$nodeRef{'tagName'})
        {
            unshift(@results, $nodeRef);
        }
        $nodeRef = $$nodeRef{'parent'};
    }
    
    return @results;
}
     
