#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/otd/mgmt_otd_vs_origin_servers.pl /main/2 2012/05/29 03:13:21 gannaray Exp $
#
# mgmt_otd_vs_origin_servers.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      mgmt_otd_vs_origin_servers.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    gannaray    05/21/12 - Username,pwd through STDIN
#    nikhpand    02/24/12 - adding route-name in output
#    nikhpand    12/02/11 - new collection script
#    nikhpand    12/02/11 - Creation
# 

use IPC::Open3;
use otd::otdCommon;

my $home = $ARGV[0];
my $host = $ARGV[1];
my $port = $ARGV[2];
my $config_name = $ARGV[3];

my %hash = ();
my %hash1 = ();


# Get username,pwd
my @temp_res = getUserPassword();
$user=$temp_res[0];
$pwd=$temp_res[1];

get_vs();

sub get_vs()
{
   my $cmd = "$home/bin/tadm list-virtual-servers --host=$host --port=$port --user=$user --config=$config_name";
   my @vss = get_lines($cmd,$pwd);

   foreach $vs (@vss){
	$vs=~ s/ //g;
	$vs=~ s/\n//g;
	get_vs_routes($vs);
   }
}

sub get_vs_routes
{
   my $vs = $_[0];

   my $cmd = "$home/bin/tadm list-routes --host=$host --port=$port --user=$user --config=$config_name --vs=$vs";
   my @routes = get_lines($cmd,$pwd);

   foreach $route (@routes){
	$route=~ s/ //g;
	$route=~ s/\n//g;
	get_osp($vs,$route);
   }
}

sub get_osp
{

    my $vs = $_[0];
    my $route = $_[1];

    my $cmd = "$home/bin/tadm get-route-prop --host=$host --port=$port --user=$user --vs=$vs --config=$config_name --route=$route";
   # my $cmd = "/scratch/nikhpand/view_storage/nikhpand_otd10/oracle/work/otd/home/bin/tadm get-thread-pool-prop --host=localhost --port=1895 --user=admin --config=test";

    my @lines = get_lines($cmd,$pwd);
    foreach $line (@lines){
	 my @values = split('=', $line); 
	 $hash1{$values[0]} = $values[1];    
	 	 
    }

    my $osp = $hash1{'origin-server-pool'};
    
    $osp=~ s/ //g;
    $osp=~ s/\n//g; 

    %hash1 = ();

    get_oss($vs,$osp,$route);
}


sub get_oss
{
   my $vs = $_[0];
   my $osp = $_[1];
   my $route = $_[2];

   my $cmd = "$home/bin/tadm list-origin-servers --host=$host --port=$port --user=$user --config=$config_name --origin-server-pool=$osp";
   my @oss = get_lines($cmd,$pwd);

   foreach $os (@oss){
	$os=~ s/ //g;
	get_origin_server_props($vs,$osp,$os,$route);
   }
}

############# Get All Listeners in the configuration and their properties ###############
############# Usage: get_listeners() ###################
sub get_origin_server_props
{
    my $vs = $_[0];
    my $osp = $_[1];
    my $os = $_[2];
    my $route = $_[3];
    
    my $cmd = "$home/bin/tadm get-origin-server-prop --host=$host --port=$port --user=$user --config=$config_name --origin-server-pool=$osp --origin-server=$os";
   # my $cmd = "/scratch/nikhpand/view_storage/nikhpand_otd10/oracle/work/otd/home/bin/tadm get-thread-pool-prop --host=localhost --port=1895 --user=admin --config=test";
    
  
    my @lines = get_lines($cmd,$pwd);
    foreach $line (@lines){
	 my @values = split('=', $line); 
	 $hash{$values[0]} = $values[1];    
	 	 
    }

my $temp="em_result=$route|$vs|$osp|$hash{'host'}|$hash{'port'}";

$temp=~ s/\n//g;
$temp=$temp."\n";

%hash = ();

print $temp;

}




##################### Run a command and get output lines ##############################
##################### &get_line ( <command>, <password> ) ################
sub get_lines
{
	my $cmd = $_[0];
	my $pwd = $_[1];
	my @lines = ();
	my $i=0;

	local (*HANDLE_IN, *HANDLE_OUT, *HANDLE_ERR);
	

	my $pid = open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_ERR, "$cmd") ;
	print HANDLE_IN "$pwd\r\n";

	my @err_lines = <HANDLE_ERR>;
	my $err_size = scalar @err_lines;

	if ($err_size==0){ 
		@lines = <HANDLE_OUT>;
	}
	else{
		$lines[0] = "Error";
	}
	
	close(HANDLE_IN)  or die "Can't close filehandle! $!";
	close(HANDLE_OUT)  or die "Can't close filehandle! $!";
	close(HANDLE_ERR)  or die "Can't close filehandle! $!";
	
	return @lines;
}
