#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/otd/vs-prop.pl /main/3 2012/05/29 03:13:21 gannaray Exp $
#
# vs-prop.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      vs-prop.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    gannaray    05/21/12 - Getting username,pwd from STDIN
#    gannaray    05/16/12 - Adding server pool name
#    gannaray    04/16/12 - Remove last semicolon in listeners field
#    gannaray    10/06/11 - Creation
# 

use IPC::Open3;
use otd::otdCommon;

my $home = $ARGV[0];
my $host = $ARGV[1];
my $port = $ARGV[2];
my $config_name= $ARGV[3];
my $user;
my $pwd;

my @lines = ();
my @listeners = ();

## Get username password
my @temp_res = getUserPassword();
$user = $temp_res[0];
$pwd = $temp_res[1];

get_vs();



################################### Get All Virtual Server Properties ########################
############################################ get_vs () ###################################
sub get_vs {
    my $cmd = "$home/bin/tadm list-virtual-servers --host=$host --port=$port --user=$user --config=$config_name";
    
    my @lines = get_lines($cmd,$pwd);

    foreach $line (@lines){
        my %vs_prop = get_vs_prop($line);
        print "$vs_prop{\"name\"},$vs_prop{\"http-listener-name\"},$vs_prop{\"host\"},"
                ."$vs_prop{\"enabled\"},$vs_prop{\"server-pools\"}\n";
    }
}

####################### Get Virtual Server Prop ######################
#########################  get_vs_prop(<vs name>) ##############################
sub get_vs_prop 
{
    my $vs_name = $_[0];
    chomp $vs_name;
    
    $vs_cmd = "$home/bin/tadm get-virtual-server-prop --host=$host --port=$port --user=$user --config=$config_name --vs=$vs_name";
    
    %vs_prop = get_property_map($vs_cmd);
    
    ## Convert comma seperated listener names to <host>:<port> format
    $listeners = $vs_prop{"http-listener-name"};
    @parts = split(/,/,"$listeners");
    my $desc = "";
    
    foreach $l (@parts){
        $list_cmd = "$home/bin/tadm get-http-listener-prop --host=$host --port=$port --user=$user --config=$config_name --http-listener=$l";
        %list_prop = get_property_map($list_cmd);
        my $ip = $list_prop{"ip"};
        my $port = $list_prop{"port"};
        $desc=$desc."$ip:$port;";
        $vs_prop{"http-listener-name"}=$desc;
    }
    chop($desc);
    $vs_prop{"http-listener-name"}=$desc;

    ## Add server pool name ##
    my $pools = get_server_pools($config_name,$vs_name);
    $vs_prop{"server-pools"}=$pools;

    return %vs_prop;
}


#####################  Get Server Pools of virtual-server ########################
##############    get_server_pools(<config name>,<virtual_server name>) ##########
sub get_server_pools
{
    my $config_name=$_[0];
    my $vs_name = $_[1];

    my $list_routes_cmd = "$home/bin/tadm list-routes --host=$host --port=$port --user=$user --config=$config_name --vs=$vs_name";
    my $route_props_cmd = "$home/bin/tadm get-route-prop --host=$host --port=$port --user=$user --config=$config_name --vs=$vs_name --route=";
    my $pools = "";

    # Get all routes for vs
    my @routes = get_lines($list_routes_cmd,$pwd);

    if($routes[0] eq "Error"){
        return "";
    }

    # For each route get pool, and add it comma seperated string
    foreach my $route (@routes){
        my $cmd = $route_props_cmd.$route;
        my @lines = get_lines($cmd,$pwd);
        if($lines[0] ne "Error"){
            my %prop_map = get_property_map($cmd);
            while(($key, $value) = each(%prop_map)){
                if($key eq "origin-server-pool")
                {
                    $pools = $pools."$value;";
                }
            }
        }
    }

    # remove last comma
    chop($pools);

    # return comma seperated list of pools
    return $pools;
}




###################### Get Property Map ###############################
##################### get_property_map($cmd) ##################
sub get_property_map
{
    my $cmd = $_[0];
    my @lines = get_lines($cmd,$pwd);
    %prop_map = ();
    
    foreach(@lines){
        my @parts = split(/=/, $_);
        $flag=0;
        
        for($i=0;$i<@parts;++$i){
            if($i==0){
                $prop_key = $parts[$i];
                chomp $prop_key;
            }
            else {
                $prop_map{$prop_key}=$parts[$i];
                chomp $prop_map{$prop_key};
            }
        }
    }
    return %prop_map;
}

##################### Run a command and get output lines ##############################
##################### &get_line ( <command>, <password> ) ################
sub get_lines
{
        my $cmd = $_[0];
        my $pwd = $_[1];
        my @lines = ();
        my @lines2 = ();
        my $i=0;

        local (*HANDLE_IN, *HANDLE_OUT, *HANDLE_ERR);
        
        my $pid = open3( *HANDLE_IN, *HANDLE_OUT, *HANDLE_ERR, "$cmd") ;
        print HANDLE_IN "$pwd\r\n";

        my @err_lines = <HANDLE_ERR>;
        my $err_size = scalar @err_lines;

        if ($err_size==0){ 
                @lines = <HANDLE_OUT>;
                foreach $line(@lines){
                    chomp $line;
                    push(@lines2,$line);
                }
        }
        else{
                $lines2[0] = "Error";
        }
        
        close(HANDLE_IN)  or die "Can't close filehandle! $!";
        close(HANDLE_OUT)  or die "Can't close filehandle! $!";
        close(HANDLE_ERR)  or die "Can't close filehandle! $!";
        
        return @lines2;
}
