#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ovdmetrics.pl /main/6 2011/04/15 11:42:43 kchander Exp $
#
# ovdmetrics.pl
# 
# Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ovdmetrics.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    kchander    01/18/11 - ps3 sync to main
#    kchander    04/09/09 - XbranchMerge kchander_fixbug0407 from
#                           st_emasgc_11.1as
#    rayleung    09/05/27 - Bug 
#    kchander    07/28/07 - Fix 401 unauthorized.
#    kchander    03/30/07 - Fix ovd webservice changes.
#    kchander    10/23/06 - Perl scripts OVD adapter metrics.
#    kchander    10/23/06 - Creation
# 

use ParseStdin;
use LWP::Simple;
use LWP::UserAgent;
use HTTP::Request;
use HTTP::Response;
use HTTP::Message;
use MIME::Base64;
use Data::Dumper;
use IPC::Open2;

require "emd_common.pl";
ParseStdin::initStdin();
my $passwd = ParseStdin::getParameter("PASSWORD");

my $host=$ARGV[0];
my $port=$ARGV[1];
my $username = $ARGV[2];
my $os = $^O;
$passwd =~ s/^\s+//;
$passwd =~ s/\s+$//;
my $uri = '/services/VDEStatusService';
my $MetricName = $ARGV[3];
my $oracleHome = $ARGV[4];
my $useSSL = $ARGV[5];
my $walletLoc = $ARGV[6];
#print "cols are $cols\n";

{
    my $cm;
    my $cmd;
    if(($os =~ "Win") || ($os =~ "MSWin32")) {
        $cm = $oracleHome."\\bin\\ldapsearch -h $host -p $port -D $username -q -b \"\" -s base";
	if ($useSSL eq 'true') {
	    $cmd = $cm." -U 2 -W \"file:".$walletLoc."\\sysman\\config\\monwallet\" -Q";
	}
    }
    else {
        $cm = $oracleHome."/bin/ldapsearch -h $host -p $port -D $username -q -b \"\" -s base";
	if ($useSSL eq 'true') {
	    $cmd = $cm." -U 2 -W \"file://".$walletLoc."/sysman/config/monwallet\" -q -Q";
  	}
    }
    $cmd = $cmd." \"vdeSearchTime=*\"";

    EMAGENT_PERL_DEBUG("cmd:$cmd");
    my($OUT,$IN);
    my $pid = open2($OUT,$IN, $cmd);
    if ($useSSL eq 'true')
    {
        print $IN "$passwd\n";
        print $IN "welcome\n";
    }
    else
    {
        print $IN "$passwd\n";
    }
    close($IN);
    #my $result = `$cmd`;
    #print "$result\n";
    my @propName = ("vdeNumSearches","vdeNumAdds","vdeNumBinds","vdeNumDeletes","vdeNumModifies","vdeNumRenames","vdeMinSearchCompleteTime","vdeMaxSearchCompleteTime","vdeAverageSearchCompletionTime");
    my @results ;
    my $res;
    my $line;
    while($line = <$OUT>)
    {
      chomp($line);
      push(@results, $line);    
    }

    close($OUT);
    waitpid($pid, 0);
    foreach $pName (@propName)
    {
        foreach $line (@results)
        {
            if ($line =~ m/$pName/)
            {
                {
                    my $r = substr($line, (index($line, '=')+1));
                    $r =~ s/\r//g;
                    $res =  $res."|".$r;
                }
            }
        }

    }
    $res = substr($res, 1);
    print "em_result=$res\n";
}

