#!/bin/sh
#
# $Header: emas/sysman/admin/scripts/siteguard/mount-umount.sh /main/1 2012/05/31 13:53:48 mrdesai Exp $
#
# mount-umount.sh
#
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      mount-umount.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    mrdesai     05/31/12 - Creation


# An error exit function

function error_exit
{
        echo "$1" 1>&2
        echo ''

        exit $2
}

# Usage function

usage()
{
        echo ''
        echo "Usage: ./mount-template.sh [-t <operation type e.g. mount/umount> ] [-d <comma seperated directories to mount/umount e.g. /u02/oracle/config,/u02/oracle/product,/u02/oracle/stage>]"

        echo ''
        exit $1
}

#***********************************************
# Script argument validation
#***********************************************

if [ $# -ne 4 ] ; then
        usage;
fi

#***********************************************
# User Input
#***********************************************

DIRECTORIES=
OPERATION=

while getopts t:d: opt
do
        case "$opt" in
                t) OPERATION="$OPTARG";;
                d) DIRECTORIES="$OPTARG";;
                \?)  usage;;
        esac
done

echo ''
echo Directories to $OPERATION : $DIRECTORIES
echo ''

count=`echo $DIRECTORIES | awk -F, {'print NF'}`

#*************************************************
# Check whether directories are exist or not
#*************************************************

j=1

while [ $j -le $count ]
do
        dir[$j]=`echo $DIRECTORIES | cut -d, -f${j}`

        if   [ ! -d "${dir[$j]}" ]
        then
                error_exit "${dir[$j]} is not a valid directory" 11
        fi

        j=`expr $j + 1`
done

#*************************************************
# mount/umount directories
#*************************************************
i=1

while [ $i -le $count ]
do
        dir[$i]=`echo $DIRECTORIES | cut -d, -f${i}`
        #echo ${dir[$i]}

        if [ "$OPERATION" = "mount" ]
        then
                #echo 'mount : ' ${dir[$i]}
                /bin/mount ${dir[$i]}
        else
                #echo 'umount : ' ${dir[$i]}
                /bin/umount ${dir[$i]} -l
        fi

        i=`expr $i + 1`
done

echo ''
echo 'Script completed.'
echo ''

