#!/usr/bin/perl
# 
# $Header: emas/sysman/admin/scripts/siteguard/ntapstorage.pl /main/1 2012/05/31 13:53:48 mrdesai Exp $
#
# ntapstorage.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ntapstorage.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    mrdesai     05/31/12 - Creation
#

require 5.6.1;

use strict;
use POSIX;
use Socket;
use Sys::Hostname 'hostname';

sub Initialize1();
sub print_usage();
sub Underscore_Length;
sub RunRemoteCommand;
sub filer_vol_function;
sub check_sm_status;
sub check_rsh;
sub sm_update;
sub sm_break;
sub sm_resync;
sub CLI_Based_SM_Operatons;
sub get_ontap_version;
sub encrypt_8_chars;
sub decrypt_8_chars;
sub encrypt_text;
sub decrypt_text;
sub update_cli;
sub sm_destinations;
sub decrypt_pass_fn;

#========================================
#  $main::rsh based on operating system 
#========================================
sub Initialize1() {

	my $nodename;
	($main::os_name, $nodename, $main::release) = POSIX::uname();
	if($main::os_name eq "Linux") {
		$main::rsh = "/usr/bin/rsh";
		$main::ssh = "/usr/bin/ssh";
	}elsif ($main::os_name eq "AIX") {
		$main::rsh = "/usr/bin/remsh";
		$main::ssh = "/usr/bin/ssh";
	} elsif ($main::os_name eq "HP-UX") {
	    $main::rsh = "/usr/bin/remsh";
    	$main::ssh = "/usr/bin/ssh";
    } elsif ($main::os_name eq "SunOS") {
	    $main::rsh = "/usr/bin/rsh";
    	$main::ssh = "/usr/bin/ssh";
	} else {
		print ("Unknown Operating System $main::os_name"."\n");
	}
}


sub Underscore_Length {
    my ($string) = @_;
	chomp($string);
    my $underscore_length = '';
	my $i = 0;
	do
    {
        $underscore_length .= '-';
    }while($i++ < (length($string)-1));

    return ($underscore_length);
}

#========================================
# Usage of ntapstorage.pl script 		
#========================================
sub print_usage() 
{
	#print "ntapstorage.pl <filer> <user> <password> <operation> [<value1>]\n ";
	print "ntapstorage.pl -sm <sip1:sv1/dip1:dv1> <update break | resync | break | release | break release | break release resync> [ -ntap_src_user <sip2:root/password> -ntap_dest_user <dip2:root/password> -encrypted <true/false> ]\n\n";
	print "-sm <sip1:sv1/dip1:dv1>  -- SnapMirror Source Filer:Source vol/Dest Filer:Dest vol\n";
	print "<operation(s)> \t\t - Operation to execute\n";
	print "\tupdate break \t -- update & break the existing SM relationship for failover/switchover\n";
	print "\tresync \t\t -- To failback or Re-establish the relationship after break release\n";
	print "\tbreak \t\t -- Break the SM relationship\n";
	print "\trelease \t -- release the existing broken SM relationship\n";
	print "\tbreak release \t -- break & release the existing broken SM relationship\n";
	print "\tbreak release resync -- break release & Re-establish the original SM relationship\n";
	print "-ntap_src_user <src_filer:root/encrypted or plain password> \t-- source filer:root/password\n";
	print "-ntap_dest_user <dest_filer:root/encrypted or plain password> \t-- dest filer:root/password\n";
	print "-encrypted true/false \t -- true(encrypted password) false(plain password)\n";

	exit 1;
}



#========================================
# Subroutine Name:
#    RunLocalCommandChomp
#----------------------------------------
# Description:
# Invokes a command on the local system and removes a trailing newline
# from the output.
#----------------------------------------
# Parameters:
#   $cmd - Command to execute
#----------------------------------------
# Returns:
#   ($status, $output)
#    $status - Exit code
#    $output - Command output with a trailing newline removed.
#========================================

sub RunRemoteCommand {
    my ($host, $remote_cmd, $rsh_pwd, $use_ssh) = @_;
    #$use_ssh = $main::UseSSH unless defined($use_ssh);
    my ($cmd, $status, $msg, $output);

    if ($use_ssh) {
        $cmd = "$main::ssh -n root\@$host '$remote_cmd'";
    } elsif($rsh_pwd) {
    	if ($main::os_name eq "AIX") {
        	$cmd = "$main::rsh $host -n -l root\:$rsh_pwd '$remote_cmd'";
	    } elsif ($main::os_name eq "HP-UX") {
    	    $cmd = "$main::rsh $host -n -l root\:$rsh_pwd '$remote_cmd'";
	    } elsif ($main::os_name eq "Linux") {
    	    $cmd = "$main::rsh -n -l root\:$rsh_pwd $host '$remote_cmd'";
	    } elsif ($main::os_name eq "SunOS") {
    	    $cmd = "$main::rsh -n -l root\:$rsh_pwd $host '$remote_cmd'";
    	}
    } else {
    	if ($main::os_name eq "AIX") {
        	$cmd = "$main::rsh $host -n -l root '$remote_cmd'";
	    } elsif ($main::os_name eq "HP-UX") {
    	    $cmd = "$main::rsh $host -n -l root '$remote_cmd'";
	    } elsif ($main::os_name eq "Linux") {
    	    $cmd = "$main::rsh -n -l root $host '$remote_cmd'";
	    } elsif ($main::os_name eq "SunOS") {
    	    $cmd = "$main::rsh -n -l root $host '$remote_cmd'";
    	}
    }

    ($status, $output) = RunLocalCommand($cmd);
#    ($status, $msg) = CheckStatus($host, $status, $output);
    return ($status, $output);
}

sub RunLocalCommand {
    my ($cmd) = @_;
    my $subr = 'RunLocalCommand';

    #print ("\n$subr: Starting: $cmd"."\n");
    my $output = `$cmd 2>&1`;
    $output = '' unless defined($output);
    my $status = $?;
    my ($failure, $code, $signal);
    if ($status == -1) {
    	$failure = $!;
    } else {
	    $code = POSIX::WEXITSTATUS($status) if POSIX::WIFEXITED($status);
    	$signal = POSIX::WTERMSIG($status) if POSIX::WIFSIGNALED($status);
    }

    #my $msg = "\n$subr:\n";
    my $msg = "\n";
    my $sep = sub {
    return $msg =~ />$/ ? ' ' : ', ';
    };

	#avoid displaining plain password on screen
	$cmd =~ s/$main::spwd/xxxx/g if($main::spwd);
	$cmd =~ s/$main::dpwd/xxxx/g if($main::dpwd);

    $msg .= "+== Ran command: =======================\n";
    $msg .= "+ $cmd\n=>";
    $msg .= &$sep . "Failed to start: $failure" if defined($failure);
    $msg .= &$sep . "exit_status=$code" if defined($code);
    $msg .= &$sep . "signal=$signal" if defined($signal);
    $msg .= &$sep . "output:\n$output" if $output ne '';
    $msg .= "\n" unless $msg =~ /\n$/;
    $msg .= "+=======================================";
   	print($msg);

    return ($status, $output)
}

#========================================
# Split the filer voluume
#========================================
sub filer_vol_function {
	my $filer_volumes_raw = shift ;

	my %Filer_Volume = ();
	my @vols;
	my $count_vol = 0;

	my @f_vol = split(/\:/,$filer_volumes_raw);

	#for each set first array source second array dest

	#print ("f_vol[0]: ".$f_vol[0]."\n") if ($f_vol[0]);

	#check if the volumes are empty
	#if ($f_vol[1]){ 
	if (!$f_vol[1]){ 
		#print ("f_vol[1]: ".$f_vol[1]."\n");
	#}else{
		print ("f_vol[1]: ".$f_vol[1]."volume are empty value\n");
		exit();
	}
    #f_vol[0] always filer f_vol[1] always volume names with comma separator
    my $temp_f_vol = $f_vol[0];

    foreach my $volumes ($f_vol[1]){
    	#print "volumes---: "."$volumes"."\n";
        #find the number of volumes
        @vols = split(/\,/,$volumes);
        $count_vol = scalar(@vols);
        foreach my $vol (@vols){
        #   	print ("vol: ".$vol."\n");
        #   print ("temp_f_vol: ".$temp_f_vol."\n");
        	push @{$Filer_Volume{$temp_f_vol}}, $vol;
        }
	}

	return($count_vol, $f_vol[0], \@vols, %Filer_Volume);
}

#========================================
#check the snapmirror status
#========================================
sub check_sm_status {

	my ($argc3, $d_nvols, $d_filer, $d_vols_ref, $counter_check, $pwd, $source_dest_filer_vol) = @_;
    my @s_d_vols;
	my @d_vols = @$d_vols_ref;
	my $counter = 0;
	my $c=0;
	my @results;
	my $counter_break;
	my $source_status;
	my $source_release_status;
	my $counter_release;
	my $counter_resync;

    @s_d_vols = @$source_dest_filer_vol if($source_dest_filer_vol);;
	foreach my $vol (@d_vols) {
		#execute command
	    my $cmd = "snapmirror status $d_filer\:$vol";
    	my ($status, $output) = RunRemoteCommand($d_filer, $cmd, $pwd);

	    if($status) {
    	   print ("\nCan not execute : $cmd"."\n");
	       return();
    	}

		#avoid empty relationship
		$output =~ s/\n*$//;
		if($output =~ /^Snapmirror\s+\w+\s+on.$/){
			print ("\nNo SnapMirror Relationship exist for $d_filer\:$vol","\n");
			return "nosm" if($counter_check eq 'initialize'); #to create new relationship
			exit(1) ;
		}

		#getchar();
		foreach my $line (split(/\n+/, $output)) {
			$line =~ s/^\s*//;
			next if($line =~ /^Snapmirror/ || $line =~ /^Source/);
			
			#getchar();
			@results = split(/\s+/, $line);
		
			#switch ($counter_check) {
			#	case "update" 
				if($counter_check eq "update")
						{
							#return Snapmirror status to proceed snapmirror update
							if ($results[2] eq 'Snapmirrored' && $results[4] eq 'Idle'){
								return $results[2];
							}else{
								return $results[4];
							}
				}
				#case "resync"
				elsif($counter_check eq "resync")
						{
							if($results[0] eq $s_d_vols[0] && $results[1] eq $s_d_vols[1] && $results[2] eq 'Broken-off' ){
                                $counter_resync = 'Broken-off';
                                next;
                            }
							if($counter_resync eq 'Broken-off' && $results[0] eq $s_d_vols[1] && $results[1] eq $s_d_vols[0] && $results[2] eq 'Source'){
                                return 'Broken-off';
                            }
							if($results[0] eq $s_d_vols[1] && $results[1] eq $s_d_vols[0] && $results[2] eq 'Broken-off' ){
                                $counter_resync = 'Broken-off';
                                next;
                            }

							if($results[0] eq $s_d_vols[1] && $results[1] eq $s_d_vols[0] && $results[2] eq 'Snapmirrored' && $results[4] eq 'Idle' || $results[0] eq $s_d_vols[0] && $results[1] eq $s_d_vols[1] && $results[2] eq 'Snapmirrored' && $results[4] eq 'Idle'){
								return $results[2];
							}
							#print "\nresults[0]: $results[0]","\n";
							#print "results[1]: $results[1]","\n";
							#print "s_d_vols[0]: $s_d_vols[0]","\n";
							#print "s_d_vols[1]: $s_d_vols[1]","\n";
							#in a single relationship it needs 
							if( $results[0] eq $s_d_vols[1] && $results[1] eq $s_d_vols[0] && $results[2] eq 'Source'){
								#getchar();
                                return $results[2];
                            }


				}
				#case "break"
				elsif($counter_check eq "break")
						{
							#getchar();
							#first break ie) update break
							#$source_status ne 'Snapmirrored' required 2nd break
							if($results[0] eq $s_d_vols[0] && $results[1] eq $s_d_vols[1] && $results[2] eq 'Snapmirrored' || $results[0] eq $s_d_vols[0] && $results[1] eq $s_d_vols[1] && $results[2] eq 'Source' && $counter_break ne 'Broken-off' && $source_status ne 'Snapmirrored')	{
								return $results[2];
							}
							if($results[0] eq $s_d_vols[0] && $results[1] eq $s_d_vols[1] && $results[2] eq 'Broken-off' ){
								$counter_break = 'Broken-off';
								next;
							}
							#second break ie) update break resync break [destination sm status]
							if($counter_break eq 'Broken-off' && $results[0] eq $s_d_vols[1] && $results[1] eq $s_d_vols[0] && $results[2] eq 'Source'){
								return 'Broken-off';
							}
							#second break ie) update break resync break [source sm status] - 1st line
							if($results[0] eq $s_d_vols[1] && $results[1] eq $s_d_vols[0] && $results[2] eq 'Snapmirrored'){
								$source_status = 'Snapmirrored';
											#print "source_status: $source_status"."\n";
								next;
							}
											#print "source_status: $source_status"."\n";
							#getchar();
							#second break ie) update break resync break [source sm status] - 2ndline
							if($results[0] eq $s_d_vols[0] && $results[1] eq $s_d_vols[1] && $results[2] eq 'Source' && $source_status eq 'Snapmirrored' ){
								return 'Snapmirrored';
							}
							print "source_status: $source_status"."\n";
							#second break ie) update break resync break [source sm status] - 2ndline
							if($results[0] eq $s_d_vols[1] && $results[1] eq $s_d_vols[0] && $results[2] eq 'Source' && $source_status eq 'Snapmirrored'){	
								return 'Snapmirrored';
							}else{# second break ie) update break resync break [source sm status] - if no snapmirrored its failed
								return 'failed';
							}
				}
				#case "release"
				elsif($counter_check eq "release")
						{
							if($results[0] eq $s_d_vols[0] && $results[1] eq $s_d_vols[1] && $results[2] eq 'Broken-off'){
								$counter_release = 'Broken-off';
								next;
							}
							if($results[0] eq $s_d_vols[1] && $results[1] eq $s_d_vols[0] && $results[2] eq 'Source' && $counter_release eq 'Broken-off'){
								return 'Broken-off';
							}
							if($results[0] eq $s_d_vols[1] && $results[1] eq $s_d_vols[0] && $results[2] eq 'Broken-off' && $counter_release ne 'Broken-off'){
								$source_release_status = 'Broken-off';
								next;
							}
							if($results[0] eq $s_d_vols[0] && $results[1] eq $s_d_vols[1] && $results[2] eq 'Source' && $source_release_status eq 'Broken-off'){
								return 'Broken-off';
							}
				}elsif($counter_check eq "initialize") 
					   {
							if($results[0] eq $s_d_vols[1] && $results[1] eq $s_d_vols[0] && $results[2] eq 'Source' ){
                                return 'sm';
                            }			
				}
			#	else {
						#print "no more opeation found".$counter_check."\n";
		#		}
			#}
	
		}#foreach my $line (split(/\n+/, $output))
	}#foreach my $vol (@d_vols)
	
	#second break ie) update break resync break [source sm status] - no 2nd line
	if($source_status eq 'Snapmirrored'){
		return 'Snapmirrored';
	}	
	if($counter_release eq 'Broken-off' || $source_release_status eq 'Broken-off') {
		return 'Broken-off';
	}
	if($counter_resync eq 'Broken-off' ) {
		return 'Broken-off';
	}
	
=start
=cut

}

#========================================
#check the input source and destination filer in snapmirror status
#========================================
sub check_sm_status_source_dest {


    my ($argc3, $d_nvols, $d_filer, $d_vols_ref, $pwd, $source_dest_filer_vol) = @_;
    my @s_d_vols;
    my @d_vols = @$d_vols_ref;
    my $counter = 0;
    my $c=0;
    my @results;

    @s_d_vols = @$source_dest_filer_vol if($source_dest_filer_vol);;
    #execute command
    my $cmd = "snapmirror status $d_filer\:$d_vols[0]";
    my ($status, $output) = RunRemoteCommand($d_filer, $cmd, $pwd);

    if($status) {
    	print ("\nCan not execute : $cmd"."\n");
        return();
  	}
    
	foreach my $line (split(/\n+/, $output)) {
    	$line =~ s/^\s*//;
        next if($line =~ /^Snapmirror/ || $line =~ /^Source/);

        @results = split(/\s+/, $line);

		if($results[0] eq $s_d_vols[0] && $results[1] eq $s_d_vols[1] || $results[0] eq $s_d_vols[1] && $results[1] eq $s_d_vols[0] && $results[2] =~ m!^(Source|Broken-off)$!){
    		print("\nSM source:\'$results[0]\' and destination:\'$results[1]\' matches with input for \'$argc3\' "."\n");
			return "matches";
		}
		if($results[0] ne $s_d_vols[0] && $results[1] ne $s_d_vols[1]) {
			$counter=1;
    	}
	}
	if($counter == 1) {
    	print("\nSM source:\'$s_d_vols[0]\' and destination:\'$s_d_vols[1]\' NOT correct for \'$argc3\' "."\n\n");
		#exit() if($argc3 ne 'resync');
		exit();
	}

} 

#========================================
#check the rsh either password or passwordless
#========================================
sub check_rsh {

	#my $d_filer = shift;
	my ($d_filer,$pwd) = @_;

	my $cmd = "version";
    my ($status, $output) = RunRemoteCommand($d_filer, $cmd, $pwd);

    if($status) {
    	print ("\nCan not execute : $cmd"."\n");
        return "notenabled";
    }
	foreach my $line (split(/\n/, $output)) {
   		$line =~ s/^\s*//;
		if($line =~ /NetApp/ || $line =~ /Release/){
			return "enabled";
		}else{
			print ("rsh result: ".$line."\n");
			return "notenabled";
		}
	}
}


#========================================
# snapmirror update
#========================================
sub sm_update {

	my ($d_filer, $source_dest_filer_vol, $pwd) = @_;
	my @s_d_vols = @$source_dest_filer_vol;

        #execute command
		#snapmirror update -S 10.61.173.191:rmanpc_11g_nfs_191_data stlfas3170-12:rmanpc_11g_nfs_191_data_dest
		print("\nupdate starts...."."");
        my $cmd = "snapmirror update \-S $s_d_vols[0] $s_d_vols[1]";
        my ($status, $output) = RunRemoteCommand($d_filer, $cmd, $pwd);

        if($status) {
           print ("\nCan not execute : $cmd"."\n");
           return();
        }
        foreach my $line (split(/\n/, $output)) {
            $line =~ s/^\s*//;
			return "update" if($line =~ /started/);
        }
}

#========================================
# snapmirror break
#========================================
sub sm_break {

	my ($d_filer,$d_vols_ref, $pwd) = @_;
    my @d_vols = @$d_vols_ref;

        #execute command
        #snapmirror update -S 10.61.173.191:rmanpc_11g_nfs_191_data stlfas3170-12:rmanpc_11g_nfs_191_data_dest
        print("\nbreak starts..."."");
        my $cmd = "snapmirror break  $d_filer\:$d_vols[0]";
        my ($status, $output) = RunRemoteCommand($d_filer, $cmd, $pwd);

        if($status) {
           print ("\nCan not execute : $cmd"."\n");
           return();
        }
        foreach my $line (split(/\n/, $output)) {
            $line =~ s/^\s*//;
            return "break" if($line =~ /writable/);
        }
}


#========================================
# snapmirror break
#========================================
sub sm_release {

    my ($s_filer,$d_filer, $s_vols_ref, $d_vols_ref, $pwd) = @_;
    my @s_vols = @$s_vols_ref;
    my @d_vols = @$d_vols_ref;

        #execute command
        #snapmirror update -S 10.61.173.191:rmanpc_11g_nfs_191_data stlfas3170-12:rmanpc_11g_nfs_191_data_dest
		#/usr/bin/rsh -l root:Netapp123 10.61.173.191 snapmirror release sg_s stlfas3170-12:sg_d
        my $cmd = "snapmirror release  $s_vols[0] $d_filer\:$d_vols[0]";
        my ($status, $output) = RunRemoteCommand($s_filer, $cmd, $pwd);

        if($status) {
           print ("\nCan not execute : $cmd"."\n");
           return();
        }
        foreach my $line (split(/\n/, $output)) {
            $line =~ s/^\s*//;
            return() if($line =~ /release-able/) ; #release-able is the key word in failure message
        }
        return "release";
}

#========================================
# snapmirror resync
#========================================
sub sm_resync {

    my ($d_filer, $pwd, $source_dest_filer_vol) = @_;
    my @s_d_vols = @$source_dest_filer_vol;

        #execute command
        #snapmirror update -S 10.61.173.191:rmanpc_11g_nfs_191_data stlfas3170-12:rmanpc_11g_nfs_191_data_dest
        my $cmd = "snapmirror  resync \-f \-S $s_d_vols[0] $s_d_vols[1]";
        my ($status, $output) = RunRemoteCommand($d_filer, $cmd, $pwd);

        if($status) {
           print ("\nCan not execute : $cmd"."\n");
           return();
        }
        foreach my $line (split(/\n/, $output)) {
            $line =~ s/^\s*//;
            return "resync" if($line =~ /started/);
        }
}

sub sm_initialize{
	my ($d_filer, $pwd, $source_dest_filer_vol) = @_;
	my @s_d_vols = @$source_dest_filer_vol;

	my $cmd = "snapmirror  initialize \-S $s_d_vols[0] $s_d_vols[1]";
        my ($status, $output) = RunRemoteCommand($d_filer, $cmd, $pwd);

        if($status) {
           print ("\nCan not execute : $cmd"."\n");
           return();
        }
        foreach my $line (split(/\n/, $output)) {
            $line =~ s/^\s*//;
            return "initialize" if($line =~ /started/);
        }
}

sub update_cli {
	my ($argc3, $d_nvols, $d_filer, $d_vols_ref, $pwd, $source_dest_filer_vol) = @_;
	my @s_d_vols = @$source_dest_filer_vol;

    if($argc3 eq 'update'){
		print("update checking..."."\n");
		my $sm_s_d_check = check_sm_status_source_dest($argc3, $d_nvols, $d_filer, $d_vols_ref, $pwd, \@s_d_vols);
        my $smstate = check_sm_status($argc3, $d_nvols, $d_filer, $d_vols_ref, "update", $pwd );
        if( $smstate eq 'Snapmirrored' && $sm_s_d_check eq 'matches'){
        	#snapmirror update started
            if(sm_update($d_filer,\@s_d_vols, $pwd) eq 'update'){
            	#check the update status
                while(1){
                	#last if(check_sm_status($argc3, $d_nvols, $d_filer, $d_vols_ref,"updatecheck") eq 'Idle');
                	last if(check_sm_status($argc3, $d_nvols, $d_filer, $d_vols_ref,"update",$pwd) eq 'Snapmirrored');
                	sleep(2);
            	}
                printf("\nSnapmirror Update is done"."\n");
				return "done";
      		}else{
            	print("\nUpdate is not success"."\n");
                exit();
         	}
   		} else {
         	print("\nUpdate is not success. State is $smstate"."\n");
            exit();
       }
	}
}

sub break_cli {
	my ($argc3, $s_nvols, $d_nvols, $d_filer, $d_vols_ref, $source_dest_filer_vol, $s_nvols, $s_filer, $s_vols_ref, $dpwd, $spwd) = @_;
	my @dvols = @$d_vols_ref;
	my @svols = @$s_vols_ref;
	my @source_dest_filer_vol_1 = @$source_dest_filer_vol;


  	print("break checking..."."\n");
	my $sm_s_d_check = check_sm_status_source_dest($argc3, $d_nvols, $d_filer, $d_vols_ref, $dpwd, \@source_dest_filer_vol_1);
	if($argc3 eq 'break' && $sm_s_d_check eq 'matches'){
    	#snapmirror break started
        #my $resync_instan_d_filer_state = check_sm_status($argc3, $d_nvols, $d_filer, $d_vols_ref,"resyncreinstantiate",\@source_dest_filer_vol_1 );
        #my $sm_status = check_sm_status($argc3, $d_nvols, $d_filer, $d_vols_ref);
        #my $resync_instan_s_filer_state = check_sm_status($argc3, $s_nvols, $s_filer, $s_vols_ref,"resyncreinstantiate",\@source_dest_filer_vol_1 );
        my $break_instan_d_filer_state = check_sm_status($argc3, $d_nvols, $d_filer, $d_vols_ref,"break",$dpwd, \@source_dest_filer_vol_1 );
        my $break_instan_s_filer_state = check_sm_status($argc3, $s_nvols, $s_filer, $s_vols_ref,"break",$spwd, \@source_dest_filer_vol_1 );

							#print("\nbreak_instan_d_filer_state State: $break_instan_d_filer_state"."\n");
							#print("\nbreak_instan_s_filer_state State: $break_instan_s_filer_state"."\n") if($break_instan_s_filer_state ne 'failed');
		#getchar();
        #if($s_nvols == $d_nvols && $sm_status eq 'Snapmirrored' && $resync_instan_d_filer_state ne 'Broken-off' ){
        #if($s_nvols == $d_nvols && $resync_instan_s_filer_state eq 'Snapmirrored' && $resync_instan_d_filer_state ne 'Broken-off' ){
        #if($s_nvols == $d_nvols && $break_instan_s_filer_state eq 'Source' && $break_instan_d_filer_state eq 'Snapmirrored' ){
        if($s_nvols == $d_nvols && $break_instan_s_filer_state eq 'Source' && $break_instan_d_filer_state eq 'Snapmirrored' || $break_instan_d_filer_state eq 'Snapmirrored'){
			#getchar();
        	if(sm_break($d_filer, $d_vols_ref, $dpwd) eq 'break'){
            	print("\nThe SnapMirror relationship is broken & \'". $dvols[0]."\' is writable"."\n");
				return "done";
          	}
		#this is re-establish break check require for break
		#}elsif( $s_nvols == $d_nvols &&  $resync_instan_s_filer_state ne 'Snapmirrored' && $resync_instan_s_filer_state ne 'Source'){
		}elsif( $s_nvols == $d_nvols &&  $break_instan_s_filer_state eq 'Snapmirrored' && $break_instan_d_filer_state eq 'Broken-off'){
							#print("\nresync_instan_s_filer_state State: $break_instan_s_filer_state"."\n");
			#getchar();
        	if(sm_break($s_filer, $s_vols_ref, $spwd) eq 'break'){
           		print("\nThe SnapMirror relationship is broken & \'". $svols[0]."\' is writable"."\n");
				return "done";
			}
     	}else{
            print("Snapmirror Break is not success"."\n");
        	print("\nSnapmirror current state is $break_instan_s_filer_state. break need 'Snapmirred'"."\n");
			exit();
    	}

	}
}



sub release_cli {

	my ($argc3, $d_nvols, $d_filer, $d_vols_ref, $s_filer, $s_vols_ref, $source_dest_filer_vol, $s_nvols, $s_filer, $s_vols_ref, $dpwd, $spwd) = @_;
	my @d_vols = @$d_vols_ref;
	my @s_d_f_vol = @$source_dest_filer_vol;
	my @s_vols = @$s_vols_ref;
	
	print("\$d_vols[0]: ".$d_vols[0]."\n");
	print("\$s_d_f_vol[0]: ".$s_d_f_vol[0]."\n");
	print("\$s_vols[0]: ".$s_vols[0]."\n");
	print("\$s_filer: ".$s_filer."\n");
	#print("\$s_d_f_vol[1]: ".$s_d_f_vol[1]."\n");

	#check the sm status whether sg_d is dest and stlfas3170-11:sg_s is source
	my $release_d_filer_state = check_sm_status($argc3, $d_nvols, $d_filer, $d_vols_ref,"release",$dpwd, \@s_d_f_vol );
    my $release_s_filer_state = check_sm_status($argc3, $s_nvols, $s_filer, $s_vols_ref,"release",$spwd, \@s_d_f_vol);
			#print("release_d_filer_state: ".$release_d_filer_state."\n");
			#print("release_s_filer_state: ".$release_s_filer_state."\n");
	#getchar();

	#check the snapmirror destinations before release
	my $sm_destinations_result = sm_destinations($argc3, $s_filer, $s_vols_ref, $spwd, \@s_d_f_vol);

	if($sm_destinations_result ne 'destinations'){
		print "\nno known destinations"."\n";
		exit();
	}
	
	if($release_d_filer_state eq 'Broken-off' && $release_s_filer_state eq 'Broken-off' && $sm_destinations_result eq 'destinations') {	
		print ("\nrelease starts...\n");
	#release operation starts
		my $sm_release_state = sm_release($s_filer,$d_filer, $s_vols_ref, $d_vols_ref, $spwd);
		if($sm_release_state eq 'release'){
    		print("\nThe SnapMirror relationship \'".$d_vols[0]."\' is released \n");
			return "done";
	   	}else{
    	    print("\nSnapmirror release is not success"."\n");
    		exit();
	   	}
	}else{
		print("\nThe Snapmirror state in $d_filer is \'".$release_d_filer_state."\' and $s_filer is \'$release_s_filer_state\'. run \'break\' before \'release\'\n");
	}
}


sub sm_destinations {
	my ($argc3, $s_filer, $s_vols_ref, $pwd, $source_dest_filer_vol) = @_;

	#my ($d_filer, $source_dest_filer_vol) = @_;
    my @s_d_vols = @$source_dest_filer_vol;
	my @s_vols = @$s_vols_ref;
	my @results;

        #execute command
        #snapmirror update -S 10.61.173.191:rmanpc_11g_nfs_191_data stlfas3170-12:rmanpc_11g_nfs_191_data_dest
        my $cmd = "snapmirror  destinations $s_vols[0]";
        my ($status, $output) = RunRemoteCommand($s_filer, $cmd, $pwd);

        if($status) {
           print ("\nCan not execute : $cmd"."\n");
           return();
        }
        foreach my $line (split(/\n/, $output)) {
            $line =~ s/^\s*//;
            next if($line =~ /^Path/ || $line =~ /Destination$/);
			@results = split(/\s+/, $line);
			#print("\nresults[0]: ".$results[0]."\n");
			#print("results[1]: ".$results[1]."\n");
			#print("s_vols[0]: ".$s_vols[0]."\n");
			#print("s_d_vols[1]: ".$s_d_vols[1]."\n");
			return "destinations" if(($results[0] eq $s_vols[0] && $results[1] eq $s_d_vols[1]) || ($results[0] =~ /^$s_vols[0]/ && $results[1] =~ /^$s_d_vols[1]/));
        }

}

sub resync_cli {

	my ($argc3, $d_nvols, $d_filer, $d_vols_ref, $s_nvols, $s_filer, $s_vols_ref, $dpwd, $spwd, $source_dest_filer_vol_1) = @_;

	my @source_dest_filer_vol = @$source_dest_filer_vol_1;

    print ("\nresync cheking..."."\n");
	my $sm_s_d_check = check_sm_status_source_dest($argc3, $d_nvols, $d_filer, $d_vols_ref, $dpwd, \@source_dest_filer_vol);
	my $sm_d_s_check = check_sm_status_source_dest($argc3, $s_nvols, $s_filer, $s_vols_ref, $spwd, \@source_dest_filer_vol);
	if($argc3 eq 'resync' && $sm_s_d_check eq 'matches' || $sm_d_s_check eq 'matches'){
        	#check the source and destination was reverse on previous relation before resync
                    #my $resync_s_filer_state = check_sm_status($argc3, $d_nvols, $d_filer, $d_vols_ref,"resyncfailback",\@source_dest_filer_vol );
                    my $resync_s_filer_state = check_sm_status($argc3, $d_nvols, $d_filer, $d_vols_ref,"resync",$dpwd, \@source_dest_filer_vol );
                    #getchar();
                    #my $resync_d_filer_state = check_sm_status($argc3, $s_nvols, $s_filer, $s_vols_ref,"resyncfailback",\@source_dest_filer_vol );
                    my $resync_d_filer_state = check_sm_status($argc3, $s_nvols, $s_filer, $s_vols_ref,"resync",$spwd, \@source_dest_filer_vol );
                    #getchar();
                    #check only destination and state 'Broken-off' in destination filer for re-establish
                   # my $resync_instan_s_filer_state = check_sm_status($argc3, $d_nvols, $d_filer, $d_vols_ref,"resyncreinstantiate",\@source_dest_filer_vol );
                    			#print "resync_s_filer_state: ".$resync_s_filer_state."\n";
                    			#print "resync_d_filer_state: ".$resync_d_filer_state."\n";
                    #getchar();
                    #print "resync_instan_s_filer_state: ".$resync_instan_s_filer_state."\n";
                    #my $resync_instan_d_filer_state = check_sm_status($s_nvols, $s_filer, $s_vols_ref,"resyncreinstantiate",\@source_dest_filer_vol );
                    #print $resync_instan_d_filer_state."\n";
                    #getchar();

                    #if( $resync_s_filer_state eq 'Source' && $resync_d_filer_state eq 'Broken-off' || $resync_instan_s_filer_state eq 'Broken-off'){
                    #if($resync_s_filer_state eq 'Snapmirrored' && $resync_d_filer_state eq 'Broken-off' ||  $resync_s_filer_state eq 'Source' && $resync_d_filer_state eq 'Broken-off' || $resync_instan_s_filer_state eq 'Broken-off'){
                    if($resync_s_filer_state eq 'Broken-off' && $resync_d_filer_state eq 'Broken-off' ||  $resync_s_filer_state eq 'Source' && $resync_d_filer_state eq 'Broken-off' ){
					print("\nresync starts.......");
                    #getchar();
                    #snapmirror resync started
                    if(sm_resync($d_filer, $dpwd, \@source_dest_filer_vol) eq 'resync'){
                        #check the update status
                        while(1){
                            #last if(check_sm_status($argc3, $d_nvols, $d_filer, $d_vols_ref,"resync") eq 'Idle');
							my $sm_state = check_sm_status($argc3, $d_nvols, $d_filer, $d_vols_ref, "resync", $dpwd, \@source_dest_filer_vol);
							#print $sm_state;
							#getchar();
							last if($sm_state eq 'Idle' || $sm_state eq 'Snapmirrored');
                            sleep(2);
                        }
                        printf("\nThe snapmirror resync is done"."\n");	
						return "done";
                    }else{
                        print("\nResync is not success"."\n");
                        exit();
                    }
                }else{
                    print ("\n\nPlease check the -sm <value> is not the reverse of existing SM relationship or \n not the existing SM relationship or \n state is not 'Snapmirrored' for re-estabilish SM relationship"."\n");
                }
            }else{
				print("$argc3 should be \'resync\'. resync failed or \n Check the Snapmirror relationship exist");
				exit();
			}
}

sub initialize_cli {

    my ($argc3, $d_nvols, $d_filer, $d_vols_ref, $s_nvols, $s_filer, $s_vols_ref, $dpwd, $spwd, $source_dest_filer_vol_1) = @_;

    my @source_dest_filer_vol = @$source_dest_filer_vol_1;

    print ("\ninitialize cheking..."."\n");
    #my $sm_s_d_check = check_sm_status_source_dest($argc3, $d_nvols, $d_filer, $d_vols_ref, $dpwd, \@source_dest_filer_vol);
    if($argc3 eq 'initialize'){
            #check the source and destination was reverse on previous relation before resync
                    #my $resync_s_filer_state = check_sm_status($argc3, $d_nvols, $d_filer, $d_vols_ref,"resyncfailback",\@source_dest_filer_vol );
                   	my $resync_s_filer_state = check_sm_status($argc3, $d_nvols, $d_filer, $d_vols_ref,"initialize",$dpwd, \@source_dest_filer_vol );
                    #getchar();
                    #my $resync_d_filer_state = check_sm_status($argc3, $s_nvols, $s_filer, $s_vols_ref,"resyncfailback",\@source_dest_filer_vol );
                    #my $resync_d_filer_state = check_sm_status($argc3, $s_nvols, $s_filer, $s_vols_ref,"initialize",$spwd, \@source_dest_filer_vol );
                    #getchar();
                    #check only destination and state 'Broken-off' in destination filer for re-establish
                   # my $resync_instan_s_filer_state = check_sm_status($argc3, $d_nvols, $d_filer, $d_vols_ref,"resyncreinstantiate",\@source_dest_filer_vol );
                                #print "resync_s_filer_state: ".$resync_s_filer_state."\n";
                                #print "resync_d_filer_state: ".$resync_d_filer_state."\n";
                    #getchar();
                    #print "resync_instan_s_filer_state: ".$resync_instan_s_filer_state."\n";
                    #my $resync_instan_d_filer_state = check_sm_status($s_nvols, $s_filer, $s_vols_ref,"resyncreinstantiate",\@source_dest_filer_vol );
                    #print $resync_instan_d_filer_state."\n";
                    #getchar();

                    #if( $resync_s_filer_state eq 'Source' && $resync_d_filer_state eq 'Broken-off' || $resync_instan_s_filer_state eq 'Broken-off'){
                    #if($resync_s_filer_state eq 'Snapmirrored' && $resync_d_filer_state eq 'Broken-off' ||  $resync_s_filer_state eq 'Source' && $resync_d_filer_state eq 'Broken-off' || $resync_instan_s_filer_state eq 'Broken-off'){
                    if($resync_s_filer_state eq 'nosm'){
                    print("\ninitialize starts.......");
                    #getchar();
                    #snapmirror resync started
                    if(sm_initialize($d_filer, $dpwd, \@source_dest_filer_vol) eq 'initialize'){
                        #check the update status
                        while(1){
                            #last if(check_sm_status($argc3, $d_nvols, $d_filer, $d_vols_ref,"resync") eq 'Idle');
                            my $sm_state = check_sm_status($argc3, $d_nvols, $d_filer, $d_vols_ref, "update", $dpwd, \@source_dest_filer_vol);
                            #print $sm_state;
                            #getchar();
                            last if($sm_state eq 'Idle' || $sm_state eq 'Snapmirrored');
                            sleep(2);
                        }
                        printf("\nThe snapmirror initialize is done"."\n");
                        return "done";
                    }else{
                        print("\ninitialize is not success"."\n");
                        exit();
                    }
                }elsif($resync_s_filer_state eq 'sm' && check_sm_status_source_dest($argc3, $d_nvols, $d_filer, $d_vols_ref, $dpwd, \@source_dest_filer_vol) eq 'matches' ){
					print "Already reverse SM relationship exist";
					exit(1);
				}else{
                    print ("\n\nPlease check the -sm <value> is not the reverse of existing SM relationship or \n not the existing SM relationship or \n state is not 'Snapmirrored' for re-estabilish SM relationship"."\n");
                }
            }else{
                print("$argc3 should be \'resync\'. resync failed or \n Check the Snapmirror relationship exist");
                exit();
            }

}
sub update_break_cli {

	my ($argc3, $argc4, $d_nvols, $s_nvols, $s_filer, $s_vols_ref, $d_filer, $d_vols_ref, $dpwd, $spwd, $source_dest_filer_vol_1) = @_; 
	my @source_dest_filer_vol = @$source_dest_filer_vol_1;

	if($argc3 eq 'update' && $argc4 eq 'break'){
		my $update_result = update_cli($argc3, $d_nvols, $d_filer, $d_vols_ref, $dpwd, \@source_dest_filer_vol)if ($argc3 eq 'update');
		#here $argc4 is break so we pass argc4 as argc3 to break_cli function
        break_cli($argc4, $s_nvols, $d_nvols, $d_filer, $d_vols_ref, \@source_dest_filer_vol, $s_nvols, $s_filer, $s_vols_ref, $dpwd, $spwd)if ($argc4 eq 'break' && $update_result eq 'done');	
	}else{
		print ("$argc3 $argc4 - failed"."\n");
	}
}

sub break_release_cli {
	my ($argc3, $argc4, $d_nvols, $s_nvols, $s_filer, $s_vols_ref, $d_filer, $d_vols_ref, $dpwd, $spwd, $source_dest_filer_vol_1) = @_;

	my @source_dest_filer_vol = @$source_dest_filer_vol_1;	

	if($argc3 eq 'break' && $argc4 eq 'release') {
        my $break_result = break_cli($argc3, $s_nvols, $d_nvols, $d_filer, $d_vols_ref, \@source_dest_filer_vol, $s_nvols, $s_filer, $s_vols_ref, $dpwd, $spwd)if ($argc3 eq 'break');	
		#here $argc4 is release so we pass argc4 as argc3 to release_cli function
		my $release_result = release_cli($argc4, $d_nvols, $d_filer, $d_vols_ref, $s_filer, $s_vols_ref, \@source_dest_filer_vol, $s_nvols, $s_filer, $s_vols_ref, $dpwd, $spwd)if ($argc4 eq 'release' && $break_result eq 'done');
		if($release_result eq "done" && $break_result eq "done"){
			return "done";
		}else{
			print "break and release not success","\n";
			exit();
		}
	}else{
		print "$argc3 $argc4 - failed"."\n";
	}
}

sub break_release_resync_cli {
	my ($argc3, $argc4, $argc5, $d_nvols, $s_nvols, $s_filer, $s_vols_ref, $d_filer, $d_vols_ref,$dpwd, $spwd, $source_dest_filer_vol_1)=@_;
	my @source_dest_filer_vol=@$source_dest_filer_vol_1;

 	if($argc3 eq 'break' && $argc4 eq 'release' && $argc5 eq 'resync'){
		my $break_release_result = break_release_cli($argc3, $argc4, $d_nvols, $s_nvols, $s_filer, $s_vols_ref, $d_filer, $d_vols_ref, $dpwd, $spwd, \@source_dest_filer_vol) if($argc3 eq 'break' && $argc4 eq 'release');
		#here $argc5 is resync so we pass argc5 as argc3 to resync_cli function
		my $resync_cli_result = resync_cli($argc5, $d_nvols, $d_filer, $d_vols_ref, $s_nvols, $s_filer, $s_vols_ref, $dpwd, $spwd, \@source_dest_filer_vol)if ($argc5 eq 'resync' && $break_release_result eq 'done');

		if($resync_cli_result eq "done"){
			return "done";
		}else{
			print "$argc3 $argc4 $argc5  - failed";
			exit();
		}
	}else{
		print ("$argc3 $argc4 $argc5 - failed"."\n");
	}
}

sub update_break_resync_cli {

	my ($argc3, $argc4, $argc5, $d_nvols, $s_nvols, $s_filer, $s_vols_ref, $d_filer, $d_vols_ref, $dpwd, $spwd, $source_dest_filer_vol_1)=@_; 
	my @source_dest_filer_vol = @$source_dest_filer_vol_1;

	if($argc3 eq 'update' && $argc4 eq 'break' && $argc5 eq 'resync'){
		update_break_cli($argc3, $argc4, $d_nvols, $s_nvols, $s_filer, $s_vols_ref, $d_filer, $d_vols_ref, $dpwd, $spwd, \@source_dest_filer_vol) if($argc3 eq 'update' && $argc4 eq 'break');
		#here $argc5 is resync so we pass argc5 as argc3 to resync_cli function
        resync_cli($argc5, $d_nvols, $d_filer, $d_vols_ref, $s_nvols, $s_filer, $s_vols_ref, $dpwd, $spwd, \@source_dest_filer_vol)if ($argc5 eq 'resync');
	}else{
		print ("$argc3 $argc4 $argc5 - failed"."\n");
	}
}

###
#CLI based SnapMirror Operations
###
sub CLI_Based_SM_Operatons {

	#my ($ntap_user_resync,$encrypt,$encrypt_value) = shift;
	my ($switch_selection, $argc3, $argc4, $argc5, $argc6, $argc7, $argc8, $argc9, $argc10, $argc11) = @_;

	Initialize1();
	print "\nrsh: "."$main::rsh"."\n";

	#$main::rsh_pwd

	#print "ssh: "."$main::ssh"."\n";
	#print "release: "."$main::release"."\n";
	my (@source_dest_filer_vol);
	my (@s_vols, @d_vols);
	my $counter = 0;
	my %Filer_Volume = ();
	my ($d_nvols,$s_nvols, $s_filer, $d_filer, $s_vols_ref, $d_vols_ref);
	my %destin_filer_volumes = ();
	my %source_filer_volumes = ();

	#print ("sm_vol_dest_vol: ".$main::sm_vol_dest_vol."\n");

	#sip1:sv1/dip1:dv1;sip2:sv1,sv2/dip2:dv1,dv2	
	my @s_d_server_vol_set = split("/\;/",$main::sm_vol_dest_vol);

	#sip1:sv1/dip1:dv1 - split source and volume set
	foreach my $s_d_s_v (@s_d_server_vol_set){
		@source_dest_filer_vol = split(/\//, $s_d_s_v);	
		#print ("number of filer set: ".scalar(@source_dest_filer_vol)."\n");
	
		if( scalar(@source_dest_filer_vol) == 2){
			#print ("source_dest_filer_vol[0]:".$source_dest_filer_vol[0]."\n");
			#print ("source_dest_filer_vol[1]:".$source_dest_filer_vol[1]."\n");
			($s_nvols,$s_filer,$s_vols_ref,%source_filer_volumes) = filer_vol_function($source_dest_filer_vol[0]);
			($d_nvols,$d_filer,$d_vols_ref,%destin_filer_volumes) = filer_vol_function($source_dest_filer_vol[1]);
			#assgin the array reference to array
			@s_vols = @$s_vols_ref;
			@d_vols = @$d_vols_ref;

			#print("s_vols[0]".$s_vols[0]."\n");
			#print("s_vols[1]".$s_vols[1]."\n");
			#print("d_vols[0]".$d_vols[0]."\n");
			#print("d_vols[1]".$d_vols[1]."\n");
			#getchar();

		
			#check the rsh access
			if (check_rsh($d_filer, $main::dpwd) eq 'enabled' && check_rsh($s_filer, $main::spwd) eq 'enabled') {
				print("\n"."rsh enabled"."\n");
			#} elsif (check_ssh($d_filer) eq 'enabled') {
			#	print("\nssh with key auth enabled\n");
			}else{
				print("\nrsh NOT enabled\n");
				exit();
			}

=start
=cut
			#switch($switch_selection) {
				#case 1
				if($switch_selection == 1 || $switch_selection == 11)
					{
						print("\n$argc3...\n");
						update_cli($argc3, $d_nvols, $d_filer, $d_vols_ref, $main::dpwd, \@source_dest_filer_vol)if ($argc3 eq 'update');
						break_cli($argc3, $s_nvols, $d_nvols, $d_filer, $d_vols_ref, \@source_dest_filer_vol, $s_nvols, $s_filer, $s_vols_ref,$main::dpwd, $main::spwd )if ($argc3 eq 'break');
						release_cli($argc3, $d_nvols, $d_filer, $d_vols_ref, $s_filer, $s_vols_ref, \@source_dest_filer_vol, $s_nvols, $s_filer, $s_vols_ref, $main::dpwd, $main::spwd )if ($argc3 eq 'release');
						resync_cli($argc3, $d_nvols, $d_filer, $d_vols_ref, $s_nvols, $s_filer, $s_vols_ref, $main::dpwd, $main::spwd,\@source_dest_filer_vol)if ($argc3 eq 'resync');
						initialize_cli($argc3, $d_nvols, $d_filer, $d_vols_ref, $s_nvols, $s_filer, $s_vols_ref, $main::dpwd, $main::spwd,\@source_dest_filer_vol)if ($argc3 eq 'initialize');
						print("\n$argc3 ends.\n");
					}
				if($switch_selection == 2 || $switch_selection == 22)
				#case 2
					{
						print("\n$argc3 $argc4 starts...\n");
						update_break_cli($argc3, $argc4, $d_nvols, $s_nvols, $s_filer, $s_vols_ref, $d_filer, $d_vols_ref, $main::dpwd, $main::spwd, \@source_dest_filer_vol) if($argc3 eq 'update' && $argc4 eq 'break');
						break_release_cli($argc3, $argc4, $d_nvols, $s_nvols, $s_filer, $s_vols_ref, $d_filer, $d_vols_ref, $main::dpwd, $main::spwd, \@source_dest_filer_vol) if($argc3 eq 'break' && $argc4 eq 'release');
						print("\n$argc3 $argc4 ends.\n");
					}
				if($switch_selection == 3 || $switch_selection == 33)
				#case 3
					{
						print("\n$argc3 $argc4 $argc5 starts...\n");
						break_release_resync_cli($argc3, $argc4, $argc5, $d_nvols, $s_nvols, $s_filer, $s_vols_ref, $d_filer, $d_vols_ref, $main::dpwd, $main::spwd, \@source_dest_filer_vol) if($argc3 eq 'break' && $argc4 eq 'release' && $argc5 eq 'resync');
						#update_break_resync_cli($argc3, $argc4, $argc5, $d_nvols, $s_nvols, $s_filer, $s_vols_ref, $d_filer, $d_vols_ref, $main::dpwd, $main::spwd, \@source_dest_filer_vol) if($argc3 eq 'update' && $argc4 eq 'break' && $argc5 eq 'resync');

						print("\n$argc3 $argc4 $argc5 ends.\n");
					}
				#else
				#	{
				#		print("No operation takes place \n");
				#	}
			#}
=start
=cut

=start
=cut

		}
	}
	print("\n");

}

#main starts.......
my $argc = $#ARGV + 1;
#print $argc;
my $sm = shift;                 #argc1
my $argc1 = $sm;
$main::sm_vol_dest_vol = shift; #argc2
my $argc2 = $main::sm_vol_dest_vol;
my $argc3 = shift;   #argc3 either update|resync|break|release - CLI
my $argc4 = shift;   #argc4 with argv3 
						#(update break)| - CLI
						#(break release)| - CLI
my $argc5 = shift;   #argc5 with argc3 and argc4 
					    #( break release resync )| - CLI
my $argc6 = shift;#argc6 with argc3,argc4 and argc5 
my $argc7 = shift;#argc7 with argc3,argc4, argc5 and argc6
my $argc8 = shift;   #argc8
my $argc9 = shift;   #argc9
my $argc10 = shift;
my $argc11  = shift;

#9 - perl ntapstorage.pl -sm stlfas3170-11:sg_s/stlfas3170-12:sg_d update -ntap_source_user stlfas3170-11:root/Netapp123 -ntap_dest_user stlfas3170-12:root/Netapp123 -encrypted true
#10 - perl ntapstorage.pl -sm stlfas3170-11:sg_s/stlfas3170-12:sg_d update break -ntap_source_user stlfas3170-11:root/Netapp123 -ntap_dest_user stlfas3170-12:root/Netapp123 -encrypted true
#11 - perl ntapstorage.pl -sm stlfas3170-11:sg_s/stlfas3170-12:sg_d break release resync -ntap_source_user stlfas3170-11:root/Netapp123 -ntap_dest_user stlfas3170-12:root/Netapp123 -encrypted true


if ($argc <= 2 || $argc >=6 && $argc <= 8) {
	print_usage();
}

#CLI, WHEN THE USER NOT PROVIDE THE PASSWORD AND BASED ON RSH
#if( $argc == 2 || $argc >= 2 && $ntap_user_resync eq 'resync' || $argc >= 2 && $ntap_user_resync eq 'update' || $argc >= 2 && $ntap_user_resync eq 'update' && $ntap_user_pass eq 'break'){
if( $argc >= 3 && $argc <= 5 ){
	my $string = "CLI based SM Operation Starts...";
	print("\n" . "$string" . "\n" .Underscore_Length($string) . "");
	
	my $switch_selection = 0;
	
	if($argc == 3){
		if ($argc3 eq 'update' || $argc3 eq 'break' || $argc3 eq 'release'|| $argc3 eq 'resync' || $argc3 eq 'initialize'){
			#one parameter execution such as update | break | release | resync
			$switch_selection = 1;
			print("\nOperation(switch_selection): $switch_selection"."\n");
		}else{
			print("\nThe \'$argc3\' is not one of \'update|break|release|resync|initialize\'"."\n");
			exit();
		}
	}elsif($argc == 4){
		if ($argc3 eq 'update' && $argc4 eq 'break' || $argc3 eq 'break' && $argc4 eq 'release' ){
			$switch_selection = 2;
			print("\nOperations(switch_selection): $switch_selection"."\n");
		}else{
			print("\nThe \'$argc3 $argc4\' are not one of \'update break|break release\'"."\n");
			exit();
		}
	}elsif($argc == 5){
		if ($argc3 eq 'break' && $argc4 eq 'release' && $argc5 eq 'resync' ){
           $switch_selection = 3;
           print("\nOperations(switch_selection): $switch_selection"."\n");
        }else{
           print("\nThe \'$argc3 $argc4 $argc5\' are not \'break release resync\'"."\n");
           exit(-1);
        }
	}else{
        print("No operation takes place - $argc1 $argc2 $argc3 $argc4 $argc5 $argc6 $argc7 $argc8 $argc9 ");
    }
	
	print("argc3: $argc3"."\n");
	#CLI_Based_SM_Operatons($ntap_user_resync, $encrypt,$encrypt_value);
	CLI_Based_SM_Operatons($switch_selection, $argc3, $argc4, $argc5, $argc6, $argc7, $argc8, $argc9);
}


#key for blow fish decryption
my $key=pack("H16","0123456789ABCDEF");

if ($argc >= 9 && $argc <= 11) {
	
    my $switch_selection;
	if($argc == 9){
		#checking one operation with source and dest filer username and password
        if ( ($argc3 =~ m!^(update|break|release|resync|initialize)$!) && ($argc4 =~ m!^(-ntap_(src|dest)_user)$!) && ($argc5 =~ m!^[^:/]+:[^:/]+/[^:/]+$!) && ($argc6 =~ m!^(-ntap_(dest|src)_user)$!) && ($argc7 =~ m!^[^:/]+:[^:/]+/[^:/]+$!) && ($argc8 eq '-encrypted') && ($argc9 =~ m!^(true|false)$!) ){
            #one parameter execution such as update | break | release | resync
            $switch_selection = 11;
            print("\nOperation(selection): $switch_selection"."\n");
			$main::spwd = decrypt_pass_fn($argc5, $argc9) if($argc4 eq '-ntap_src_user' && $argc6 ne '-ntap_src_user' && $argc9 eq 'true');
			$main::dpwd = decrypt_pass_fn($argc5, $argc9) if($argc4 eq '-ntap_dest_user' && $argc6 ne '-ntap_dest_user' && $argc9 eq 'true');
			$main::spwd = decrypt_pass_fn($argc7, $argc9) if($argc6 eq '-ntap_src_user' && $argc4 ne '-ntap_src_user' && $argc9 eq 'true');
			$main::dpwd = decrypt_pass_fn($argc7, $argc9) if($argc6 eq '-ntap_dest_user' && $argc4 ne '-ntap_dest_user' && $argc9 eq 'true');
			#print $main::spwd,"\n";
			#print $main::dpwd,"\n";
			#getchar();
        }else{
            print("\nThe \'$argc3\' is not one of \'update|break|release|resync|initialize\'"."\n");
            print("\nOR \'$argc4\' is not one of \'-ntap_src_user|-ntap_dest_user\'"."\n");
            print("\nOR \'$argc5\' is not have  \'\: and \/ separators\'"."\n");
            print("\nOR \'$argc6\' is not one of \'-ntap_src_user|-ntap_dest_user\'"."\n");
            print("\nOR \'$argc7\' is not have  \'\: and \/ separators\'"."\n");
            print("\nOR \'$argc8\' is not \'-encrypted\'"."\n");
            print("\nOR \'$argc9\' is not one of \'true|false\'"."\n");
            exit();
        }
    }
	elsif($argc == 10){
        if ( ( $argc3 eq 'update' && $argc4 eq 'break' || $argc3 eq 'break' && $argc4 eq 'release') && ($argc5 =~ m!^(-ntap_(src|dest)_user)$!) && ($argc6 =~ m!^[^:/]+:[^:/]+/[^:/]+$!) && ($argc7 =~ m!^(-ntap_(dest|src)_user)$!) && ($argc8 =~ m!^[^:/]+:[^:/]+/[^:/]+$!) && ($argc9 eq '-encrypted') && ($argc10 =~ m!^(true|false)$!) ){
			
            #two parameter execution such as update  break | break release
            $switch_selection = 22;
            print("\nOperation(switch_selection): $switch_selection"."\n");
			$main::spwd = decrypt_pass_fn($argc6, $argc10) if($argc5 eq '-ntap_src_user' && $argc7 ne '-ntap_src_user' && $argc10 eq 'true');
			$main::dpwd = decrypt_pass_fn($argc6, $argc10) if($argc5 eq '-ntap_dest_user' && $argc7 ne '-ntap_dest_user' && $argc10 eq 'true');
			$main::spwd = decrypt_pass_fn($argc8, $argc10) if($argc7 eq '-ntap_src_user' && $argc5 ne '-ntap_src_user' && $argc10 eq 'true');
			$main::dpwd = decrypt_pass_fn($argc8, $argc10) if($argc7 eq '-ntap_dest_user' && $argc5 ne '-ntap_dest_user' && $argc10 eq 'true');
        }else{
            print("\nThe \'$argc3 $argc4 \' is not one of \'update break\'|'break release\'"."\n");
            print("\nOR \'$argc5\' is not one of \'-ntap_src_user|-ntap_dest_user\'"."\n");
            print("\nOR \'$argc6\' is not have  \'\: and \/ separators\'"."\n");
            print("\nOR \'$argc7\' is not one of \'-ntap_src_user|-ntap_dest_user\'"."\n");
            print("\nOR \'$argc8\' is not have  \'\: and \/ separators\'"."\n");
            print("\nOR \'$argc9\' is not \'-encrypted\'"."\n");
            print("\nOR \'$argc10\' is not one of \'true|false\'"."\n");
            exit();
        }
	}
	elsif($argc == 11){
        if ( ( $argc3 eq 'break' && $argc4 eq 'release' && $argc5 eq 'resync') && ($argc6 =~ m!^(-ntap_(src|dest)_user)$!) && ($argc7 =~ m!^[^:/]+:[^:/]+/[^:/]+$!) && ($argc8 =~ m!^(-ntap_(dest|src)_user)$!) && ($argc9 =~ m!^[^:/]+:[^:/]+/[^:/]+$!) && ($argc10 eq '-encrypted') && ($argc11 =~ m!^(true|false)$!) ){

            #two parameter execution such as update  break | break release
            $switch_selection = 33;
            print("\nOperation(switch_selection): $switch_selection"."\n");
			$main::spwd = decrypt_pass_fn($argc7, $argc11) if($argc6 eq '-ntap_src_user' && $argc8 ne '-ntap_src_user' && $argc11 eq 'true');
			$main::dpwd = decrypt_pass_fn($argc7, $argc11) if($argc6 eq '-ntap_dest_user' && $argc8 ne '-ntap_dest_user' && $argc11 eq 'true');
			$main::spwd = decrypt_pass_fn($argc9, $argc11) if($argc8 eq '-ntap_src_user' && $argc6 ne '-ntap_src_user' && $argc11 eq 'true');
			$main::dpwd = decrypt_pass_fn($argc9, $argc11) if($argc8 eq '-ntap_dest_user' && $argc6 ne '-ntap_dest_user' && $argc11 eq 'true');
        }else{
            print("\nThe \'$argc3 $argc4 $argc5 \' is not  \'break release resync\'"."\n");
            print("\nOR \'$argc6\' is not one of \'-ntap_src_user|-ntap_dest_user\'"."\n");
            print("\nOR \'$argc7\' is not have  \'\: and \/ separators\'"."\n");
            print("\nOR \'$argc8\' is not one of \'-ntap_src_user|-ntap_dest_user\'"."\n");
            print("\nOR \'$argc9\' is not have  \'\: and \/ separators\'"."\n");
            print("\nOR \'$argc10\' is not \'-encrypted\'"."\n");
            print("\nOR \'$argc11\' is not one of \'true|false\'"."\n");
            exit();
        }
	}
	else{
        print("No operation takes place - $argc1 $argc2 $argc3 $argc4 $argc5 $argc6 $argc7 $argc8 $argc9 $argc10 $argc11 ");
	}

	CLI_Based_SM_Operatons($switch_selection, $argc3, $argc4, $argc5, $argc6, $argc7, $argc8, $argc9, $argc10, $argc11);
}



#encryption decryption starts
#######################################################################################
# uncomment 'use Crypt::Blowfish;' & remove =start to enable password encryption      #
#######################################################################################
use Crypt::Blowfish;
#=start
#######################################################################################
# PLEASE DO NOT CHANGE BELOW THIS LINE												  #
#######################################################################################

sub encrypt_8_chars{

  my $plain_text=$_[0];
  my $encrypted_data;
  my $encrypted_text;
  my $cipher = new Crypt::Blowfish $key;

  # Enlarge the string to 8 characters by appending with NULL characters
  while(length($plain_text) < 8){
    $plain_text=sprintf("%s\0",$plain_text);
  }

  $encrypted_data=$cipher->encrypt($plain_text); # Take the string and encrypt using blowfish
  $encrypted_text=unpack("H16",$encrypted_data);

  return $encrypted_text;
} # encrypt_8_chars

sub decrypt_8_chars{

  my $encrypted_text=$_[0];
  my $encrypted_data;
  my $plain_text;
  my $cipher = new Crypt::Blowfish $key;

  $encrypted_data=pack("H16",$encrypted_text);
  $plain_text=$cipher->decrypt($encrypted_data); # Take the string and decrypt using blowfish

  $plain_text =~ s/\0//g; # Shrink the string by removing appended with NULL characters

  return $plain_text;
} # decrypt_8_chars

sub encrypt_text{

  my $plain_text=$_[0];
  my @plain_chunks;
  my $plain_chunk;
  my $encrypted_text="";

  @plain_chunks=($plain_text =~ /.{1,8}/g); # Chop any size of the text into up to 8 charachers and put each chunk into an array

  foreach $plain_chunk (@plain_chunks){
    $encrypted_text=sprintf("%s%s",$encrypted_text,encrypt_8_chars($plain_chunk));
  }

  return $encrypted_text;
} # encrypt_text


sub decrypt_text{

  my $encrypted_text=$_[0];
  my @encrypted_chunks;
  my $encrypted_chunk;
  my $plain_text="";

  @encrypted_chunks=($encrypted_text =~ /.{1,16}/g); # Chop any size of the text into up to 16 charachers and put each chunk into an array

  foreach $encrypted_chunk (@encrypted_chunks){
    $plain_text=sprintf("%s%s",$plain_text,decrypt_8_chars($encrypted_chunk));
  }

  return $plain_text;
} # decrypt_text

sub decrypt_pass_fn {
    my ($filer_user_pass, $encrypted_value) = @_;

    my ($filer,$user_pwd) = split("\:",$filer_user_pass);
    my ($user,$pwd ) = split("\/",$user_pwd);

    #decrypt the password for API connection to filer
    my $decrypted;
    if($encrypted_value eq 'true') {
        $decrypted=decrypt_text($pwd);
        #printf("The decrypted value of %s is %s\n",$pwd,$decrypted);
        $pwd = $decrypted;
    }
    return $pwd;

}

#encryption decryption ends


 
