#!/bin/sh
#
# $Header: emas/sysman/admin/scripts/siteguard/switchoverStorage.sh /main/1 2012/05/31 13:53:48 mrdesai Exp $
#
# switchoverStorage.sh
#
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      switchoverStorage.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    mrdesai     05/31/12 - Creation
#

# Script to role reverse the target Sun Storage Appliance

Usage() {
        echo ''
        echo "Usage: $0 -u <Appliance user> -h <Appliance> -j <ProjectName> -p <PoolName> -s <SourceId>"
        echo ''
        exit 1;
}

#***********************************************
#Script argument validation
#***********************************************

if [ $# -ne 10 ] ; then
        Usage;
fi

user=
appliance=
projectName=
poolName=
sourceId=

statusFlag=
PoolNotFoundMsg=
ProjectNotFoundMsg=
SourceNotFoundMsg=
UnknownErrorMsg=

# Shell script main
PROG=$0

# Check used command line options
while getopts u:h:j:p:s: flag
do
        case "$flag" in
                u) user="$OPTARG";;
                h) appliance="$OPTARG";;
                j) projectName="$OPTARG";;
                p) poolName="$OPTARG";;
                s) sourceId="$OPTARG";;
                \?) Usage $PROG ;;
        esac
done

PoolNotFoundMsg="[SG-ERROR-100] - Specified pool '$poolName' not found";
ProjectNotFoundMsg="[SG-ERROR-101] - Specified project '$projectName' not found";
SourceNotFoundMsg="[SG-ERROR-102] - Specified sourceId '$sourceId' not found";
UnknownErrorMsg="[SG-ERROR-999] - Unexpected script error";

echo ''

[ -z "$user" -o -z "$appliance" -o -z "$projectName" -o -z "$poolName" -o -z "$sourceId" ] && Usage $PROG

ssh -T "$user"@"$appliance" << EOF

script
{
        var SiteGuardArguments = {
                projectName: '$projectName',
                poolName: '$poolName',
                sourceId: '$sourceId'
        }


        function deleteExistingProject(projectName, poolName)
        {
                printf("\n\nMaking sure project '" + projectName  + "' do not exist before on the standby appliance \n");

                run ('cd /');
                run ('shares');

                try {
                        run ('set pool=' + poolName);
                } catch (err) {
                        printMessage("$PoolNotFoundMsg");
                }

                try {
                        run ('select ' + projectName);
                        run ('confirm destroy');
                } catch (err) {
                        printf("\nNo Project to be deleted... \n");
                }
        }

        function getSourcePackages(poolName, sourceId)
        {
                printf("\nSelecting the packages for source: " + sourceId + "\n");
                run ('cd /');
                run ('shares');

                try {
                        run ('set pool=' + poolName);
                } catch (err) {
                        printMessage("$PoolNotFoundMsg");
                }

                try {
                        run('replication sources select ' + sourceId);
                } catch (err) {
                        printMessage("$SourceNotFoundMsg");
                }

                var packages = list();

                return packages;
        }

	function roleReverseProject(SiteGuardArgs)
        {
                deleteExistingProject(SiteGuardArgs.projectName, SiteGuardArgs.poolName);
                var packages = getSourcePackages(SiteGuardArgs.poolName, SiteGuardArgs.sourceId);

                for (var i = 0; i < packages.length; i++) {
                        run('select ' + packages[i]);
                        var projName = list();

                        if (projName[0] == SiteGuardArgs.projectName) {
                                package = packages[i] ;
                                run('confirm reverse');
                                printf("\nProject Details after reversal \n");
                                run('show');
                                printf("\nSource and the target roles are reversed now..\n");
                                reverseReplication(SiteGuardArgs.projectName, SiteGuardArgs.poolName);
                                printf("\nReplication direction is reversed also\n");

                                break;
                        }//EOF if

                        run('cd ..');
                }//EOF for

                printf("\nThe package chosen to role reverse : %s \n", package);

                return package;
        }

        function reverseReplication(projectName, poolName)
        {
                run('cd /');
                run('shares');

                try {
                        run('set pool=' + poolName);
                } catch (err) {
                        printMessage("$PoolNotFoundMsg");
                }

                try {
                        run('select ' + projectName + ' replication');
                } catch (err) {
                        printMessage("$ProjectNotFoundMsg");
                }

                run('select action-000');
                run('set continuous=true');
                run('commit');
        }

        function printMessage(msg)
        {
                printf("\n" + msg + "\n");

                exit ( 1 );
        }

	roleReverseProject(SiteGuardArguments);

}

EOF

echo ''

