#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/soa/getSOADBProps.pl /main/7 2012/06/11 05:36:52 ankurku Exp $
#
# getSOADBProps.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getSOADBProps.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    kotkumar    05/05/10 - Creation
#

use strict;
use ias::simpleXPath;
use ias::asecm;
my $domainHome = $ARGV[0]; #"/home/kotkumar";
my $dsFile;
my $fileExists = "false";
my $isCluster = "false";

#TODO - Need to remove the hard-coding, replace with agent stage location.
#my $soaConfigFilesLoc = "/scratch/kotkumar/mds/";
my $soaConfigFilesLoc = $ARGV[1];

my $domainName = $ARGV[2];

$soaConfigFilesLoc = $soaConfigFilesLoc . $domainName ;

# If the rac db is used for soa, the jdbc connection url is available in the file SOADataSource-rac0-jdbc.xml
# Otherwise the connection url is available in the SOADataSource-jdbc.xml

if(-e  "$domainHome/config/jdbc/SOADataSource-rac0-jdbc.xml")
{
        $dsFile = "$domainHome/config/jdbc/SOADataSource-rac0-jdbc.xml";
	$isCluster = "true";
	$fileExists = "true";
}
elsif(-e "$domainHome/config/jdbc/SOADataSource-jdbc.xml")
{
        $dsFile = "$domainHome/config/jdbc/SOADataSource-jdbc.xml";
	$fileExists = "true";
}

if( $fileExists  eq "true")
{
	#Obtainin the url
	my $url = (ias::simpleXPath::simpleXPathQueryForText($dsFile, 'jdbc-data-source/jdbc-driver-params/url'))[0];
	my $host;
	my $port;
	my $servicename;
        my $username;
        my $schemaname;
	if($isCluster eq "true")
	{
		#In a clustered mode the url pattern -- jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=<Host>)(PORT=<Port>)))(CONNECT_DATA=(SERVICE_NAME=<Service Name>)(INSTANCE_NAME=tracdb)))
		 if($url =~ /.+HOST=(.+)\)\(PORT=(\d+)\)\)\)\(CONNECT_DATA=\(SERVICE_NAME=(.+)\)\(.+\)/) 
		{
        		$host =  $1;
        		$port = $2;
        		$servicename = $3;
                        $username = (ias::simpleXPath::simpleXPathQueryForText($dsFile, 'jdbc-data-source/jdbc-driver-params/properties//property/value'))[0];
                      $schemaname = uc ($username);
        	}
	}

	else
	{
		#In a non-clustered mode the url pattern -- jdbc:oracle:thin:@<Host>:<Port>:<SID>
		if($url =~ /.+\@(.+):(.+):(.+)/)
		{
			$host =  $1;
                	$port = $2;
                	$servicename = $3;
			$username = (ias::simpleXPath::simpleXPathQueryForText($dsFile, 'jdbc-data-source/jdbc-driver-params/properties//property/value'))[0];
		      $schemaname = uc ($username);

		}
		
		else
		{
		    #In a non-clustered mode the url pattern -- jdbc:oracle:thin:@<Host>:<Port>/<ServiceName>
                    if($url =~ /.+\@(.+):(.+)\/(.+)/)
                    {
                        $host =  $1;
                        $port = $2;
                        $servicename = $3;
                        $username = (ias::simpleXPath::simpleXPathQueryForText($dsFile, 'jdbc-data-source/jdbc-driver-params/properties//property/value'))[0];
	
                      $schemaname = uc ($username);

                     }
		}
	}

	$url = substr $url,index($url,'@') + 1;

	ias::asecm::printResult(
     		$url, 'string',
     		$host,      'string',
     		$port, 'string',
     		$servicename,   'string',
                $schemaname,  'string',
		$soaConfigFilesLoc, 'string',"true",'string');
}
# If the file does not exists, we are filling  url, host, port, servicename as empty strings.
# This else block is needed inorder to avoid the warning messages in the agent logs.
else
{
	ias::asecm::printResult(
                '', 'string',
                '', 'string',
                '', 'string',
                '', 'string',
                '', 'string',
		$soaConfigFilesLoc, 'string',
                 "true",'string');

}
