#!/usr/local/bin/perl
# 
# $Header: emai/sysman/admin/scripts/soa/getSOAMetric.pl /main/7 2011/11/21 01:35:33 kotkumar Exp $
#
# getSOAMetric.pl
# 
# Copyright (c) 2009, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getSOAMetric.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    kotkumar    03/17/11 - PS3 support dependency
#    kotkumar    07/10/09 - Creation
#

use strict;
use soa::jdkHomeProvider;
my $host = $ARGV[0]; 
my $port = $ARGV[1];
my $userName = $ARGV[2];
my $msgType = $ARGV[3];
my $msgState = $ARGV[4];
my $compositeName = $ARGV[5];
my $compositeRev = $ARGV[6];
my $componentName = $ARGV[7];
my $weblogicHome = $ARGV[8];
my $soaHome  = $ARGV[9];
my $javaHomeProvidedByDiscovery = $ARGV[10];
my $version = $ARGV[11];
my $msgCnt = $ARGV[12];
#my $AgentHome = "/ade/kotkumar_ptv6_ag/oracle/emagent/";
my $metricName = "soainfra.recoverymsgfault.fabric.metric";

my $AGENT_PLUGIN_ROOT = $ENV{'PLUGIN_ROOT'};
# my  $AGENT_PLUGIN_ROOT = "../../";

my $seperator;
my $pathSeperator;
my $COMMAND;

if(!&IsWindows())
{
        $pathSeperator = "/";
        $seperator = ":";
}
else
{
        $pathSeperator = "\\";
        $seperator = ";";
}

print "comp rev-".$compositeRev;
setClasspath();
my $JVM_MEM_ARGS=" -Xms10m -Xmx64m ";

# Obtain the jdk home using the util function
my $jdkHome = getJdkHome($javaHomeProvidedByDiscovery,$weblogicHome.$pathSeperator."..",$ENV{'ORACLE_HOME'});

$COMMAND = $jdkHome.$pathSeperator."bin".$pathSeperator."java ".$JVM_MEM_ARGS." oracle.sysman.emas.fetchlets.soa.SOAMetricUtil $metricName $host $port $userName $msgType $msgState $compositeName $compositeRev $componentName $msgCnt"; 
system($COMMAND);

sub setClasspath
{
	print $ENV{'ORACLE_HOME'};
#	$ENV{'CLASSPATH'} = $weblogicHome."/server/lib/weblogic.jar:".$weblogicHome."/../oracle_common/soa/modules/oracle.soa.mgmt_11.1.1/soa-infra-mgmt.jar:".$ENV{'ORACLE_HOME'}."/sysman/jlib/emagentRT.jar:".$ENV{'ORACLE_HOME'}."/sysman/jlib/emagentSDK.jar:".$ENV{'ORACLE_HOME'}."/sysman/jlib/log4j-core.jar:".$weblogicHome."/../soa8478/soa/modules/oracle.soa.fabric_11.1.1/oracle-soa-client-api.jar";

	$ENV{'CLASSPATH'} = $weblogicHome.$pathSeperator."server".$pathSeperator."lib".$pathSeperator."weblogic.jar".$seperator.$weblogicHome.$pathSeperator."..".$pathSeperator."oracle_common".$pathSeperator."soa".$pathSeperator."modules".$pathSeperator."oracle.soa.mgmt_11.1.1".$pathSeperator."soa-infra-mgmt.jar".$seperator.$soaHome.$pathSeperator."soa".$pathSeperator."modules".$pathSeperator."oracle.soa.fabric_11.1.1".$pathSeperator."oracle-soa-client-api.jar".$seperator.$weblogicHome.$pathSeperator."..".$pathSeperator."oracle_common".$pathSeperator."modules".$pathSeperator."oracle.jrf_11.1.1".$pathSeperator."jrf-api.jar".$seperator.$AGENT_PLUGIN_ROOT.$pathSeperator."archives".$pathSeperator."em-as-fmw-fetchlet.jar";
	print $ENV{'CLASSPATH'};

	
}



sub IsWindows
{
    my $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else
    {
        return 0;
    }
}
