
package soa::jdkHomeProvider;

use strict;
use Exporter 'import';

our @EXPORT = qw(
    getJdkHome
);

#
# This function is used to obtain the right jdk home based on the provided
# parameters
#
# Arguments
#    0: Java Home published by the discovery team
#    1: Middleare home
#    2: Agent home
# 
# Returns - jdk home
#

sub getJdkHome
{
    my $javaHomeProvidedByDiscovery   = shift(@_);
    my $mwHome     = shift(@_);
    my $agentHome  = shift(@_);

    # print "javaHomeProvidedByDiscovery - ".$javaHomeProvidedByDiscovery;
    # print "mwHome - ".$mwHome;
    # print "agentHome - ".$agentHome;
   
    my $jdkHome;
    my $filename;
    
    my $pathSep = getPathSep();
    # If the disocvery team does not provided the jdk
    if(($javaHomeProvidedByDiscovery eq "NULL") or ($javaHomeProvidedByDiscovery eq "null") )
    {
	my $foundJdk = 0;
	# Validate whether jdk was available in the provided  middleware or not
	opendir (DIR, $mwHome ) || die "Error in opening dir $mwHome\n";
	while(($filename = readdir(DIR)) and ($foundJdk == 0))
	{
	    my $temp1 = rindex $filename, "jdk", 1;
	    my $temp2 = rindex $filename, "jrockit", 1;
	    if ($temp1 == 0 or $temp2 == 0) {
        	$jdkHome = $mwHome.$pathSep.$filename;
		$foundJdk = 1;
	    }
	}
	closedir(DIR);
	# If the jdk was not available in the middleware home, use the available jdk on the agent side
 	if($foundJdk == 0)	
	{
	    $jdkHome = $agentHome.$pathSep.'jdk';
	}
    }
    # If the disocvery team does not provided the jdk
    else
    {
	# Validate whether the java home is exist and it has read permissions
        if(-e $javaHomeProvidedByDiscovery and -r $javaHomeProvidedByDiscovery)
        {
            $jdkHome = $javaHomeProvidedByDiscovery;
        }
	# If the java home path is not valid, use the jdk from agent home.
	else
	{
	    $jdkHome = $agentHome.$pathSep.'jdk';
	}


    }
	
    return $jdkHome;
}

sub getPathSep()
{
	my $sep;
        my $os = $^O;
	if (($os ne "MSWin32") && ($os ne "MSWin64") && ($os ne "Windows_NT"))
	{
        	$sep = "/";
	}
        else
    	{
        	$sep = "\\";
    	}
        return $sep;

}

