#!/usr/local/bin/perl
# 
# $Header: emai/sysman/admin/scripts/soa/printWebLogicAssociations.pl /main/1 2011/02/23 04:48:45 rrampall Exp $
#
# printWebLogicAssociations.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      printWebLogicAssociations.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rrampall    02/10/11 - Creation
#

use strict;

my $hostName = shift(@ARGV);
my $oracleHome = shift(@ARGV);

# Find the last association with a unique type, that has a target name
my %assocs = ();
for my $assoc (@ARGV)
{
    my @params = split('\|', $assoc);
    my $assocType = $params[0];
    my $targetName = $params[1];
    if ($targetName eq '' || $targetName =~ /^%.*%$/)
    {
        # Target name is missing
        next;
    }
    $assocs{$assocType} = $assoc;
}
# Print associations including the target property <host name>:<oracle home>
for my $assocType (keys %assocs)
{
    my $assoc = $assocs{$assocType};
    print "em_result=$assoc|$hostName:$oracleHome\n";
}
 
