#!/usr/local/bin/perl
# 
# $Header: emai/sysman/admin/scripts/soa/swb_soa_jmx.pl /main/1 2011/02/19 07:08:33 kotkumar Exp $
#
# swb_soa_jmx.pl
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      swb_soa_jmx.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    kotkumar    12/06/10 - Creation
#

use IPC::Open2;
use ParseStdin;

require "emd_common.pl"; 

# Begin script
EMD_PERL_DEBUG("\nStarted SWB script - swb_soa_jmx.pl");

# OS-specific path/classpath separators
my $pathSep = "/";
my $cpSep = ":";
if (( $^O =~ "Windows" ) || ($^O =~ "MSWin32"))
{
  $pathSep = "\\";
  $cpSep = ";";
}

# Initialize environment
my $emdRoot;
my $oraHome; 
my $sysParam;
my $plugin_root;

if (defined($ENV{EMDROOT}))
{
 $emdRoot=$ENV{EMDROOT};
}
if (defined($ENV{ORACLE_HOME}))
{
 $oraHome=$ENV{ORACLE_HOME};
}
if (defined($ENV{SYSTEM_PARAM}))
{
 $sysParam = $ENV{SYSTEM_PARAM};
}
if (defined($ENV{PLUGIN_ROOT}))
{
 $plugin_root = $ENV{PLUGIN_ROOT};
}

# Initialize variables
my $command;
my $targetName;
my $targetType;
my $serviceUrl;
my $language;
my $country;
my $variant;
my $sslListenPortEnabled;
my $username;
my $password ;
my $commandParams ;
my $dumpName ;
my $incidentId ;
my $adrHome ;

$command = shift(@ARGV);
$targetName = shift(@ARGV);
$targetType = shift(@ARGV);
$serviceUrl = shift(@ARGV);
$language = shift(@ARGV);
$country = shift(@ARGV);
$variant = shift(@ARGV);
$sslListenPortEnabled = shift(@ARGV);
$username = shift(@ARGV);

if($command eq "CREATE_SOA_INCIDENT")
{
  # We have to create a user reported problem. Initialize the params
  $incidentTypeId = shift(@ARGV);
  $adrHome = shift(@ARGV);
  $commandParams = " -incidentTypeId $incidentTypeId -adrHome $adrHome ";
}
#Read and initialize additional parameters for specific actions
elsif ($command eq "EXECUTE_SOA_DUMP")
{
  # We have to execute the dumps. Initialize the params
  $dumpName = shift(@ARGV);
  $incidentId = shift(@ARGV);
  $adrHome = shift(@ARGV);
  $commandParams = " -dumpName $dumpName -incidentId $incidentId -adrHome $adrHome ";

  #Loop through the rest of the arguments and create the other parameters
  while (scalar(@ARGV) > 0)
  {
    $commandParams = $commandParams . " -userActionArg " . shift(@ARGV) . " " . shift(@ARGV);
  }
}


# Read the password from STDIN
$password = <STDIN>;
chomp($password);
my ($name, $value) = split /=/,$password,2;
if($value ne "")
{
  $password = $value;
}

# Initialize JAVA_HOME
$JAVA_HOME=$oraHome.$pathSep."jdk";
die "Cannot determine JAVA_HOME\n" if (($JAVA_HOME eq "") || (! -e "$JAVA_HOME".$pathSep."bin"));

# Initialize CLASSPATH
my $agentJarLoc="$emdRoot".$pathSep."jlib";
my $agentJarFiles=$agentJarLoc.$pathSep."emagentSDK.jar".$cpSep.$agentJarLoc.$pathSep."log4j-core.jar";

my $emasPluginJarsLoc="$plugin_root".$pathSep."archives".$pathSep."jlib";
my $emasPluginJarFiles=$emasPluginJarsLoc.$pathSep."emd_java.jar".$cpSep.$emasPluginJarsLoc.$pathSep."wljmxclient.jar".$cpSep.$emasPluginJarsLoc.$pathSep."wlclient.jar";

my $sysParamAll = "";
my $weblogicJars= $emasPluginJarFiles;
my $agentTrust = $oraHome."$pathSep"."sysman"."$pathSep"."config"."$pathSep".montrust."$pathSep"."AgentTrust.jks";

if(-r "$emasPluginJarsLoc"."$pathSep"."wlfullclient.jar")
{
   $weblogicJars= $emasPluginJarsLoc.$pathSep."wlfullclient.jar";
}

 $sysParamAll = $sysParam . "  -Dweblogic.security.TrustKeyStore=$fileKeyStore";


#Initialize the classpath and command
my $fullCP = $agentJarFiles.$cpSep.$emasPluginJarFiles.$cpSep.$weblogicJars;
my $cmd = "$JAVA_HOME/bin/java -DHOSTNAME=$hostname $sysParamAll -cp $fullCP oracle.sysman.emas.sdk.swb.SwbSOAJmxUtil -command $command -targetName $targetName -targetType $targetType -serviceUrl $serviceUrl -language $language -country $country -variant $variant -username $username $commandParams";

#print "Command - $cmd";

# Write the password to STDIN so that the Java program can read it  
local(*WRITE);
my $pid = open2(SWB_JMX_CALL, *WRITE, $cmd);
print WRITE "$password\n";
close(WRITE);

# Invoke the command and return the result 
@targetLines = <SWB_JMX_CALL>;
close(SWB_JMX_CALL);
print @targetLines;

EMD_PERL_DEBUG("\nExecuted SWB script - swb_soa_jmx.pl");

