#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/soaprov/soaprov_fetch_owsm_policies.pl /main/5 2012/04/15 03:56:09 rahgupta Exp $
#
# soaprov_fetch_owsm_policies.pl
# 
# Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      soaprov_fetch_owsm_policies.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ajaganna    02/21/11 - Add Jar
#    ajaganna    02/21/11 - Adding to classpath
#    ajaganna    02/02/11 - Fixing Location
#    rkuriako    02/25/10 - get java home from setDomainEnv.sh for ports
#    rkuriako    01/06/10 - win porting
#    rkuriako    11/04/09 - Creation
# 
use File::Spec::Functions;

my $providerUrl = $ARGV[0];
my $soaInfraHome = $ARGV[1];
my $wlHome = $ARGV[2];
my $tempOrPolicies = $ARGV[3];
my $mwHome = $ARGV[4];

my $jdkFolder;
my $foundJdk = 0;

opendir (DIR, $mwHome ) || die "Error in opening dir $mwHome\n";
while(($filename = readdir(DIR)) and ($foundJdk == 0)){
    my $temp1 = rindex $filename, "jdk", 1;
    my $temp2 = rindex $filename, "jrockit", 1;
    if ($temp1 == 0 or $temp2 == 0) {
        $jdkFolder = $filename;
        $foundJdk = 1;
    }

    #TODO remove later
    # my $temp3 = rindex $filename, "soa", 1;
    #my $temp4 = rindex $filename, "Oracle_", 1;
    #if ($temp3 == 0 or $temp4 == 0) {
    #    $soaInfraHome = $filename;
    #                
    #}

}
closedir(DIR);

#set java location for linux and windows
my $javaFile = catfile($mwHome, $jdkFolder, 'bin', 'java');

#following code is required to get java_home in porting platforms
if($foundJdk != 1)
{
my $findSunJdk = "SUN_JAVA_HOME\=\"";
my $findBeaJdk = "BEA_JAVA_HOME\=\"";
my $beaJdkLoc;
my $sunJdkLoc;

#soaInfraHome is actually DOMAIN_HOME
my $domainenvPath = catfile($soaInfraHome, 'bin', 'setDomainEnv.sh');
open FILE, "<$domainenvPath";
my @lines = <FILE>;
for (@lines) {

    if ($_ =~ /^$findSunJdk/) {
        $sunJdkLoc = $_;
        chomp($sunJdkLoc);
        $sunJdkLoc = substr($sunJdkLoc,14);
        if(length($sunJdkLoc) > 4){
          $sunJdkLoc =~ s/"//g;
          #print "got : $sunJdkLoc\n";
          $jdkFolder = $sunJdkLoc;
          $javaFile = catfile($jdkFolder, 'bin', 'java');
          last;
        }
     }

    if ($_ =~ /^$findBeaJdk/)
    {
        $beaJdkLoc = $_;
        chomp($beaJdkLoc);
        $beaJdkLoc = substr($beaJdkLoc,14);
        if(length($beaJdkLoc) > 4){
         $beaJdkLoc =~ s/"//g;
         #print "got : $beaJdkLoc\n";
         $jdkFolder = $beaJdkLoc;
         $javaFile = catfile($jdkFolder, 'bin', 'java');
         last;
        }
    }
}

}

my $AGENT_PLUGIN_ROOT = $ENV{'PLUGIN_ROOT'};
my $wsmlibdir = catfile($mwHome,'oracle_common', 'modules', 'oracle.wsm.common_11.1.1');
my $wsmstandalonedir = catfile($mwHome,'oracle_common', 'modules', 'oracle.webservices_11.1.1');
my $wsmpmlibjar = catfile($wsmlibdir, 'wsm-pmlib.jar');
my $wsmpolicycorejar = catfile($wsmlibdir, 'wsm-policy-core.jar');
my $wsmstandalone = catfile($wsmstandalonedir, 'oracle.webservices.standalone.client.jar');
my $wsmsecpoljar = catfile($wsmlibdir, 'wsm-secpol.jar');
my $wsmjseclientjar = catfile($wsmlibdir, 'wls-jse-client-wsm-dependencies.jar');
my $weblogicjar = catfile($wlHome, 'server', 'lib', 'weblogic.jar');
my $emdjar = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib', 'emd_java.jar');
#populated by generic or port specific logic
#my $javaFile = catfile($mwHome, $jdkFolder, 'bin', 'java'); 

#TODO handle window classpath
    my $classpath;

    if(!&IsWindows() ) 
    {
     $classpath = $wsmpmlibjar  .':'. $internaljpsjar .':'. $wsmstandalone . ':' . $wsmpolicycorejar . ':' . $wsmsecpoljar . ':' . $wsmjseclientjar . ':' . $weblogicjar . ':' . $emdjar;
    }
    else
    {
      $classpath = $wsmpmlibjar . ';' . $wsmstandalone . ';' . $wsmpolicycorejar . ';' . $wsmsecpoljar . ';' . $wsmjseclientjar . ';' . $weblogicjar . ';' . $emdjar;
      $classpath =~ s/\\/\\\\/g;
    }



print "CLASSPATH :  $classpath\n";

my $className = "oracle.sysman.emas.model.soaprov.artifacts.WebServicesModel";

#TODO handle windows cmd
my $command = $javaFile . ' -classpath ' . $classpath . ' ' . $className . ' ' . $providerUrl . ' ' . $tempOrPolicies;

print "CMD : $command\n";

#TODO handle win
my $output =  system($command);
print $output;

sub IsWindows {
    $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}
