#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/soaprov_storeinfo.pl /main/2 2011/04/29 07:58:00 smariswa Exp $
#
# soaprov_storeinfo.pl
# 
# Copyright (c) 2009, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      soaprov_storeinfo.pl - Invoke java class AdapterValidator which validates the composites for adapter dependencies
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    smariswa    04/28/11 - Fix ClassPath
#    rummadi     08/07/09 - Creation
#

use File::Spec::Functions;

my $serviceUrl = $ARGV[0];
my $storeType = $ARGV[1];
my $agentHome = $ENV{ORACLE_HOME};
my $AGENT_PLUGIN_ROOT = $ENV{'PLUGIN_ROOT'};
my $java = catfile($agentHome, 'jdk', 'bin', 'java');
my $emdjavajar = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib', 'emd_java.jar');
my $wljmxclientjar = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib', 'wljmxclient.jar');

my $classpath;

    if(!&IsWindows() ) 
    {
      $classpath = $emdjavajar . ':' . $wljmxclientjar;
    }
    else
    {

       $classpath = $emdjavajar . ';' . $wljmxclientjar;
       $classpath =~ s/\\/\\\\/g;
    }


my $className = 'oracle.sysman.emas.model.soaprov.artifacts.StoreProviderInfoEMDClient';
my $command = $java . ' -classpath ' . $classpath . ' ' . $className . ' ' . $serviceUrl . ' ' . $storeType;

print `$command`;
#my $output =  system($command);
#print $output;



sub IsWindows {
    $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}
