#  $Header: sso_get_ldap_target.pl 15-may-2006.17:56:53 amaywah Exp $
#
# Copyright (c) 2006, Oracle. All rights reserved.  
#
#    NAME
#      sso_get_ldap_target.pl
#
#    DESCRIPTION
#      This script gets the LDAP target name from OID
#      It takes one argument - the oracle home of the sso install
#
#    NOTES
#       Usage: perl get_ldap_target.pl <oraclehome> 
#       Note: The last line is the return message -
#              DO NOT add "\n" in print statement without test.
#
#    MODIFIED   (MM/DD/YY)
#       amaywah  05/15/06 - Bug 5227101: fix ldap search query 
#       amaywah  05/10/06 - Creation - Needed for ldap target name config 
#                           metric. 
#

my ($ohm) = @ARGV;
$ENV{ORACLE_HOME} = $ohm;

if($ohm eq "")
{
  print "em_error=Please set oracle home on command line.\n";
  exit(1);
}

#The ldap entry attribute that we want
my $ldapTargetAttrib = "orclEMTargetName";
my $dsaConfigDN = "cn=dsaconfig,cn=configsets,cn=oracle internet directory";

#First get iAS Properties
my $propArray = getiASProperties($ohm);

my $hostname = $propArray->[0];
my $useSSL = $propArray->[3];
my $port = "";
my $sslFlag = "";
my $out = "";

if ($useSSL =~ m/true/i) 
{
  #use the SSL port
  $port = $propArray->[2];
  $sslFlag = "-U 1";
} else {
  #use the non-SSL port
  $port = $propArray->[1];
  $sslFlag = "";
}

# Do an ldap bind
$cmd = "$ohm/bin/ldapbind $sslFlag -h $hostname -p $port";
#print "DEBUG: $cmd\n";
open (F, "$cmd |");
while(<F>) 
{
  chomp;
  # print either bind successful or error message
  #print;
  $out = $out . $_;
}

if(!$out =~ /successful/)
{
  print "em_error=\"" . $out . "\"\n";
  print "em_error=unable to connect to ldap server at host $hostname and port $port.\n"; 
  exit(-1);
}

#print "$ohm/bin/ldapsearch $sslFlag -h $hostname -p $port -b \"$dsaConfigDN\" -s base \"objectclass=*\" $ldapTargetAttrib |grep -i $ldapTargetAttrib |cut -f2 -d =\n";

$VAL = `$ohm/bin/ldapsearch $sslFlag -h $hostname -p $port -b \"$dsaConfigDN\" -s base \"objectclass=*\" $ldapTargetAttrib |grep -i $ldapTargetAttrib |cut -f2 -d =`;

print ("em_result=$VAL");

exit 0;


# Get properties from the ias.properties file.  This includes:
# 1. the ldap host (OIDhost)
# 2. the ldap port (OIDport)
# 3. the ldap ssl port (OIDsslport)
# 4. ldap use SSL flag (SSLOnly)
# @param ohm the oracle home
# Returns an array with all the property values
sub getiASProperties
{

  my $ohm = shift(@_);

  # Get the ldap connection info from ias.properties
  my $propertiesFile = $ohm . "/config/ias.properties";
  my @propNames = ( "OIDhost", "OIDport", "OIDsslport", "SSLOnly" );
  my @propValues = ( "", "", "", "" );
  my @propInfo;
  my $propertiesLine;
  my $foundAll;

  #DEBUG
  #print "DEBUG: file = \"$propertiesFile\"";

  if( -e $propertiesFile )
  {
    open( PROPERTIES_FILE_READER, $propertiesFile ) || 
          die "Cannot open ias.properties file $propertiesFile\n";
    while( $propertiesLine = <PROPERTIES_FILE_READER> )
    {
      chomp( $propertiesLine );

      #DEBUG
      #print "DEBUG: line = \"$propertiesLine\"";

      # Check for each property
      for my $i (0 .. $#propNames )
      {

        # Look for the property if we have not yet found it
        if( $propValues[$i] eq "" &&
         index( $propertiesLine, $propNames[$i] ) eq 0 )
        {

          @propInfo = split( /=/ ,$propertiesLine );
          if( $propInfo[0] eq $propNames[$i] )
          {
            $propValues[$i] = $propInfo[1];
            #print "DEBUG: $propNames[$i] = $propValues[$i]\n";
            last; # no need to look at this line again
          }
        }
      }

      # Are we done?
      $foundAll = 1;
      for my $i (0 .. $#propValues )
      {
        if( $propValues[$i] eq "" )
        {
          $foundAll = 0;
          last;
        }
      }
      if( $foundAll )
      {
        last;
      }
    }

    close PROPERTIES_FILE_READER;

    # Make sure that we were able to get all values.  Otherwise return an error
    for my $i (0 .. $#propValues )
    {
      if( $propValues[$i] eq "" )
      {
        print "em_error=Cannot get $propNames[$i]\n";
        exit 1;
      }
    }
  }
  else
  {
     print "em_error=Unable to open file $propertiesFile.\n";
     exit 1;
  }


  return( \@propValues );

}

