# $Header: emas/sysman/admin/scripts/swb_weblogic_jmx.pl /main/5 2011/11/28 10:49:30 chunkch Exp $
#
# swb_weblogic_jmx.pl
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      swb_weblogic_jmx.pl - Invokes JMX calls against the MBeans on the WebLogic server for SWB
#
#    DESCRIPTION
#      This script is a thin wrapper over Java APIs to invoke MBean calls 
#      against the WebLogic MBean server to get a list of diagnostic dumps, 
#      execute a specified dump and to manually create a problem.
#
#    NOTES
#      This script invokes the underlying Java API and returns an InputStream that 
#      the client can parse to interpret the results.
#
#    MODIFIED   (MM/DD/YY)
#    chunkch     11/09/11 - bug 13357005
#    vidykris    06/29/10 - Bug fix 9823083
#    vidykris    01/05/10 - Creation
# 

use IPC::Open2;
use ParseStdin;

require "emd_common.pl";


# Begin script
EMD_PERL_DEBUG("\nStarted SWB script - swb_weblogic_jmx.pl");

# OS-specific path/classpath separators
my $pathSep = "/";
my $cpSep = ":";
if (( $^O =~ "Windows" ) || ($^O =~ "MSWin32"))
{
  $pathSep = "\\";
  $cpSep = ";";
}

# Initialize environment
my $EMAGENT_PERL_TRACE_LEVEL_DEBUG  = 1;
my $agentInstHome;
my $emdRoot;
my $oraHome;
my $sysParam;
my $plugin_root;
my $debug = "false";

if (defined($ENV{EMDROOT}))
{
 $emdRoot=$ENV{EMDROOT};
}
if (defined($ENV{ORACLE_HOME}))
{
 $oraHome=$ENV{ORACLE_HOME};
}
if (defined($ENV{SYSTEM_PARAM}))
{
 $sysParam = $ENV{SYSTEM_PARAM};
}
if (defined($ENV{PLUGIN_ROOT}))
{
 $plugin_root = $ENV{PLUGIN_ROOT};
}
if (defined($ENV{EMSTATE}))
{
 $agentInstHome=$ENV{EMSTATE};
}
if ( defined($ENV{EMAGENT_PERL_TRACE_LEVEL}) && ($ENV{EMAGENT_PERL_TRACE_LEVEL} ne "")) 
{
  # get the current trace level
  my $trace_level = $ENV{EMAGENT_PERL_TRACE_LEVEL};

  # set debug to true if the current trace level is DEBUG
  if ( $trace_level == $EMAGENT_PERL_TRACE_LEVEL_DEBUG ) 
  {
    $debug = "true";
  }
}


# Initialize variables
my $command;
my $targetName;
my $targetType;
my $serviceUrl;
my $language;
my $country;
my $variant;
my $sslListenPortEnabled;
my $username;
my $password ;
my $commandParams ;
my $dumpName ;
my $incidentId ;
my $adrHome ;
my $fileName ;

$command = shift(@ARGV);  
$targetName = shift(@ARGV);   
$targetType = shift(@ARGV);   
$serviceUrl = shift(@ARGV);  
$language = shift(@ARGV);
$country = shift(@ARGV);
$variant = shift(@ARGV);
$sslListenPortEnabled = shift(@ARGV);
$username = shift(@ARGV); 

#Read and initialize additional parameters for specific actions
if ($command eq "EXECUTE_WLS_DUMP")
{
  # We have to execute the dumps. Initialize the params
  $dumpName = shift(@ARGV);    
  $incidentId = shift(@ARGV);
  $adrHome = shift(@ARGV); 
  $commandParams = " -dumpName $dumpName -incidentId $incidentId -adrHome $adrHome ";
  
  #Loop through the rest of the arguments and create the other parameters
  while (scalar(@ARGV) > 0)
  {
    $commandParams = $commandParams . " -userActionArg " . shift(@ARGV) . " " . shift(@ARGV); 
  }      
}
elsif($command eq "CREATE_WLS_INCIDENT")
{
  # We have to create a user reported problem. Initialize the params
  $incidentTypeId = shift(@ARGV); 
  $adrHome = shift(@ARGV); 
  $commandParams = " -incidentTypeId $incidentTypeId -adrHome $adrHome "; 
}
elsif($command eq "GET_DUMP_CONTENTS")
{
  $fileName = shift(@ARGV);
  $commandParams = " -fileName $fileName ";
}

# Read the password from STDIN
$password = <STDIN>;
chomp($password);
my ($name, $value) = split /=/,$password,2;
if($value ne "")
{
  $password = $value;  
}

#Check to see if all necessary variables have been initialized
die "Variables <emdRoot> <oraHome> <command> <targetName> <targetType> <serviceUrl> <language> <country> <variant> <sslListenPortEnabled> <username> <password> must be provided.\n" 
  if (($emdRoot eq "") || ($oraHome eq "") || ($command eq "") || ($targetName eq "") || ($targetType eq "") || ($serviceUrl eq "") || ($language eq "") || ($country eq "") || ($variant eq "") || ($sslListenPortEnabled eq "") || ($username eq "") || ($password eq ""));
    
# Initialize JAVA_HOME
$JAVA_HOME=$oraHome.$pathSep."jdk";
die "Cannot determine JAVA_HOME\n" if (($JAVA_HOME eq "") || (! -e "$JAVA_HOME".$pathSep."bin"));

# Initialize CLASSPATH
my $agentJarLoc="$emdRoot".$pathSep."jlib";
my $agentJarFiles=$agentJarLoc.$pathSep."emagentSDK.jar".$cpSep.$agentJarLoc.$pathSep."log4j-core.jar";

my $emasPluginJarsLoc="$plugin_root".$pathSep."archives".$pathSep."jlib";
my $emasPluginJarFiles=$emasPluginJarsLoc.$pathSep."emd_java.jar".$cpSep.$emasPluginJarsLoc.$pathSep."wljmxclient.jar".$cpSep.$emasPluginJarsLoc.$pathSep."wlclient.jar";

my $sysParamAll = "";
my $weblogicJars= $emasPluginJarFiles;
my $agentTrust = $agentInstHome."$pathSep"."sysman"."$pathSep"."config"."$pathSep".montrust."$pathSep"."AgentTrust.jks";

if(-r "$emasPluginJarsLoc"."$pathSep"."wlfullclient.jar")
{
   $weblogicJars= $emasPluginJarsLoc.$pathSep."wlfullclient.jar";
}

#If SSL is enabled, then set the right system parameters
if ($sslListenPortEnabled eq "true")
{
    if((-r "$emasPluginJarsLoc"."$pathSep"."wlfullclient.jar") && (-r "$emasPluginJarsLoc"."$pathSep"."wlcipher.jar"))
    {  
       $sysParamAll = $sysParam . " " . " -Dweblogic.security.TrustKeyStore=CustomTrust" . "  -Dweblogic.security.CustomTrustKeyStoreFileName=$agentTrust" ." -Dweblogic.security.SSL.enforceConstraints=off" . " -Dweblogic.security.SSL.ignoreHostnameVerification=true";
       $weblogicJars = "$emasPluginJarsLoc".$pathSep."wlfullclient.jar"."$cpSep$emasPluginJarsLoc".$pathSep."wlcipher.jar"; 
    }
    else
    {
       $sysParamAll = $sysParam . " " . " -Djavax.net.ssl.trustStore=$agentTrust". " -Dweblogic.security.SSL.enforceConstraints=off" . " -Dweblogic.security.SSL.ignoreHostnameVerification=true";       
    }
}
else
{
    $sysParamAll = $sysParam . "  -Dweblogic.security.TrustKeyStore=$fileKeyStore";       
}

#Initialize the classpath and command
my $fullCP = $agentJarFiles.$cpSep.$weblogicJars;
my $cmd = "$JAVA_HOME/bin/java $sysParamAll -cp $fullCP oracle.sysman.emas.sdk.swb.SwbWlsJmxUtil -command $command -targetName $targetName -targetType $targetType -serviceUrl $serviceUrl -language $language -country $country -variant $variant -username $username -debug $debug $commandParams";
EMD_PERL_DEBUG("\nExecuting command - $cmd");

# Write the password to STDIN so that the Java program can read it  
local(*WRITE);
my $pid = open2(SWB_JMX_CALL, *WRITE, $cmd);
print WRITE "$password\n";
close(WRITE);

# Invoke the command and return the result 
@targetLines = <SWB_JMX_CALL>;
close(SWB_JMX_CALL); 
print @targetLines;
   
# End script
EMD_PERL_DEBUG("\nExecuted SWB script - swb_weblogic_jmx.pl");
