#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/third_party_control.pl /main/25 2010/10/13 22:33:54 ppagarwa Exp $
#
# third_party_control.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      third_party_control.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ppagarwa    10/04/10 - emdRoot changed to emdRoot for xmlparserv2.jar
#    spandita    09/28/10 - XbranchMerge spandita_fix_start_stop from
#                           st_emasgc_pt-112agtst
#    spandita    06/28/10 - NG uptake
#    sasachde    12/06/09 - XbranchMerge sasachde_asgc1202 from main
#    sasachde    12/03/09 - Adding the extra jars, if available under
#                           $ORACLE_HOME/sysman/jlib/extjlib
#    spandita    11/18/09 - 9105637 - Node also needs to be considered for
#                           start/stop of WebSphere
#    spandita    10/07/09 - 8947946
#    spandita    06/26/09 - 8237617 - support was7
#    spandita    01/13/09 - 7705104
#    sasachde    07/31/08 - 
#    vdwaram     07/30/08 - 
#    sasachde    07/30/08 - 
#    spandita    07/10/08 - Backport spandita_bug-6241737 from main
#    spandita    07/09/08 - Backport spandita_bug-5346953 from main
#    spandita    06/17/08 - 7164635
#    spandita    05/15/08 - Backport spandita_bug-5162148 from main
#    spandita    06/04/07 - was 61 and wl 10 related changes
#    spandita    12/07/06 - 5702762
#    spandita    11/29/06 - 5684715
#    spandita    11/17/06 - fix 5604023 (wl9 start/stop)
#    nsarkar     10/05/06 - Access and Identity related change are incorporated
#    spandita    08/30/06 - correct the typo in containJmx (it should be containsJmx)
#    spandita    08/13/06 - wl 9 cert (jmxri.jar in classpath).
#    spandita    07/15/06 - Backport spandita_bug-5086829 from main 
#    spandita    11/24/05 - Backport spandita_bug-4636058 from main 
#    spandita    11/09/05 - XbranchMerge spandita_bug-4723688 from main 
#    spandita    03/10/06 - spandita_bug-5086829 (inclusion of ibmjsse.jar in 
#                           classpath) 
#    spandita    11/11/05 - bug-4636058 (security.jar to WAS 6 classpath). 
#    spandita    11/07/05 - bug-4723688 (use path separator based on OS). 
#    spandita    06/03/05 - use different classpath for WAS 6 
#    spandita    05/30/05 - fix for 4366930 (weblogic 7 takes -url instead of 
#                           -adminurl, -url works with weblogic 7 and 8 both). 
#    kchander    04/20/05 - fix classpath issue. 
#    spandita    03/09/05 - comment print statements. 
#    spandita    03/08/05 - fix bug 4226891 (ssl related change) 
#    spandita    01/31/05 - 
#    spandita    01/25/05 - restart for weblogic 
#    psarabha    12/31/04 - 
#    ramehta     12/22/04 - 
#    kchander    12/07/04 - kchander_start_stop_thirdparty_appserver
#    spandita    11/30/04 - Creation
# 
use File::Find;
my $oper = $ARGV[0];
my $target;
my $type;
my $hostname;
my $port;
my $username;
my $password;
my $lib;
my $keystoreFilename;
my $version;
my $nodeName;
my $plugin_root = $ENV{PLUGIN_ROOT};
$emdRoot=$ENV{EMDROOT};
my $pathSep = getClassPathSep();
my $sep = getFilePathSep();
my @alljars;
my $file_pattern = "com/ibm/jsse/IBMJSSEProvider.class";

require $emdRoot."/sysman/admin/scripts/emd_common.pl";
        
foreach $t (@ARGV)
{
    my @arg = split("=", $t);
    if ($arg[0] eq "targetName")
    {
        $target = $arg[1];
    }
    elsif ($arg[0] eq "targetType")
    {
        $type = $arg[1];
    }
    elsif ($arg[0] eq "MachineName")
    {
        $hostname = $arg[1];
    }
    elsif ($arg[0] eq "Port")
    {
        $port = $arg[1];
    }
    elsif ($arg[0] eq "UserName")
    {
        #only passed by oms 10.2.0.4 and below
        EMD_PERL_DEBUG("inside UserName argument");
        $username = $arg[1];
    }
    elsif ($arg[0] eq "password")
    {
        #only passed by oms 10.2.0.4 and below
        $password = $arg[1];
    }
    elsif ($arg[0] eq "LibraryPath")
    {
        $lib = $arg[1];
    }
    elsif($arg[0] eq "KeyStoreFile")
    {
        $keystoreFilename = $arg[1];
    }
    elsif($arg[0] eq "version")
    {
        $version = $arg[1];
    }
    elsif($arg[0] eq "Node")
    {
        $nodeName = $arg[1];
    }
}

chomp($os = $^O);
if(defined($username) and $username ne /^$/)
{
    if (($os ne "MSWin32") && ($os ne "MSWin64")) 
    {
        #replace single quote 
        $username =~ s/\'/\'\\\'\'/g;
        $password =~ s/\'/\'\\\'\'/g;

        #quote to avoid interpolation
        $username = "\'".$username."\'";
        $password = "\'".$password."\'";
    }
    else
    {
        $username =~ s/\"/\\"/g;
        $password =~ s/\"/\\"/g;        
        $username = "\"".$username."\"";
        $password = "\"".$password."\"";
    }
}
EMD_PERL_DEBUG("thirdparty control operation for $type version=$version and");
EMD_PERL_DEBUG("operation=$oper and library path=$lib");
if ($type eq "weblogic_j2eeserver")
{
    EMD_PERL_DEBUG("thirdparty control operation for weblogic version=$version");
    if(defined($version))
    {
        if($version =~ /^7/ or $version =~ /^8/)
        {
            startStopForWLbelow9();
        }
        else
        {
            startStopForWL9AndAbove();
        }
    }
    else
    {
        startStopForWLbelow9();
    }
}
elsif ($type eq "websphere_j2eeserver")
{
    EMD_PERL_DEBUG("thirdparty control operation for websphere version=$version");
    EMD_PERL_DEBUG("thirdparty control operation for websphere Node=$nodeName");
    my $emdRoot = $ENV{ORACLE_HOME};
    my $command = $emdRoot."/jdk/bin/java "; 
    EMD_PERL_DEBUG("thirdparty control operation for websphere oracle home=$emdRoot");
    if($keystoreFilename and $keystoreFilename ne /^$/)
    {
        $command = $command." -Djavax.net.ssl.trustStore=".$keystoreFilename;
    }    
    my $wasCp = getWASClasspath();
    my $xbootstrapcp = getXBootstrapClasspath($lib);
    #oms 10.2.0.4 username is passed thru command line
    if(defined($username)  and $username ne /^$/)
    {
        EMD_PERL_DEBUG("inside block when username specified");
        $command = $command." -cp ".$wasCp." -Xbootclasspath/p:".$xbootstrapcp.
                    "  oracle.sysman.emas.fetchlets.thirdparty.websphere.StartStopWebsphere ".
                    $hostname." ".$port." ".$username." ".$password." ".$target." ".$oper;
    }
    else
    {
        $command = $command." -cp ".$wasCp." -Xbootclasspath/p:".$xbootstrapcp.
                    "  oracle.sysman.emas.fetchlets.thirdparty.websphere.StartStopWebsphere ".
                    $hostname." ".$port." ".$nodeName.":".$target." ".$oper;
    }
    my $result =`$command`;
    if ( $result =~ m/<Responses>/)
    {
        my $ind = index($result, "<Responses>");
        my $result = substr($result,$ind,length($result));
    }
    EMD_PERL_DEBUG("thirdparty control result=$result");
    print "$result\n"
}
sub createResponseXML
{

    my $operation = @_[0];
    my $result = @_[1];
    my $targetName = @_[2];
    my $exitCode;
    my $respMessage;
    my $responseXML;
    my $Error = <STDERR>;

    if ( $result =~ m/was started/ or $result =~ m/was shutdown successfully/
                            or $result =~ m/was resumed successfully/)
    {
        $exitCode = "0";
        $respMessage = "SUCCESS";
    }
    elsif ($result =~ m/NoClassDefFoundError/ )
    {
        $exitCode = "1";
        $respMessage= "The operating system credentials provided may not have the required read permissions to load ".
                "WebLogic related jar files. Such permissions are required to perform start/stop/restart operations.".
                " Provide credentials which have the required read permissions.";
    }

    else
    {
        $exitCode = "1";
        $respMessage= $result;

    }

    $responseXML = "<Responses><Response><ExitCode>".$exitCode."</ExitCode><ResponseMessage>".$respMessage."</ResponseMessage><TargetName>".$targetName."</TargetName></Response></Responses>";
    return $responseXML;
}

sub getState
{
    my $state;
    my $adminUrl = @_[0];
    my $command = $emdRoot."/jdk/bin/java ";

    if($keystoreFilename and $keystoreFilename ne /^$/)
    {
        $command = $command." -Dweblogic.security.SSL.trustedCAKeyStore=".$keystoreFilename;
   }        
    $command = $command." -cp ".$emdRoot."/lib/xmlparserv2.jar".$pathSep.$lib."/weblogic.jar  -Xbootclasspath/p:".$lib."/weblogic.jar weblogic.Admin -url ".$adminUrl." -username ".$username." -password ".$password;
    
    $command = $command." GETSTATE ".$target;

    my $tempResult = `$command 2>&1`;
    if($tempResult =~ m/SHUTDOWN/)
    {
        $state = "SHUTDOWN";
    }
    elsif($tempResult =~ m/RUNNING/)
    {
        $state = "RUNNING";
    }
    elsif($tempResult =~ m/STANDBY/)
    {
        $state = "STANDBY";
    }
    else
    {
        $state = "OTHER";
    }
    return $state;
}

sub stopServer
{

 	my $command = @_[0];
	my $stopRes = `$command 2>&1`;
}

sub getWASClasspath
{
    my $wasVer;
    if(defined($version))
    {
        $wasVer = $version;
    }
    else
    {
        $wasVer = getWASVersion($lib);
    }
    EMD_PERL_DEBUG("getWASClasspath: was version=$wasVer");
    my $classpath;
    if($wasVer =~ /^5/)
    {
        EMD_PERL_DEBUG("getWASClasspath: inside block for version 5");
        find(\&getAllJars,$lib."/java");
        my $containingjar = getWantedJar();
        if($containingjar ne "NotFound")
        {
            $classpath = $containingjar.$pathSep;
        }
        
        $classpath = $classpath.$emdRoot."/lib/xmlparserv2.jar".$pathSep.
                    $plugin_root."/archives/em-as-thirdparty-fetchlet.jar".$pathSep.
                    $lib."/lib/admin.jar".$pathSep.
                    $lib."/lib/jmxc.jar".$pathSep.
                    $lib."/lib/wsexception.jar".$pathSep.
                    $lib."/lib/wasjmx.jar".$pathSep.
                    $lib."/lib/wlmclient.jar".$pathSep.
                    $lib."/lib/soap.jar".$pathSep.
                    $lib."/lib/idl.jar".$pathSep.
                    $lib."/java/jre/lib/security.jar".$pathSep.
                    $lib."/java/jre/lib/ext/ibmjsse.jar".$pathSep.
                    $lib."/java/jre/lib/ext/mail.jar".$pathSep.
                    $lib."/java/jre/lib/ext/log.jar";
    }
    elsif( $wasVer =~ /^6\.0/)
    {
        EMD_PERL_DEBUG("getWASClasspath: inside block for version 6.0.x");
        $classpath = $lib."/lib/admin.jar".$pathSep.
                     $lib."/lib/management.jar".$pathSep.
                     $lib."/lib/wsexception.jar".$pathSep.
                     $lib."/lib/wssec.jar".$pathSep.
                     $lib."/lib/utils.jar".$pathSep.
                     $lib."/lib/ras.jar".$pathSep.
                     $lib."/lib/bootstrap.jar".$pathSep.
                     $lib."/lib/emf.jar".$pathSep.
                     $lib."/lib/sas.jar".$pathSep.
                     $lib."/lib/ffdc.jar".$pathSep.
                     $lib."/lib/soap.jar".$pathSep.
                     $lib."/lib/wasjmx.jar".$pathSep.
                     $lib."/lib/j2ee.jar".$pathSep.
                     $lib."/lib/classloader.jar".$pathSep.
                     $lib."/lib/wasproduct.jar".$pathSep.
                     $lib."/lib/runtime.jar".$pathSep.
                     $lib."/lib/iwsorb.jar".$pathSep.
                     $lib."/lib/idl.jar".$pathSep.
                     $lib."/lib/security.jar".$pathSep.
                     $lib."/java/jre/lib/ibmcertpathprovider.jar".$pathSep.
                     $lib."/java/jre/lib/endorsed/ibmcertpathprovider.jar".$pathSep.
                     $lib."/java/jre/lib/ext/ibmjceprovider.jar".$pathSep.
                     $emdRoot."/lib/xmlparserv2.jar".$pathSep.
                     $plugin_root."/archives/em-as-thirdparty-fetchlet.jar";
    }
    else
    {
        EMD_PERL_DEBUG("getWASClasspath: inside block for version 6.1 & above");
        #for ws 6.1 & above
        #org.eclipse.osgi_3.2.1.R32x_v20060919.jar is required for 6.1.0.11 and 6.1.0.13
        # admin thin client jar name incase of WebSphere 7 is com.ibm.ws.admin.client_7.0.0.jar
        # also ibmjgssprovider.jar is needed when AdminSecurity on WebSphere 7 is enabled
        $classpath = $lib."/runtimes/com.ibm.ws.admin.client_6.1.0.jar".$pathSep.
                     $lib."/runtimes/com.ibm.ws.admin.client_7.0.0.jar".$pathSep.
                     $lib."/plugins/com.ibm.ws.runtime_6.1.0.jar".$pathSep.
                     $lib."/plugins/org.eclipse.osgi_3.2.1.R32x_v20060919.jar".$pathSep.                
                     $lib."/java/jre/lib/ext/ibmkeycert.jar".$pathSep.
                     $lib."/java/jre/lib/ibmjgssprovider.jar".$pathSep.
                     $emdRoot."/lib/xmlparserv2.jar".$pathSep.
                     $plugin_root."/archives/em-as-thirdparty-fetchlet.jar";

    }
 
    return $classpath;
}

sub getWASVersion
{
    my $wasHome = $lib;
    my $productFile;
    my $version;
    opendir(DIR,$wasHome."/properties/version");
    while ($file = readdir(DIR) )
    {
        if(($file =~ m/WAS.product$/) || ($file =~ m/BASE.product$/) || ($file =~ m/ND.product$/))
        {
            $productFile= $file;
            last;
        }
   }
   closedir(DIR);
   open(PF,$wasHome."/properties/version/".$productFile);
   while ( my $line = <PF> ) 
   {
       if($line =~ m/<version>/i)
       {
           my $firstInd = index($line, ">");
           my $secondInd = index($line, "<",$firstInd);
           $version = substr($line,$firstInd+1,$secondInd-($firstInd+1));
           last;
        }
    }
    close(PF);
    return $version;
}

sub getClassPathSep()
{
	my $sep;
	chomp($os = $^O);
    if (($os ne "MSWin32") && ($os ne "MSWin64")) 
    {
        $sep = ":";
    }
	else
    {
        $sep = ";";
    }
	return $sep;
	
}

sub getFilePathSep()
{
    my $sep = "";
    chomp($os = $^O);
        if (($os ne "MSWin32") && ($os ne "MSWin64"))
        {
            $sep = "/";
        }
        else 
        {
            $sep = "\\";
        }
}

sub startStopForWLbelow9
{
    EMD_PERL_DEBUG("thirdparty control operation for weblogic version below 9");        
    my $protocol = "t3";
    if($keystoreFilename and $keystoreFilename ne /^$/)
    {
        $protocol = "t3s";
    }    
    my $adminUrl = $protocol."://".$hostname.":".$port;
    my $command = $emdRoot."/jdk/bin/java ";
    if($keystoreFilename and $keystoreFilename ne /^$/)
    {
        $command = $command." -Dweblogic.security.SSL.trustedCAKeyStore=".$keystoreFilename;
    }       
    if(defined($username) and $username ne /^$/)
    {
        $command = $command." -cp ".$emdRoot."/sysman/jlib/emagentSDK.jar".$pathSep.
        $emdRoot."/lib/xmlparserv2.jar oracle.sysman.util.discover.WLWrapper ".
        $adminUrl." ".$username." ".$password." ".$oper." ".$target." ".$lib." ".$emdRoot;
    }
    else
    {
        $command = $command." -cp ".$emdRoot."/sysman/jlib/emagentSDK.jar".$pathSep.
        $emdRoot."/lib/xmlparserv2.jar oracle.sysman.util.discover.WLWrapper ".
        $adminUrl." ".$oper." ".$target." ".$lib." ".$emdRoot;
    }
    my $result =`$command 2>&1`;
    EMD_PERL_DEBUG("thirdparty control result=$result");
    if ( $result =~ m/<Responses>/)
    {
        my $ind = index($result, "<Responses>");
        $result = substr($result,$ind,length($result));
        if ($result =~ m/NoClassDefFoundError/ )
        {
            EMD_PERL_DEBUG("thirdparty control .. could not load required classes");
            $result = createResponseXML($oper,$result,$target);
        }

    }
    print "$result\n";
}

sub startStopForWL9AndAbove
{
    EMD_PERL_DEBUG("thirdparty control operation for weblogic version 9 or above");
    my $protocol = "t3";
    my $command = $emdRoot."/jdk/bin/java -Dsun.lang.ClassLoader.allowArraySyntax=true";
    if($keystoreFilename and $keystoreFilename ne /^$/)
    {
        $command = $command." -Dweblogic.security.SSL.trustedCAKeyStore=".$keystoreFilename;
        $protocol = "t3s";
    }
    my $extraWLJas = getExtraWLJars();
    EMD_PERL_DEBUG("extra jars added to the classpath are $extraWLJas");
    my $classpath = $emdRoot."/lib/xmlparserv2.jar".
                    $pathSep.$emdRoot."/sysman/jlib/emagentSDK.jar";
    if(-e $lib."/wlfullclient.jar")
    {
    	$classpath = $classpath.
                     $pathSep.$lib."/wlfullclient.jar".
                     $pathSep.$lib."/webserviceclient+ssl.jar";
    }
    elsif(-e $lib."/weblogic.jar")
    {
    	$classpath = $classpath.
                     $pathSep.$lib."/weblogic.jar";
    }
    else
    {
    	$classpath = $classpath.
                     $pathSep.$lib."/wljmxclient.jar".
                     $pathSep.$lib."/wlclient.jar";
    }
    if(defined($extraWLJas) and $extraWLJas ne "")
    {
        $classpath = $extraWLJas.$pathSep.$classpath;
    }
    if(defined($username) and $username ne /^$/)
    {
        EMD_PERL_DEBUG("inside block username specified");
        $command = $command." -cp ".$classpath.
        " oracle.sysman.util.discover.StartStopWL ".
        $hostname." ".$port." ".$username." ".$password." ".$target." ".$oper." ".$protocol;
    }
    else
    {
        $command = $command." -cp ".$classpath.
        " oracle.sysman.util.discover.StartStopWL ".
        $hostname." ".$port." ".$target." ".$oper." ".$protocol;
    }

    my $result =`$command`;
    EMD_PERL_DEBUG("thirdparty control result=$result");        
    if ( $result =~ m/<Responses>/)
    {
        my $ind = index($result, "<Responses>");
        $result = substr($result,$ind,length($result));
        if ($result =~ m/NoClassDefFoundError/ )
        {
            EMD_PERL_DEBUG("thirdparty control operation for weblogic version 9 or above .. could not load required classes");
            $result = createResponseXML($oper,$result,$target);
        }

    }
    print "$result\n";
}

sub getAllJars
{
    my $file = $File::Find::name;
    return unless -f $file;
    return  unless $file =~ m/.jar/;
    push(@alljars,$file);
}

sub getExtraWLJars
{
    my $extraJar = "";
    my $libRoot="$emdRoot".$sep."sysman".$sep."jlib";
    my $dir_to_read = $libRoot.$sep."extjlib";
    if(-d $dir_to_read && -r $dir_to_read)
    {
	$extraJar = $dir_to_read.$sep;
	opendir(FILES_TO_READ, $dir_to_read);
	my @the_files =  readdir (FILES_TO_READ);
	foreach $f (@the_files)
	{
	    EMD_PERL_DEBUG("\nThe file=$f");
	    my(undef, undef, $ftype) = fileparse($f,qr"\.[^.]*");
	    EMD_PERL_DEBUG("\nExt=$ftype");
	    if($ftype eq ".jar")
	    {
		EMD_PERL_DEBUG("\nAdding Jar file to cp =$f");
		$extraJar = $extraJar.$pathSep.$dir_to_read.$sep.$f;
	    }
	}#ForEach
	closedir(FILES_TO_READ);
    }
    return $extraJar;    
}

sub getWantedJar
{
    my $wantedjar;
    foreach my $jarfile (@alljars)
    {
        my $found = "false";
        open(FILEHANDLE, $emdRoot."/jdk/bin/jar -tvf ".$jarfile." |");
        while (my $line = <FILEHANDLE>) 
        {
            if ($line =~ m/$file_pattern/) 
            {
                $found = "true";
                $wantedjar = $jarfile;
                last;
            }
        }
        close FILEHANDLE;
        if($found eq "true")
        {
            last;
        }
    }
    if($wantedjar and $wantedjar ne /^$/)
    {
        return $wantedjar;
    }
    else
    {
        return "NotFound";
    }

}

sub getXBootstrapClasspath
{
    my $xbootstrapcp = "";
    my $lib = @_[0];
    my $pathSep;
    chomp($os = $^O);
    if (($os ne "MSWin32") && ($os ne "MSWin64"))
    {
        $pathSep=":";
    }
    else
    {
        $pathSep=";";
    }

    $xbootstrapcp = $lib."/lib/jmxc.jar".$pathSep.
    $lib."/lib/jmxx.jar".$pathSep.
    $lib."/lib/jmxext.jar".$pathSep.
    $lib."/lib/jflt.jar".$pathSep.
    $lib."/java/jre/lib/ext/log.jar"; 
    return $xbootstrapcp;
}
