#!/usr/local/bin/perl
# 
# $Header: webcacheIsStandalone.pl 16-sep-2003.12:44:17 ccleavel Exp $
#
# webcacheIsStandalone.pl
# 
# Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      webcacheIsStandalone.pl - determines whether a Web Cache target is standalone (not in an ias)
#
#    DESCRIPTION
#      webcacheIsStandalone.pl <oracle_home> <targetName>
#
#      where
#         <oracle_home> is the oracle home in which Web Cache is running
#         <targetName> is the target name for the Web Cache
#
#    returns: 
#      em_result=<isStandalone>
#
#      where:
#         <isStandalone> is 1 if the Web Cache is standalone, 0 if not
#
#      
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ccleavel    09/16/03 - ccleavel_standalone_main 
#    ccleavel    09/12/03 - 
#    ccleavel    09/09/03 - Creation
# 
use strict;

#require "emd_common.pl";
#EMD_PERL_DEBUG("TMC  $ARGV[0] $ARGV[1]");
#   print "DEBUG ARG[1] is $ARGV[1]\n";

# Open targets.xml
my $targetsFileName = $ARGV[0]."/sysman/emd/targets.xml";
if (!open (TARGETFILE,$targetsFileName))
{ 
    print "em_result=\n";
    # EMD_PERL_DEBUG("premature exit");
    exit 0;
}

# Initialize the result.
my $isStandalone = "0";

# First, find ARG[1], the target name.
# We're assuming this is the line that looks like
#     <Target TYPE="oracle_webcache" NAME="ARG[1]"
# We know the target is in this targets.xml because ... TBD
while(<TARGETFILE>)
{
    if (/$ARGV[1]/) {
        # print "DEBUG target line is $_\n";
        last;
    }
}

# Now look for which comes first:
#   <MemberOf> TYPE="oracle_ias", which implies the cache is in an ias, not standalone.
# or
#   /Target, which implies this is a standalone cache, because of the absence of <CompositeMembership>

# TBD Should we check for text in all caps too?
while(<TARGETFILE>)
{
    if (/MemberOf.*TYPE=\"oracle_ias\"/) {
        $isStandalone="0";
        last;
    }

    if (/\/Target/) {
	$isStandalone="1";
        last;
    }
}

close(TARGETFILE);

print "em_result=$isStandalone\n";
#EMD_PERL_DEBUG("TMC result is $isStandalone");







