#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/weblogic/WL_listConfigFiles.pl /st_emasgc_11.1/1 2010/01/28 23:23:29 slahane Exp $
#
# WL_listConfigFiles.pl
# 
# Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      WL_listConfigFiles.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    slahane     01/25/10 - added if to filter out arisidprovider,carml,mbeans,server-config-template folders and the xml files starting with backup_config
#    sasachde    03/30/09 - Filter ear, war, rar config files
#    sasachde    07/31/08 - 
#    vdwaram     07/30/08 - 
#    sasachde    07/14/08 - Creation
#

use strict;
use ias::asecm;
use File::Find;
use File::stat;
use Sys::Hostname;

my $wlDomain = $ARGV[0];
ias::asecm::setWeblogicDomain($wlDomain);
my $forUploadStr = $ARGV[1];
my $forUpload = $forUploadStr eq 'true';
my $targetName = $ARGV[2];
my $instanceName = $ARGV[3];
my $version = $ARGV[4];
my $isAdmin = $ARGV[5];
my $adminServerHostName = $ARGV[6];

if($adminServerHostName =~ /\./)
{
        my $length = index($adminServerHostName, '.');
        $adminServerHostName = substr $adminServerHostName, 0, $length;
}
my $hostName = hostname();
if($hostName =~ /\./)
{
        my $length = index($hostName, '.');
        $hostName = substr $hostName, 0, $length;
}

if($adminServerHostName eq $hostName)
{
	if($isAdmin eq 'YES')
	{           
            my @subDirs = ( 'config' );
            my @extensions = ( 'xml', 'properties');
    
            if(($version =~ /^8/) || ($version =~ /^7/) )
            {
                find({
                    wanted => sub
                    {
                            if ($_ eq 'config.xml')
                            {
                                ias::asecm::statWLFile($File::Find::name, $forUpload, $targetName, $instanceName);
                            }
                    },
                    follow => (ias::asecm::getPlatform() eq 'unix'), # follow links
                    follow_skip => 2 # if the same file is visited twice, skip it the second time
                },
                "$wlDomain");
            }
            else
            {
                    
                for my $subDir (@subDirs)
                {
                    find({
                    wanted => sub
                    {                    
                        my $dir = $File::Find::dir;                            
                        if( 
                        ($dir !~ m/arisidprovider/) && ($dir !~ m/carml/) &&
                        ($dir !~ m/mbeans/) && ($dir !~ m/adml/) && ($dir !~ /server-config-template/)
                        )
                        {
                            for my $ext (@extensions)
                            {			
                                if (($_ =~ /\.$ext$/) && ($_ ne 'nm_password.properties') && (($_ !~ m/^backup_config/)))
                                {
                                    ias::asecm::statWLFile($File::Find::name, $forUpload, $targetName, $instanceName);
                                }
                            }
                        }			
                    },
                    follow => (ias::asecm::getPlatform() eq 'unix'), # follow links
                    follow_skip => 2 # if the same file is visited twice, skip it the second time
                    },
                    "$wlDomain/$subDir");
                } 
            }
	}
}



