#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/weblogic/weblogicAppsControl.pl /st_emasgc_11.1/2 2009/12/15 23:05:02 vdwaram Exp $
#
# weblogicAppsControl.pl
# 
# Copyright (c) 2008, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      weblogicAppsControl.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vdwaram     12/14/09 - Bug# 8786945
#    sasachde    12/06/09 - XbranchMerge sasachde_asgc1202 from main
#    sasachde    12/03/09 - Adding the extra jars, if available under
#                           $ORACLE_HOME/sysman/jlib/extjlib
#    slahane     10/14/09 - fix for app stop,start for ssl enabled wlserver.
#    sulagana    09/16/08 - Fix the status
#    sulagana    08/24/08 - 
#    rkaplish    08/22/08 - 
#    skpanigr    08/17/08 - Creation
# 

use IPC::Open2;
require "emd_common.pl";
use ParseStdin;

my $appName;
my $hostname;
my $port;
my $servername;
my $username;
my $password;
my $lib;
my $keystoreFilename;
my $version;
my $oraHome = $ENV{ORACLE_HOME};

#--------------------------------------------------------------------------------------------------
EMD_PERL_DEBUG("\nweblogicAppsControl.pl!!! Step#1 - Collecting INPUT parameters....");
#--------------------------------------------------------------------------------------------------

ParseStdin::initStdin();
my $password = ParseStdin::getParameter("Password");
my $splitChar = ";";
my $index = rindex($ARGV[0], $splitChar);
if ($index eq "-1") {
    $splitChar = " ";
}

foreach $t (split($splitChar,$ARGV[0]))
{
    my @arg = split("=", $t);
    if ($arg[0] eq "Operation")
    {
        $oper = $arg[1];
    }
    elsif ($arg[0] eq "UserName")
    {
        $username = $arg[1];
    }
    elsif ($arg[0] eq "AppName")
    {
        $appName = $arg[1];
    }
    elsif ($arg[0] eq "HostName")
    {
        $hostname = $arg[1];
    }
    elsif ($arg[0] eq "Port")
    {
        $port = $arg[1];
    }
    elsif ($arg[0] eq "ServerName")
    {
        $servername = $arg[1];
    }
    elsif ($arg[0] eq "LibraryPath")
    {
        $lib = $arg[1];
    }
    elsif($arg[0] eq "KeyStoreFile")
    {
        $keystoreFilename = $arg[1];
    }
    elsif($arg[0] eq "Version")
    {
        $version = $arg[1];
    }
}

EMD_PERL_DEBUG("\nweblogicAppsControl.pl!!! INPUT => Operation = $oper");

#Operation must not be anything other than START and STOP ... EMGC Security Guideline
if($oper eq "stop") {
	if($version =~ /^7/ or $version =~ /^8/)
	{
		$oper = $oper;
		EMD_PERL_DEBUG("\nweblogicAppsControl.pl!!! Setting cmd for Weblogic 8 $oper");
	}
	else{	
		$oper = $oper." -graceful";
	}
} elsif($oper ne "start") {
	printMessage("FAILED", "Allowed Operations are START and STOP", "");
	exit(0);
}

EMD_PERL_DEBUG("\nweblogicAppsControl.pl!!! INPUT => Oracle Home = $oraHome");
EMD_PERL_DEBUG("\nweblogicAppsControl.pl!!! INPUT => HostName = $hostname");
EMD_PERL_DEBUG("\nweblogicAppsControl.pl!!! INPUT => Port = $port");
EMD_PERL_DEBUG("\nweblogicAppsControl.pl!!! INPUT => UserName = $username");
EMD_PERL_DEBUG("\nweblogicAppsControl.pl!!! INPUT => Library Path = $lib");
EMD_PERL_DEBUG("\nweblogicAppsControl.pl!!! INPUT => Application Name = $appName");
EMD_PERL_DEBUG("\nweblogicAppsControl.pl!!! INPUT => Keystore File name = $keystoreFilename");
EMD_PERL_DEBUG("\nweblogicAppsControl.pl!!! INPUT => Version = $version");

chomp($os = $^O);
my $sep = "";
my $pathSep = "";
if (($os ne "MSWin32") && ($os ne "MSWin64"))
{
    $pathSep=":";
    $sep = "/";
}
else
{
    $pathSep=";";
    $sep = "\\";
}

#--------------------------------------------------------------------------------------------------------
EMD_PERL_DEBUG("\nweblogicAppsControl.pl!!! Step#2 - Setting Execution Environment Variables...");
#--------------------------------------------------------------------------------------------------------

my $oraHome = $ENV{ORACLE_HOME};
my $command = $oraHome."/jdk/bin/java ";
my $protocol = "t3";

if($keystoreFilename and $keystoreFilename ne /^$/)
{
	$command = $command."-Dweblogic.security.SSL.ignoreHostnameVerification=true -Dweblogic.security.SSL.trustedCAKeyStore=".$keystoreFilename; 
	$protocol = "t3s";
}    

my $adminurl = $protocol."://".$hostname.":".$port;

my $classPath = $lib."/weblogic.jar";

if($version =~ /^7/ or $version =~ /^8/)
{
	$command = $command." -Djmx.serial.form=1.0";
	$command = $command." -cp ".$oraHome."/sysman/jlib/emagentSDK.jar".$pathSep.
		" oracle.sysman.util.discover.AppStartStopWrapper".
		" -adminurl ".$adminurl." -username ".$username.
		" -".$oper." -name \"".$appName."\" -targets ".$servername." ".$lib." ".$oraHome." 2>&1";
}
else
{
	my $extraWLJars = getExtraWLJars();
	EMD_PERL_DEBUG("extra jars added to the classpath are $extraWLJars");
	if($extraWLJars ne "")
	{
	    $classPath = $extraWLJars.$pathSep.$classPath;
	}
	$command = $command." -cp ".$classPath." -Dsun.lang.ClassLoader.allowArraySyntax=true weblogic.Deployer".
		" -adminurl ".$adminurl." -username ".$username.
		" -".$oper." -name \"".$appName."\" -targets ".$servername." 2>&1";
}

#-------------------------------------------------------------------------------------------------------------
EMD_PERL_DEBUG("\nweblogicAppsControl.pl!!! Step#3 - Executing the following Command... \n$command\n");
#-------------------------------------------------------------------------------------------------------------

local(*READ, *WRITE);
my $pid = open2(\*READ, \*WRITE, $command);
print WRITE "$password\n";
close(WRITE);

my @cmdOutput;

while(<READ>) {
	push(@cmdOutput, $_);
}
close(READ);
waitpid($pid, 0);


#-------------------------------------------------------------------------------------------------------------
EMD_PERL_DEBUG("\nweblogicAppsControl.pl!!! Step#4 - Execution Complete. Composing result.\n");
#-------------------------------------------------------------------------------------------------------------
#Variable to store any other unknown error messages
my $errorLine; 

foreach  my $line (@cmdOutput) {
	EMD_PERL_ERROR("weblogicAppsControl.pl!!! .. ONE_LINE: ".$line);
	if ($line =~ m/NoClassDefFoundError/ )	{
		EMD_PERL_ERROR("weblogicAppsControl.pl!!! .. could not load required classes: ".$line);
		printMessage("CLASS_NOT_FOUND", $line, @cmdOutput);
		exit(0);
	}elsif ($line =~ m/AuthenticationException/ ) {
		EMD_PERL_ERROR("weblogicAppsControl.pl!!! .. AuthenticationException Occured: ".$line);
		printMessage("AUTHENTICATION_FAILED", $line, @cmdOutput);
		exit(0);
	}elsif ($line =~ m/CommunicationException/ ) {
		EMD_PERL_ERROR("weblogicAppsControl.pl!!! .. CommunicationException Occured: ".$line);
		printMessage("COMMUNICATION_FAILED", $line, @cmdOutput);
		exit(0);
	}elsif ($line =~ m/Exception/ ) {
		$errorLine = $line;
	}
	if ($line =~ m/completed/ ) {
		EMD_PERL_DEBUG("weblogicAppsControl.pl!!! .. Operation Successful.");
		printMessage("SUCCESS", $line, @cmdOutput);
		exit(0);
	}
}

printMessage("FAILED", $errorLine, @cmdOutput);

sub printMessage()
{
	(my $ExitStatus, my $StatusMessage, my @OutputTrace) = @_;
	EMD_PERL_ERROR("weblogicAppsControl.pl!!! .. Message: ".$line);
	print "ExitStatus==$ExitStatus||StatusMessage==$StatusMessage.||OutputTrace==@OutputTrace";
}

sub getExtraWLJars
{
    my $extraJar = "";
    my $libRoot="$oraHome".$sep."sysman".$sep."jlib";
    my $dir_to_read = $libRoot.$sep."extjlib";
    if(-d $dir_to_read && -r $dir_to_read)
    {
	$extraJar = $dir_to_read.$sep;
        opendir(FILES_TO_READ, $dir_to_read);
        my @the_files =  readdir (FILES_TO_READ);
        foreach $f (@the_files)
        {
            EMD_PERL_DEBUG("\nThe file=$f");
            my(undef, undef, $ftype) = fileparse($f,qr"\.[^.]*");
            EMD_PERL_DEBUG("\nExt=$ftype");
            if($ftype eq ".jar")
            {
                EMD_PERL_DEBUG("\nAdding Jar file to cp =$f");
                $extraJar = $extraJar.$pathSep.$dir_to_read.$sep.$f;
            }
        }#ForEach
        closedir(FILES_TO_READ);
    }
    return $extraJar;
}

