discover(@ARGV);
use File::Find;
my $version;
my $hostArg;
my $wlInstallDir;
my $inputLength;
my $discovery_root;
sub discover
{
    my $emdRoot = $ENV{EMDROOT};
    print ("EMD Root is $emdRoot\n");
    

    my $plugin_root = $ENV{PLUGIN_ROOT};
    #work around copied the plugin jar to plugin_root as disc_root is not available
    $discovery_root = $plugin_root;
     
    my $wlclsname = " oracle.sysman.util.discover.WeblogicDiscovery ";
    require $emdRoot."/sysman/admin/scripts/emd_common.pl";    
    my $length = @_; 
    EMD_PERL_DEBUG("Number of arguments = $length");
    print("Discovery Root is = $discovery_root");
    if($length == 3)
    {
        $version = @_[1];
        $hostArg = @_[2];
        EMD_PERL_DEBUG("discovering, the version $version");            
        EMD_PERL_DEBUG("discovering, host argument $hostArg"); 
    }
    $inputLength = (@_[0]  =~ tr/\|//);
    if($inputLength >= 6)
    {
        ($weblogicusername, $weblogicpassword, $servertype,$port, 
            $lib, $host,$keyStoreFile) = split(/\|/,@_[0]);
    }
    else
    {
        ($servertype,$port, 
            $lib, $host,$keyStoreFile) = split(/\|/,@_[0]);        
    }

    chomp($os = $^O);
    if($inputLength >= 6)
    {
        if (($os ne "MSWin32") && ($os ne "MSWin64")) 
        {
            #replace single quote first
            $weblogicusername =~ s/\'/\'\\\'\'/g;
            $weblogicpassword =~ s/\'/\'\\\'\'/g;

            $weblogicusername = "\'".$weblogicusername."\'";
            $weblogicpassword = "\'".$weblogicpassword."\'";
        }
        else
        {
            $weblogicusername =~ s/\"/\\"/g;
            $weblogicpassword =~ s/\"/\\"/g;        
            $weblogicusername = "\"".$weblogicusername."\"";
            $weblogicpassword = "\"".$weblogicpassword."\"";
        }
    }
    $servertype = trim($servertype);
    $port = trim($port);
    $lib = trim($lib);
    $host = trim($host);

    my $emdRoot = $ENV{EMDROOT};
    my $home = $ENV{HOME};
    my $homedrive;
    my $wlJarLocation;
    #my $beaHome;
    #my $wsHome;
    my $thirdPartyHome;
    my $classpath;
    my @alljars;
    my $file_pattern = "com/ibm/jsse/IBMJSSEProvider.class";
    chomp($os = $^O);

    EMD_PERL_DEBUG("Starting discovery of $servertype with following arguments");
    EMD_PERL_DEBUG("Port=$port,Host=$host,Lib Path=$lib");
    if ($host and $host ne /^$/)
    {
        if ($servertype and $servertype ne "weblogic")
        {
            my $reqjarsexist = "false";
            if(defined($version))
            {
                if($version =~ /^5/ or $version =~ /^6\.0/)
                {
                    if(-e $lib."/lib/admin.jar")
                    {
                        $reqjarsexist = "true";
                    }
                }
                else
                {
                    # for 6.1 and above
                    # admin thin client jar name incase of WebSphere 7 is com.ibm.ws.admin.client_7.0.0.jar
                    if(((-e $lib."/runtimes/com.ibm.ws.admin.client_6.1.0.jar" )
                            and (-e $lib."/plugins/com.ibm.ws.runtime_6.1.0.jar")) 
                        or (-e $lib."/runtimes/com.ibm.ws.admin.client_7.0.0.jar"))
                    {
                        $reqjarsexist = "true";
                    }

                }
            }
            else
            {
                if(-e $lib."/lib/admin.jar")
                {
                    $reqjarsexist = "true";
                }
            }

            if($reqjarsexist eq "true")
            {
                $classpath = getClasspath($servertype, $lib);
                my $xbootstrapcp = getXBootstrapClasspath($lib);
                $command = "\"".$emdRoot."/jdk/bin/java\" \"-Doracle.home=".$emdRoot."\"";
                if($keyStoreFile and $keyStoreFile ne /^$/)
                {
                    $command = $command." \"-Djavax.net.ssl.trustStore=".$keyStoreFile."\"";
                }
                if($inputLength >= 6)
                {
                    $command = $command." -cp \"".$classpath."\" \"-Xbootclasspath/p:".$xbootstrapcp."\" oracle.sysman.emas.thirdparty.discovery.websphere.WebsphereDiscovery  ".$port." ".$weblogicusername." ".$weblogicpassword." \"".$lib."\" ".$host." ".$servertype;
                }
                else
                {
                    $command = $command." -cp \"".$classpath."\" \"-Xbootclasspath/p:".$xbootstrapcp."\" oracle.sysman.emas.thirdparty.discovery.websphere.WebsphereDiscovery  ".$port." \"".$lib."\" ".$host." ".$servertype;
                }
            }
            else 
            {
                EMD_PERL_DEBUG("Could not find jars in $lib required for discovery of WebSphere");
                print "13";
                exit(0);
            }
        }
        else
        {
            # for Weblogic
            my $jarsExist = "false";
            my $containsJmx = "false";    
	    EMD_PERL_DEBUG("version : $version"); 
            if(defined($version))
            {
                if($version =~ /^7/ or $version =~ /^8/)
                {
                    if( -e $lib."/weblogic.jar")
                    {
                        $jarsExist = "true";
                        $wlclsname = " oracle.sysman.util.discover.WLDiscoveryWrapper ";
                        $containsJmx = "true";
                    }
                }
                else
                {		    
                    if((-e $lib."/wljmxclient.jar") and (-e $lib."/wlclient.jar"))
                    {
                        $jarsExist = "true";
                    }
                }
            }
            else
            {		
                if(( -e $lib."/weblogic.jar") or ( -e $lib."/wljmxclient.jar"))
                {
                    $jarsExist = "true";
                    if(!(-e $lib."/wljmxclient.jar"))
                    {
                        $containsJmx = "true";
                    }
                }
            }     
            if($jarsExist eq "true")
            {
                $classpath = getClasspath($servertype, $lib);
		$command = "\"".$emdRoot."/jdk/bin/java\" \"-Doracle.home=".$emdRoot."\"";
                if($keyStoreFile and $keyStoreFile ne /^$/)
                {
                    $command = $command." \"-Dweblogic.security.SSL.trustedCAKeyStore=".$keyStoreFile."\"";
                }
                if(defined($hostArg))
                {
                    $host = $hostArg;
                }
                if($containsJmx eq "true")
                {
                    if($inputLength >=6)
                    {
                        $command = $command." -Dsun.lang.ClassLoader.allowArraySyntax=true -cp \"".$classpath."\"".$wlclsname.
                        $port." ".$weblogicusername." ".$weblogicpassword." \"".$lib."\" ".$host;			
                    }
                    else
                    {                        
                        $command = $command." -Dsun.lang.ClassLoader.allowArraySyntax=true -cp \"".$classpath."\"".$wlclsname.
                        $port." \"".$lib."\" ".$host;	
                    }
                }
                else
                {
                    if($inputLength >=6)
                    {
                        $command = $command." -Dsun.lang.ClassLoader.allowArraySyntax=true -cp \"".$classpath."\"".$wlclsname.
                        $port." ".$weblogicusername." ".$weblogicpassword." \"".$lib."\" ".$host;			
                    }
                    else
                    {
                        $command = $command." -Dsun.lang.ClassLoader.allowArraySyntax=true -cp \"".$classpath."\"".$wlclsname.
                        $port." \"".$lib."\" ".$host;			
                    }
                }	
		
            }
            else
            {
                EMD_PERL_DEBUG("Could not find jars in $lib required for discovery of WebLogic");
                print "12";
                exit(0);
            }

        } # end of if for weblogic
    }
    else
    { #when agent host is not specified

        if ($lib and $lib ne /^$/)
        {
            if($servertype eq "weblogic")
            {
                my $jarsExist = "false";
                if(defined($version))
                {
                    if($version =~ /^7/ or $version =~ /^8/)
                    {
                        if( -e $lib."/weblogic.jar")
                        {
                            $jarsExist = "true";
                            $clsname = " oracle.sysman.util.discover.WLDiscoveryWrapper ";
                        }
                    }
                    else
                    {
                        if((-e $lib."/wljmxclient.jar") and (-e $lib."/wlclient.jar"))
                        {
                            $jarsExist = "true";
                        }
                    }
                }
                else
                {
                    if((-e $lib."/weblogic.jar") or (-e $lib."/wljmxclient.jar"))
                    {
                        $jarsExist = "true";
                    }
                }                
                if($jarsExist eq "true")
                {
                    $thirdPartyHome = $lib; 
                }
                else
                {
                    print "12";
                    exit(0);
                }
            }
            else
            {
                if(defined($version))
                {
                    if($version =~ /^5/ or $version =~ /^6\.0/)
                    {
                        if(-e $lib."/lib/admin.jar")
                        {
                            $thirdPartyHome = $lib;
                        }
                        else
                        {
                             print "13";
                             exit(0);
                        }
                    }
                    else
                    {
                        # for 6.1 and above
                        # admin thin client jar name incase of WebSphere 7 is com.ibm.ws.admin.client_7.0.0.jar
                        if( ((-e $lib."/runtimes/com.ibm.ws.admin.client_6.1.0.jar" ) 
                                and (-e $lib."/plugins/com.ibm.ws.runtime_6.1.0.jar"))
                            or (-e $lib."/runtimes/com.ibm.ws.admin.client_7.0.0.jar") )
                        {
                            $thirdPartyHome = $lib; 
                        }
                        else
                        {
                            print "13";
                            exit(0);
                        }
                    }
                }
                else
                {
                    #for oms which is not passing version
                    if( -e $lib."/lib/admin.jar")
                    {
                        $thirdPartyHome = $lib; 
                    }
                    else
                    {
                        print "13";
                        exit(0);
                    }
                }
            }

        }
        else
        {
            #when lib param not specified

            if($servertype eq "weblogic")
            {
                $thirdPartyHome = getBEAHome();
            }
            else
            {
                $thirdPartyHome = getWSHome();
                EMD_PERL_DEBUG("ThirdPartyHome: $thirdPartyHome");
            }
        }

        EMD_PERL_DEBUG("$serverType library path is $thirdPartyHome");
        if ($thirdPartyHome eq "")
        {
            #the ThirdPartyConstants.NO_LIBRARY_FOUND                
            EMD_PERL_DEBUG("Could not find Library path");
            print "11";
            exit(0);
        }            

        my $ports;
        if ($port and $port ne /^$/)
        {
            $ports = $port;
        }
        else
        {
            EMD_PERL_DEBUG("Port is not specified");
            my %openPorts = getOpenPorts();
            #system("perl $emdRoot/emdw/sysman/admin/scripts/openports.pl > t");

            foreach $p (%openports)
            {
                chomp($p);
                if ($p > 1023)
                {
                    $ports = $p.":".$ports;
                }
            }
        }

        EMD_PERL_DEBUG("List of ports = $ports");
        if ($servertype and $servertype ne "weblogic")
        {
            $classpath = getClasspath($servertype, $thirdPartyHome);
            my $xbootstrapcp = getXBootstrapClasspath($thirdPartyHome);
            $command = "\"".$emdRoot."/jdk/bin/java\" \"-Doracle.home=".$emdRoot."\"";
            if($port and $port ne /^$/)
            {
                $command = $command." -DportSpecified=".$port;
            }            
            if($keyStoreFile and $keyStoreFile ne /^$/)
            {
                $command = $command." \"-Djavax.net.ssl.trustStore=".$keyStoreFile."\"";
            }            
            if($inputLength >= 6)
            {
                $command = $command." -cp \"".$classpath."\" \"-Xbootclasspath/p:".$xbootstrapcp."\" oracle.sysman.emas.thirdparty.discovery.websphere.WebsphereDiscovery  ".$ports." ".$weblogicusername." ".$weblogicpassword." \"".$thirdPartyHome."\" ".$servertype;                
            }
            else
            {
                $command = $command." -cp \"".$classpath."\" \"-Xbootclasspath/p:".$xbootstrapcp."\" oracle.sysman.emas.thirdparty.discovery.websphere.WebsphereDiscovery  ".$ports."  \"".$thirdPartyHome."\" ".$servertype;
            }
        }
        else
        {

            my $wlLibPath;
            my $containsJmx = "false";            
            
            if ($lib and $lib ne /^$/)
            {
                $wlLibPath = $thirdPartyHome;
            }
            else
            {
                my $installDir = getWLInstallDir($thirdPartyHome);
                if($installDir eq "")
                {
                    print 11;
                    exit(0);
                }
                $wlLibPath = $installDir."/server/lib";
            }

            $classpath = getClasspath($servertype, $wlLibPath);
            $command = "\"".$emdRoot."/jdk/bin/java\" \"-Doracle.home=".$emdRoot."\"";
            if($port and $port ne /^$/)
            {
                $command = $command." -DportSpecified=".$port;
            }
            if($keyStoreFile and $keyStoreFile ne /^$/)
            {
                $command = $command." \"-Dweblogic.security.SSL.trustedCAKeyStore=".$keyStoreFile."\"";
            }	    
            if(defined($version))
            {
                if($version =~ /^7/ or $version =~ /^8/)
                {
                    if(!(-e $wlLibPath."/wljmxclient.jar"))
                    {
                        $containsJmx = "true";
                    }
                    $wlclsname = " oracle.sysman.util.discover.WLDiscoveryWrapper ";
                }
            }
            else
            {   
		if(!(-e $wlLibPath."/wljmxclient.jar"))
                {
                    $wlclsname = " oracle.sysman.util.discover.WLDiscoveryWrapper ";
                    $containsJmx = "true";
                }
            }

            if($containsJmx eq "true")
            {
                $command = $command." -cp \"".$classpath."\"".$wlclsname.
                $ports." \"".$wlLibPath."\" ".$hostArg;
            }
            else
            {
                $command = $command." -Dsun.lang.ClassLoader.allowArraySyntax=true -cp \"".$classpath."\"".$wlclsname.
                $ports." \"".$wlLibPath."\" ".$hostArg;
            }

        }
    }

    my $libraryPath;
    if ($lib and $lib ne /^$/)
    {
        $libraryPath = "<LibraryPath path=\"".$lib."\"/>";
    }
    else
    {
        if ($servertype eq "weblogic")
        {
            $jarLoc = getWLInstallDir($thirdPartyHome);            
            $libraryPath = 
            "<LibraryPath path=\"".$jarLoc."/server/lib\"/>";
        }
        else
        {
            $libraryPath = "<LibraryPath path=\"".$thirdPartyHome."\"/>";
        }
    }
    my $result =`$command`;
    EMD_PERL_DEBUG("Result of Discovery is");
    EMD_PERL_DEBUG($result);
    if ( $result =~ m/<DiscoveredDomains>/)
    {
        my $ind = index($result, "<DiscoveredDomains>");
        my $in = $ind + length("<DiscoveredDomains>");
        my $r1 = substr($result, $in);
        my $r2 = substr($result, 0, $in);
        $result = $r2."\n".$libraryPath.$r1;
        print $result;
    }
    else
    {
        print $result;
    }




    sub getOpenPorts()
    {
        $ENV{PATH} = "$ENV{PATH}:/usr/bin:/usr/sbin:/usr/ucb:/bin";
        chomp($os = $^O);
        if (($os ne "MSWin32") && ($os ne "MSWin64")) 
        {
            chomp($os = `uname -s`);
        }


        @NETSTAT = `netstat -an `;
        LINE: for $userline (@NETSTAT) 
        {
            if (index($userline, "127.0.0.1") >= 0) { next LINE; }

            if (index($userline, "LISTEN") < 0 && index($userline, "IDLE") < 0) { 
                next LINE; 
            }

            # for unix  domain sockets $userline has LISTENING, skip those lines
            if ($os eq "Linux" && index($userline, "LISTENING") >= 0) { 
                next LINE; 
            }

            # $userline looks like on solaris:
            #	*.*                  *.*                0      0 24576      0 IDLE
            #	*.7000               *.*                0      0 24576      0 LISTEN
            #	*.3201               *.*                0      0 24576      0 LISTEN
            #	130.35.38.158.3101   *.*                0      0 24576      0 LISTEN
            #	*.*                  *.*                0      0 24576      0 IDLE
            # $userline looks like on windows:
            #	(udp|tcp) [0-9\.]*:port                  *.*                IDLE

            @points = split(/[\t\ ]+/, $userline);


            # window windows there is a : in the  line
            if (index($userline, ":") > 0) 
            {
                if ($os eq "Linux") {
                    $p1 = $points[3];
                } else {
                    $p1 = $points[2];  # windows
                }

                @point = split(/:/, $p1);

                $p = $point[$#point];	# last item within <numeric ip>:<port number>, i.e. port
                $openports{$p} += 1;	# add <port> as a key to the lookup table
            } 
            else 
            {
                if ($os eq "HP-UX" || $os eq "OSF1" || $os eq "AIX") {
                    $p1 = $points[3];
                } else {
                    $i = index($userline, " ");
                    if ($i > 0)
                    {
                        $p1 = $points[0];
                    }
                    else
                    {
                        $p1 = $points[1];
                    }
                }

                if ($p1 ne "*\.*")
                {
                    @point = split(/\.+/, $p1);

                    $pl = @point;
                    $p = $point[$pl - 1];	# last item within <numeric ip>.<port number>, i.e. port
                    $openports{$p} += 1;	# add <port> as a key to the lookup table
                }
            }
        }

        return @openports;
    }

    sub trim 
    {
        my @out = @_;
        for (@out) 
        {
            s/^\s+//;
            s/\s+$//;
        }
        return wantarray ? @out : $out[0];
    }

    sub getWSHome
    {

        EMD_PERL_DEBUG("entered getWSHome ..........version=$version");
        my $lineToParse;
        my $ws;
        my $wsHome;
        chomp($os = $^O);
        my $computedVersion;

        if (($os ne "MSWin32") && ($os ne "MSWin64")) 
        {
            $ws = $home."/vpd.properties";
        }
        else
        {

        }

        if ( -e $ws)
        {

            open( WS, "<$ws" ) or die "Can't open $ws";

            while ( my $line = <WS> ) 
            {
                my @tempArray = split(/=/,$line);

                if(($tempArray[1] =~ /^WebSphere Application Server\|/) or
                    ($tempArray[1] =~ /^WebSphere Network Deployment\|/) or
                    ($tempArray[1] =~ /^IBM WebSphere Application Server\|/)
                )
                {
                    $lineToParse=$tempArray[1];
                    $versionToParse=$tempArray[0];
                    last;
                }
            }

            my @tokens = split(/\|/,$lineToParse);
            my $token;
            my $count = 0;
            my $prevToken;
            foreach $token (@tokens)
            {
                if($token =~ /\// and $prevToken =~ /\./)
                {
                    $wsHome = $token;
                    last;
                }
                $prevToken = $tokens[$count];
                $count++;
            }
            $computedVersion = $tokens[$count - 1];
            EMD_PERL_DEBUG("getWSHome ..........computedVersion=$computedVersion");

        }
        else
        {
        }

        close WS;
        if(defined($version) && $wsHome ne "")
        {
            #get first three chars of the version passed
            my $firstthree = substr($version,0,3);
            if($version =~ m/^5/)
            {
                if(!($computedVersion =~ m/^5/))
                {
                    $wsHome = "";
                }
            }
            else
            {
                if(!($computedVersion =~ m/^$firstthree/))
                {
                    $wsHome = "";    
                }

            }
    
        }
        EMD_PERL_DEBUG("end getWSHome ..........wshome=$wsHome");
        return $wsHome;
    }    

    sub getBEAHome
    {
        EMD_PERL_DEBUG("inside getBEAHome version: $version");            
        my $bea;
        my $beaHome;
        chomp($os = $^O);
        if (($os ne "MSWin32") && ($os ne "MSWin64")) 
        {
            $bea = $home."/bea/beahomelist";
        }
        else
        {
	    $homedrive = $ENV{'SYSTEMDRIVE'};        	
	    EMD_PERL_DEBUG("inside getBEAHome Bea Home System Drive: $homedrive");            
	    $bea = $homedrive."/bea/beahomelist";	    
        }
        if ( -e $bea)
        {

            open(BEAH, $bea);
            @rawdat = <BEAH>;
            @temArr = split(/;/,$rawdat[0]);
            my $token;
            foreach $token (@temArr)
            {
                chomp($token);
                my $installDir = getWLInstallDir($token);
                if(-e $installDir."/server/lib/weblogic.jar")
                {
                    $beaHome = $token;
                    last;
                }
            }            
        }
        else
        {
        }
        EMD_PERL_DEBUG("inside getBEAHome Bea Home: $beaHome");            
        return $beaHome;
    }

    sub getClasspath
    {
        my $type = @_[0];
        my $libpath = @_[1];
        my $classpath;
        my $pathSep;
	    my $sep;
	    EMD_PERL_DEBUG("version is ::: $version");            
        chomp($os = $^O);
        if (($os ne "MSWin32") && ($os ne "MSWin64")) 
        {
            $pathSep=":";
	    $sep = "/";
        }
        else
        {
            $pathSep=";";
	    $sep = "\\";
        }        
        if($type eq "weblogic")
        {
            my $containsJmx="false";	    
            my $versionAbove8 = "true";
            EMD_PERL_DEBUG("\nVersion = $version");
            if(defined($version))
            {
                if($version =~ /^7/ or $version =~ /^8/)
                {
                    if(!(-e $libpath."/wljmxclient.jar"))
                    {
                        $containsJmx = "true";
                    }
                    $versionAbove8 = "false";
                }
            }
            else
            {
                if(!(-e $libpath."/wljmxclient.jar"))
                {		
                    $containsJmx = "true";
                }
            }
            my $extraJar = "";
            if($versionAbove8 eq "true")
            {
                #Get the extra jars if version is 9 or above
                my $libRoot="$emdRoot".$sep."sysman".$sep."jlib";
                my $dir_to_read = $libRoot.$sep."extjlib";
                if(-d $dir_to_read && -r $dir_to_read)
                {
                    opendir(FILES_TO_READ, $dir_to_read);
                    my @the_files =  readdir (FILES_TO_READ);
                    $extraJar = $dir_to_read.$sep;
                    foreach $f (@the_files)
                    {
                        EMD_PERL_DEBUG("\nThe file=$f");
                        my(undef, undef, $ftype) = fileparse($f,qr"\.[^.]*");
                        EMD_PERL_DEBUG("\nExt=$ftype");
                        if($ftype eq ".jar")
                        {
                            EMD_PERL_DEBUG("\nAdding Jar file to cp =$f");
                            $extraJar = $extraJar.$pathSep.$dir_to_read.$sep.$f;
                        }
                    }#ForEach
                    closedir(FILES_TO_READ);
                }
            }

            if($containsJmx eq "true")
            {	    
                $classpath= $emdRoot."/lib/xmlparserv2.jar".$pathSep.              
                $emdRoot."/sysman/jlib/log4j-core.jar".$pathSep.
                $emdRoot."/modules/oracle.http_client_11.1.1.jar".$pathSep.
                $emdRoot."/sysman/jlib/emagentSDK.jar".$pathSep.
                $emdRoot."/jlib/emConfigInstall.jar";
            }
            else
            {	    
                #version 9X and above
                if(-e $libpath."/wlfullclient.jar")
                {
                    $classpath = 
                    $libpath."/wlfullclient.jar".$pathSep.
                    $libpath."/webserviceclient+ssl.jar".$pathSep
                }
                elsif(-e $libpath."/weblogic.jar")
                {
                    $classpath = 
                    $libpath."/weblogic.jar".$pathSep
                }
                else
                {
                    $classpath = 
                    $libpath."/wljmxclient.jar".$pathSep.
                    $libpath."/wlclient.jar".$pathSep
                }
                $classpath = $classpath.
                $emdRoot."/lib/xmlparserv2.jar".$pathSep.
                $emdRoot."/sysman/jlib/log4j-core.jar".$pathSep.
                $emdRoot."/modules/oracle.http_client_11.1.1.jar".$pathSep.
                $emdRoot."/sysman/jlib/emagentSDK.jar".$pathSep.
                $emdRoot."/jlib/emConfigInstall.jar";
            }
            #Add the extra jars if available
            if($versionAbove8 eq "true" and defined($extraJar) and $extraJar ne "")
            {
                $classpath=$extraJar.$pathSep.$classpath;
            }
            EMD_PERL_DEBUG("\nClasspath = $classpath");
        }
        else
        {
            EMD_PERL_DEBUG("Inside getClasspath for WAS $discovery_root ..........$discovery_root");
            my $wasVer;
            if(defined($version))
            {
                $wasVer = $version;
            }
            else
            {
                $wasVer = getWASVersion($libpath);
            }
            EMD_PERL_DEBUG("getWASVerion ..........$wasVer");
            if($wasVer =~ /^5/)
            {
                EMD_PERL_DEBUG("getWASVerion ..........inside block for version 5");
                find(\&getAllJars,$libpath."/java");
                my $containingjar = getWantedJar();
                if($containingjar ne "NotFound")
                {
                    $classpath = $containingjar.$pathSep;
                }

                $classpath = $classpath.$libpath."/lib/admin.jar".$pathSep.
                $libpath."/lib/jmxc.jar".$pathSep.
                $libpath."/lib/wsexception.jar".$pathSep.
                $libpath."/lib/wasjmx.jar".$pathSep.
                $libpath."/lib/wlmclient.jar".$pathSep.
                $libpath."/lib/soap.jar".$pathSep.
                $libpath."/lib/idl.jar".$pathSep.
                $libpath."/java/jre/lib/security.jar".$pathSep.
                $libpath."/java/jre/lib/ext/ibmjsse.jar".$pathSep.
                $libpath."/java/jre/lib/ext/mail.jar".$pathSep.
                $libpath."/java/jre/lib/ext/log.jar".$pathSep.
                $emdRoot."/lib/xmlparserv2.jar".$pathSep.
                $discovery_root."/archives/em-as-thirdparty-discovery.jar";
            }
            elsif($wasVer =~ /^6\.0/)
            {
                #for wasVersions 6.0.x
                EMD_PERL_DEBUG("getWASVerion ..........inside block for version 6.0.x");
                $classpath = $libpath."/lib/admin.jar".$pathSep.
                $libpath."/lib/management.jar".$pathSep.
                $libpath."/lib/wsexception.jar".$pathSep.
                $libpath."/lib/wssec.jar".$pathSep.
                $libpath."/lib/utils.jar".$pathSep.
                $libpath."/lib/ras.jar".$pathSep.
                $libpath."/lib/bootstrap.jar".$pathSep.                             
                $libpath."/lib/emf.jar".$pathSep.
                $libpath."/lib/sas.jar".$pathSep.
                $libpath."/lib/ffdc.jar".$pathSep.
                $libpath."/lib/soap.jar".$pathSep.
                $libpath."/lib/wasjmx.jar".$pathSep.
                $libpath."/lib/wlmclient.jar".$pathSep.
                $libpath."/lib/j2ee.jar".$pathSep.
                $libpath."/lib/classloader.jar".$pathSep.
                $libpath."/lib/wasproduct.jar".$pathSep.
                $libpath."/lib/runtime.jar".$pathSep.
                $libpath."/lib/iwsorb.jar".$pathSep.
                $libpath."/lib/idl.jar".$pathSep.
                $libpath."/lib/security.jar".$pathSep.
                $libpath."/java/jre/lib/ibmcertpathprovider.jar".$pathSep.
                $libpath."/java/jre/lib/endorsed/ibmcertpathprovider.jar".$pathSep.
                $libpath."/java/jre/lib/ext/ibmjceprovider.jar".$pathSep.
                $emdRoot."/lib/xmlparserv2.jar".$pathSep.
                $discovery_root."/archives/em-as-thirdparty-discovery.jar";
            }
            else
            {
                #for was versions 6.1 and above
                #org.eclipse.osgi_3.2.1.R32x_v20060919.jar is required for 6.1.0.11 and 6.1.0.13
                #ibmkeycert.jar is required bug 6241737
                # admin thin client jar name incase of WebSphere 7 is com.ibm.ws.admin.client_7.0.0.jar
                # also ibmjgssprovider.jar is needed when AdminSecurity on WebSphere 7 is enabled
                EMD_PERL_DEBUG("getWASVerion ..........inside block for version 6.1 and above");
                $classpath = $libpath."/runtimes/com.ibm.ws.admin.client_6.1.0.jar".$pathSep.
                $libpath."/runtimes/com.ibm.ws.admin.client_7.0.0.jar".$pathSep.
                $libpath."/plugins/com.ibm.ws.runtime_6.1.0.jar".$pathSep.
                $libpath."/plugins/org.eclipse.osgi_3.2.1.R32x_v20060919.jar".$pathSep.                
                $libpath."/java/jre/lib/ext/ibmkeycert.jar".$pathSep.                
                $libpath."/java/jre/lib/ibmjgssprovider.jar".$pathSep.
                $emdRoot."/lib/xmlparserv2.jar".$pathSep.
                $discovery_root."/archives/em-as-thirdparty-discovery.jar";
            }
 
        }
        
        return $classpath;
    }

    sub getWLInstallDir
    {
        if(defined($wlInstallDir))
        {
            EMD_PERL_DEBUG("inside getWLInstallDir Install Dir already computed: $wlInstallDir");
            return $wlInstallDir;
        }
        my $wlHome = @_[0];
        EMD_PERL_DEBUG("inside getWLInstallDir version: $version");
        EMD_PERL_DEBUG("inside getWLInstallDir beaHomeToken: $wlHome");
        open(REGISTRY,$wlHome."/registry.xml");
        my $releaseLevel;
        my $tempInstallDir;

        while ( my $line = <REGISTRY> ) 
        {
            if(defined($version))
            {
                if($line =~ m/\s+level=\"(.*?)\"/)
                {
                    $releaseLevel = $1;
                }
            }
            # get the line which has the text "InstallDir"
            if($line =~ m/InstallDir/i)
            {
                if($line =~ m/\s+InstallDir=\"(.*?)\"/)
                {
                    $tempInstallDir = $1;
                }
            }
        }
        close(REGISTRY);
        EMD_PERL_DEBUG("inside getWLInstallDir Release Version: $releaseLevel");

        if($releaseLevel and $releaseLevel ne /^$/)
        {
            $releaseLevel = substr($releaseLevel,0,1);            
            if($version =~ m/$releaseLevel/)
            {
                EMD_PERL_DEBUG("inside getWLInstallDir version and releaseLevel match"); 
                $installDir = $tempInstallDir; 
            }
        }
        else
        {
            $installDir = $tempInstallDir;
        }
        EMD_PERL_DEBUG("inside getWLInstallDir Install Directory is $installDir");
        $wlInstallDir = $installDir;
        return $installDir;
    }

    sub getWASVersion
    {
        my $wasHome = @_[0];
        my $productFile;
        my $version;
        opendir(DIR,$wasHome."/properties/version");
        while ($file = readdir(DIR) )
        {
            if(($file =~ m/WAS.product$/) || ($file =~ m/BASE.product$/) || ($file =~ m/ND.product$/))
            {
                $productFile= $file;
                last;
            }
        }
        closedir(DIR);
        open(PF,$wasHome."/properties/version/".$productFile);
        while ( my $line = <PF> ) 
        {
            if($line =~ m/<version>/i)
            {
                my $firstInd = index($line, ">");
                my $secondInd = index($line, "<",$firstInd);
                $version = substr($line,$firstInd+1,$secondInd-($firstInd+1));
                last;
            }
        }
        close(PF);
        return $version;
    }
    sub getAllJars
    {
        my $file = $File::Find::name;
        return unless -f $file;
        return  unless $file =~ m/.jar/;
        push(@alljars,$file);
    }

    sub getWantedJar
    {
        my $wantedjar;
        foreach my $jarfile (@alljars)
        {
            my $found = "false";
            open(FILEHANDLE, $emdRoot."/jdk/bin/jar -tvf ".$jarfile." |");
            while (my $line = <FILEHANDLE>) 
            {
                if ($line =~ m/$file_pattern/) 
                {
                    $found = "true";
                    $wantedjar = $jarfile;
                    last;
                }
            }
            close FILEHANDLE;
            if($found eq "true")
            {
                last;
            }
        }
        if($wantedjar and $wantedjar ne /^$/)
        {
            return $wantedjar;
        }
        else
        {
            return "NotFound";
        }

    }


    sub getXBootstrapClasspath
    {
        my $xbootstrapcp = "";
        my $lib = @_[0];
        my $pathSep;
        chomp($os = $^O);
        if (($os ne "MSWin32") && ($os ne "MSWin64"))
        {
            $pathSep=":";
        }
        else
        {
            $pathSep=";";
        }

        $xbootstrapcp = $lib."/lib/jmxc.jar".$pathSep.
                        $lib."/lib/jmxx.jar".$pathSep.
                        $lib."/lib/jmxext.jar".$pathSep.
                        $lib."/lib/jflt.jar".$pathSep.
                        $lib."/java/jre/lib/ext/log.jar"; 
        return $xbootstrapcp;
    }
}
1;
