#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/wmq.pl /main/8 2010/07/17 22:52:33 vepadman Exp $
#
# wmq.pl
# 
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      wmq.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    spandita    06/03/10 - NG Compliance
#    spandita    01/13/09 - 7705104
#    spandita    04/15/08 - Backport spandita_bug-6238232 from main
#    spandita    11/30/06 - fix the special chars
#    spandita    10/04/06 - pass JarPath argument to java
#    gaurkuma    09/26/06 - XbranchMerge gaurkuma_oac_bugs from main
#    gaurkuma    07/14/06 - MQ Script File 
#    gaurkuma    07/14/06 - MQ Script File 
#    vdwaram     04/16/06 - 
#    msathe      04/02/06 - 
#    vshrivas    12/14/05 - 
#    kchander    12/12/05 - Removing Hard Coded View path and replacing by 
#                           system environment variable/ 
#    vshrivas    11/22/05 - Creation
# 
# ---------------------------

discover(@ARGV);
my $channelName;
my $inputLength;
my $plugin_root;
my $discovery_root;
sub discover
{
    my $length = @_;
    $arg = @_[0];
    $oraHome = $ENV{ORACLE_HOME};
    require $oraHome."/sysman/admin/scripts/emd_common.pl";
    my $classpath;
    $plugin_root = $ENV{PLUGIN_ROOT};
    #work around copied the plugin jar to plugin_root as disc_root is not available
    $discovery_root = $plugin_root;    
    if($length == 2)
    {
        $channelName = @_[1];
        EMD_PERL_DEBUG("the channel name provided by user is $channelName");
    }
    $inputLength = ($arg  =~ tr/\|//);
    if($inputLength < 5)
    {
        ($hostName, $portNumber, $jarPath) = split(/\|/, $arg);
    }
    else
    {
        ($hostName, $portNumber, $jarPath, $userName, $password) = split(/\|/, $arg);
    }
    chomp($os = $^O);
    if (($os ne "MSWin32") && ($os ne "MSWin64"))
    {
        $userName =~ s/\'/\'\\\'\'/g;
        $password =~ s/\'/\'\\\'\'/g;

        $userName = "\'".$userName."\'";
        $password = "\'".$password."\'";
    }
    else
    {
        $userName =~ s/\"/\\"/g;
        $password =~ s/\"/\\"/g;

        $userName = "\"".$userName."\"";
        $password = "\"".$password."\"";
    }

	chomp($hostName, $portNumber);
    EMD_PERL_DEBUG("Starting MQ discovery:Host=$hostName and Port=$portNumber");
    EMD_PERL_DEBUG("and JarPath=$jarPath");
    $classpath = getClasspath($jarPath);
    $command = $oraHome."/jdk/bin/java -Doracle.home=".$oraHome;;
    if(defined($channelName))
    {
        EMD_PERL_DEBUG("Discovering with Channel Name $channelName");
        if($inputLength < 5)
        {
            @data = `$command -cp $classpath oracle.sysman.emas.thirdparty.discovery.wmq.MQTargetsDiscoverer $hostName $portNumber $jarPath $channelName`;
        }
        else
        {
            @data = `$command -cp $classpath oracle.sysman.emas.thirdparty.discovery.wmq.MQTargetsDiscoverer $hostName $portNumber $userName $password $jarPath $channelName`;
        }
    }
    else
    {
        EMD_PERL_DEBUG("Discovering without Channel Name");
        if($inputLength < 5)
        {
            @data = `$command -cp $classpath oracle.sysman.emas.thirdparty.discovery.wmq.MQTargetsDiscoverer $hostName $portNumber $jarPath`;
        }
        else
        {
            @data = `$command -cp $classpath oracle.sysman.emas.thirdparty.discovery.wmq.MQTargetsDiscoverer $hostName $portNumber $userName $password $jarPath`;
        }
    }

	print @data;
}


sub getClasspath
{
    my $jarPath = @_[0];
    my $classpath;
    my $pathSep;
    chomp($os = $^O);
    if (($os ne "MSWin32") && ($os ne "MSWin64"))
    {
        $pathSep=":";
    }
    else
    {
            $pathSep=";";
    }
    $classpath= $oraHome."/lib/xmlparserv2.jar".$pathSep.
                $discovery_root."/archives/em-as-thirdparty-discovery.jar".$pathSep.
                $jarPath;
    
    
    return $classpath;
}


