#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/wmqadmin.pl /main/7 2009/10/12 04:38:32 djoly Exp $
#
# third_party_control.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      third_party_control.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#       spandita 01/13/09 - 7705104
#       spandita 04/15/08 - Backport spandita_bug-6238232 from main
#       spandita 11/30/06 - fix special chars in username/pwd
#       spandita 11/22/06 - 5587967
#       spandita 10/11/06 - remove hardcoding
#       gaurkuma 09/26/06 - XbranchMerge gaurkuma_oac_bugs from main
#       gaurkuma 08/17/06 - XbranchMerge gaurkuma_mq_process_control from main
#       gaurkuma 09/07/06 - Should be merged with EMAGENT
#       gaurkuma 08/02/06 - Start/Stop wmq channel
#    gaurkuma   26/07/2006 - Creation
# 

my $oper = $ARGV[0];
my $target;
my $type;
my $hostname;
my $port;
my $username;
my $password;
my $lib;
my $svrConnChannel;
my $keystoreFilename;
my $oraHome = $ENV{ORACLE_HOME};
my $pathSep = getPathSep();

require $oraHome."/sysman/admin/scripts/emd_common.pl";
foreach $t (@ARGV)
{
    my @arg = split("=", $t);
    if ($arg[0] eq "targetName")
    {
        $target = $arg[1];
    }
    elsif ($arg[0] eq "targetType")
    {
        $type = $arg[1];
    }
    elsif ($arg[0] eq "MachineName")
    {
        $hostname = $arg[1];
    }
    elsif ($arg[0] eq "Port")
    {
        $port = $arg[1];
    }
    elsif ($arg[0] eq "UserName")
    {
        $username = $arg[1];
    }
    elsif ($arg[0] eq "password")
    {
        $password = $arg[1];
    }
    elsif($arg[0] eq "componentName")
    {
        $channel = $arg[1];
    }
    elsif($arg[0] eq "JARPath")
    {
        $lib = $arg[1];
    }   
    elsif($arg[0] eq "ServerChannel")
    {
        $svrConnChannel = $arg[1];
    }   
}

chomp($os = $^O);
if(defined($username) and $username ne /^$/)
{
    if (($os ne "MSWin32") && ($os ne "MSWin64"))
    {
        #replace single quote 
        $username =~ s/\'/\'\\\'\'/g;
        $password =~ s/\'/\'\\\'\'/g;

        #quote to avoid interpolation
        $username = "\'".$username."\'";
        $password = "\'".$password."\'";
    }
    else
    {
        #replace single quote 
        $username =~ s/\"/\\"/g;
        $password =~ s/\"/\\"/g;

        #quote to avoid interpolation
        $username = "\"".$username."\"";
        $password = "\"".$password."\"";
    }
}
EMD_PERL_DEBUG("process control for mq =$target and oper=$oper and channel=$channel and port=$port and hostname=$hostname and Path = $lib and channel = $svrConnChannel");
my $oraHome = $ENV{ORACLE_HOME};
my $command = $oraHome."/jdk/bin/java "; 
#$lib is the mq jar path
if(defined($svrConnChannel))
{
    EMD_PERL_DEBUG("Channel name was specified");
    if(defined($username) and $username ne /^$/)
    {
        $command = $command." -cp ".$lib.$pathSep.$oraHome."/sysman/jlib/emagentSDK.jar".$pathSep.$oraHome."/jlib/dms.jar".$pathSep.$oraHome."/jlib/ojdl.jar"." oracle.sysman.util.discover.StartStopWMQ ".$hostname." ".$port." ".$channel." ".$oper." ".$svrConnChannel." ".$username." ".$password;
    }
    else
    {
        $command = $command." -cp ".$lib.$pathSep.$oraHome."/sysman/jlib/emagentSDK.jar".$pathSep.$oraHome."/jlib/dms.jar".$pathSep.$oraHome."/jlib/ojdl.jar"." oracle.sysman.util.discover.StartStopWMQ ".$hostname." ".$port." ".$channel." ".$oper." ".$svrConnChannel;
    }
}
else
{
    if(defined($username) and $username ne /^$/)
    {
        $command = $command." -cp ".$lib.$pathSep.$oraHome."/sysman/jlib/emagentSDK.jar".$pathSep.$oraHome."/jlib/dms.jar".$pathSep.$oraHome."/jlib/ojdl.jar"." oracle.sysman.util.discover.StartStopWMQ ".$hostname." ".$port." ".$channel." ".$oper." ".$username." ".$password;
    }
    else
    {
        $command = $command." -cp ".$lib.$pathSep.$oraHome."/sysman/jlib/emagentSDK.jar".$pathSep.$oraHome."/jlib/dms.jar".$pathSep.$oraHome."/jlib/ojdl.jar"." oracle.sysman.util.discover.StartStopWMQ ".$hostname." ".$port." ".$channel." ".$oper;
    }

}
my $result =`$command`;
$result = createResponseXML4WMQ($oper,$result,$channel);
EMD_PERL_DEBUG("Result = $result");
print "$result\n";


sub createResponseXML4WMQ
{

    my $operation = @_[0];
    my $result = @_[1];
    my $targetName = @_[2];
    my $exitCode;
    my $respMessage;
    my $responseXML;
    my $Error = <STDERR>;
    if ( index($result, "0")  eq 0)
    {
        $exitCode = "0";
        $respMessage = "SUCCESS";
    }
    else
    {
        $exitCode = "1";
        $respMessage= $result;

    }

    $responseXML = "<Responses><Response><ExitCode>".$exitCode."</ExitCode><ResponseMessage>".$respMessage."</ResponseMessage><TargetName>".$targetName."</TargetName></Response></Responses>";
    return $responseXML;
}

sub getPathSep()
{
	my $sep;
	chomp($os = $^O);
    if (($os ne "MSWin32") && ($os ne "MSWin64")) 
    {
        $sep = ":";
    }
	else
    {
        $sep = ";";
    }
	return $sep;
	
}
