#!/usr/local/bin/perl
# 
# $Header: emfa/agent/scripts/DataFixHistory.pl /main/2 2011/07/15 15:25:05 vidykris Exp $
#
# emll/sysman/admin/scripts/fusionapps/DataFixHistory.pl
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      DataFixHistory.pl - Fusion Applications Patch Data Fix Script Execution History Information
#
#    DESCRIPTION
#      This script is used to collect the Fusion Applications Patch Data Fix Script Execution History Information
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vidykris    05/18/10 - Creation
# 
use strict;
use File::Spec;
use File::Basename;
use ias::simpleXPath;

my ($appl_top,$pfName) = @ARGV;

# Get the data fix history files directory
my $pfName_uc = uc($pfName);
my $appsDataFixDirectoryName = File::Spec->catfile($appl_top, "faPatchInventory", "fusionApps_$pfName_uc", "dfhistory");
if (-e $appsDataFixDirectoryName)
{
  my @files = <$appsDataFixDirectoryName/*.xml>; 
  @files = sort(@files);
  my $previousScriptName;
  my $executionId = 1;
  my $version = 1;
  
  foreach my $file (@files)
  {
    # Get the script name and timestamp by parsing the file name  
    my $fileName = basename($file);  
    my @fileSplits = split(/\__+|\./, $fileName, 2);
    my $scriptName = @fileSplits[0];
    my $strippedFile = @fileSplits[1];
    my @strippedSplits = split(/\_+|\./, $strippedFile, 2);
    $scriptName = $scriptName . '.' . @strippedSplits[0];
    my $fileTimestamp = @strippedSplits[1];
    
    # Format the timestamp as YYYY-MM-DD HH24:MM:SS
    my $formatedTimestamp = substr($fileTimestamp,0,4) . '-' . substr($fileTimestamp,4,2) . '-' . substr($fileTimestamp,6,2) . ' ' . substr($fileTimestamp,8,2) . ':' . substr($fileTimestamp,10,2) . ':' . substr($fileTimestamp,12,2);
    
    # Check to see if the current file is the same as the previous file
    if($scriptName eq $previousScriptName)
    {
      # The file names are the same. Increate the execution id
      $executionId++;
    }
    else
    {
      # The file names are not the same. Reset the previous file name and the execution id
      $previousScriptName = $scriptName;
      $executionId = 1;
    }
    
    # Get the version by parsing the file
    if(-r $file)
    {
        my $dfHistoryFile = ias::simpleXPath::parseFile($file);
        my $script = (ias::simpleXPath::queryForAttributes($dfHistoryFile, 'DFHistory/Script'))[0];
        $version = $script->{'VERSION'};
    }
    
    # Print the em result for Data Fix 
    print "em_result=$scriptName|$version|$executionId|$formatedTimestamp\n"
  }
}