#!/usr/local/bin/perl
# 
# $Header: emfa/agent/scripts/LBA.pl /main/1 2011/04/29 17:45:34 vidykris Exp $
#
# emll/sysman/admin/scripts/fusionapps/LBA.pl
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      LBA.pl - LBAs for Fusion Applications
#
#    DESCRIPTION
#      This script is used to collect the LBA information for fusion applications
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vidykris    11/19/10 - Accomodate Taxonomy file location change to ATGPF
#                           home
#    vidykris    05/17/10 - Creation
# 
use strict;
use File::Spec;
use ias::simpleXPath;

my ($appl_top, $productName, $productFamilyName) = @ARGV;

# Get the ATGPF home
my ($volume, $directories, $file) = File::Spec->splitpath($appl_top);
my @dirs = File::Spec->splitdir($directories);
pop @dirs;
my $fmw_home = File::Spec->catdir(@dirs);
my $atgpf_home = File::Spec->catdir($fmw_home, 'atgpf', 'atgpf', 'applcore', 'db', 'data', 'fa_taxonomy');

# Get the apps taxonomy file
my $appsTaxonomyFileName = File::Spec->catfile($atgpf_home, $productFamilyName . "_TaxonomyData.xml");

if ((-e $appsTaxonomyFileName) && (-r $appsTaxonomyFileName))
{
  my $appsTaxonomyFile = ias::simpleXPath::parseFile($appsTaxonomyFileName);
  
  # Get the LBA's
  my @lbas = ias::simpleXPath::queryForAttributes($appsTaxonomyFile, 'ProductFamily/ListOfProducts/Product[@Name="' . $productName . '"]/ListOfLBAs/LBA');
  
  #Iterate through each lba and get the desired information
  foreach my $lba (@lbas)
  {
    my $lbaName = $lba->{'name'};
    print "em_result=$productName|$lbaName\n"
  }
}
