#!/usr/local/bin/perl
# 
# $Header: emfa/agent/scripts/faTargetVersion.pl /main/3 2011/07/11 21:42:26 vidykris Exp $
#
# faTargetVersion.pl
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      faTargetVersion.pl - This script returns the target version of the FA component
#
#    DESCRIPTION
#      Users are required to pass the ApplTop, the EM target type and the Product Family short name if applicable
#
#    NOTES
#      If the passed type is a Product Family, then the script will use the short name that's passed to get the Version
#      If the passed type is NOT a product family, then the script will return the Fusion Instance version
#
#    MODIFIED   (MM/DD/YY)
#    vidykris    12/07/10 - Creation
# 

require "emd_common.pl";

use strict;
use File::Spec;
use ias::simpleXPath;

# Begin script
EMAGENT_PERL_DEBUG("\nStarted faTargetVersion script - faTargetVersion.pl\n");

my ($appl_top, $compType, $compName) = @ARGV;
EMAGENT_PERL_DEBUG("appl_top, compType, compName: $appl_top, $compType, $compName\n"); 

# Check to see if the type is a product family. If yes use the compName to get the OUI component
# If the type is not a component, then get the version of top (Fusion Instance)
my $version;  
if($compType =~ "component")
{
  # Passed type is a product family. 
  EMAGENT_PERL_DEBUG("Getting the Component Version\n");
  $version = get_apps_version($appl_top, $compName);
}
else
{
  # Passed type is NOT a product family. 
  EMAGENT_PERL_DEBUG("Getting the Top Version\n");
  $version = get_instance_version($appl_top);
}

# Default the version to  11.1.1.5.0 if its not defined 
if (!defined($version))
{
  $version=" 11.1.1.5.0";
}
EMAGENT_PERL_DEBUG("version: $version\n");
print "$version";

# subroutine get_instance_version
# The version of the fa install
# $_[0] - value of version
sub get_instance_version
{
  my ($appl_top) = $_[0];
  my $oui_component_version;   
  
  if (defined($appl_top))
  {
    # Get the version
    my $comps_file_name = File::Spec->catfile($appl_top, "inventory", "ContentsXML", "comps.xml");
    if ((-e $comps_file_name) && (-r $comps_file_name))
    {
      my $comps_file = ias::simpleXPath::parseFile($comps_file_name); 
      
      my $oui_component_version_node = (ias::simpleXPath::queryForAttributes($comps_file, 'PRD_LIST/TL_LIST/COMP[@NAME="oracle.fusionapps.top"]'))[0];
      if(defined($oui_component_version_node))
      {
        $oui_component_version = $oui_component_version_node->{'VER'};
      }      
    }
  }
  return $oui_component_version;
}

# subroutine get_apps_version
# The version of the fa product family
# $_[0] - value of version
sub get_apps_version
{
  my ($appl_top) = $_[0];
  my ($pf_name) = $_[1];
  my $oui_component_version;
  
  if (defined($appl_top))
  {
    my $oui_component_name = get_oui_component_name($appl_top, $pf_name); 
    EMAGENT_PERL_DEBUG("oui_component_name: $oui_component_name\n");    
 
    # Get the version
    my $comps_file_name = File::Spec->catfile($appl_top, "inventory", "ContentsXML", "comps.xml");
    if ((-e $comps_file_name) && (-r $comps_file_name) && ($oui_component_name))
    {      
      my $comps_file = ias::simpleXPath::parseFile($comps_file_name);   
      
      my $oui_component_version_node = (ias::simpleXPath::queryForAttributes($comps_file, 'PRD_LIST/COMP_LIST/COMP[@NAME="' . $oui_component_name . '"]'))[0];
      if(defined($oui_component_version_node))
      {
        $oui_component_version = $oui_component_version_node->{'VER'};
      }           
    }   
  }        
  return $oui_component_version;  
}

# subroutine get_oui_component_name
# The oui component name of the fa product family
# $_[0] - oui component name
sub get_oui_component_name
{
  my ($appl_top) = $_[0];
  my ($pf_name) = $_[1];
  my $oui_component_name; 

  if (defined($appl_top))
  {
    my $pf_oui_mapping_file_name = File::Spec->catfile($appl_top, "pfOUImapping.xml");
    if ((-e $pf_oui_mapping_file_name) && (-r $pf_oui_mapping_file_name))
    {      
      my $pf_oui_mapping_file = ias::simpleXPath::parseFile("$pf_oui_mapping_file_name");              
      $oui_component_name = ((ias::simpleXPath::queryForAttributes($pf_oui_mapping_file, 'ProductFamilyOUIMappings/Mapping[@TYPE="product_family"][@NAME="' . $pf_name . '"]/Property[@NAME="ouicomponent"]'))[0])->{'VALUE'};      
    }
  }      
  return $oui_component_name;
}