#!/usr/local/bin/perl
# 
# $Header: emfa/agent/scripts/fusion_middleware_control.pl /main/1 2011/11/04 08:30:58 bevoss Exp $
#
# fusion_middleware_control.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      fusion_middleware_control.pl - Standardized name shared with EMAS version.
#
#    DESCRIPTION
#      Sets up the classpath and calls Java to start or 
#      stop a target from the EMFA agent plugin.
#
#    NOTES
#      This is an EMFA substitute for 
#      emas/sysman/admin/scripts/fusion_middleware_control.pl
#      The script name is hard-coded in
#      emas/jsrc/sdk/oracle/sysman/emas/sdk/pcs/model/PCSProcessUtil.java
#      as
#      private static final String PERL_SCRIPT_LOCATION =
#            "%emd_plugin_root%/scripts/fusion_middleware_control.pl";
#
#      This file was originally created to support oracle_gop_server targets.
#      it is normally invoked via
#      emfa/sysman/metadata/jobTypes/FusionAppsProcessControl.xml
#
#
#    MODIFIED   (MM/DD/YY)
#    bevoss      10/21/11 - Creation
# 
#
#    DESCRIPTION
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    bevoss      09/21/11 - Creation
# 
use File::Find;

my $flagtype = $ARGV[0];
my $oper = $ARGV[1];
my $oraHome = $ENV{EMDROOT};
my $pluginRoot = $ENV{PLUGIN_ROOT};
my $agentStateDir = $ENV{EMSTATE};
my $pathSep = getPathSep();
my $sep = "/";
if (( $^O =~ "Windows" ) || ($^O =~ "MSWin32"))
{
  $sep = "\\";
}

my $keystoreFilename = $agentStateDir."$sep"."sysman"."$sep"."config"."$sep".montrust."$sep"."AgentTrust.jks";

require $oraHome."/sysman/admin/scripts/emd_common.pl";

EMD_PERL_DEBUG("EMFA Fusion Middleware control operation for Flag Type $flagtype");

my %argMap = (); 
foreach $t (@ARGV)
{
    my @arg = split("#", $t);

        #$arg[0] possible values are targetName, targetType,MachineName,Port,WeblogicHome,Protocol,OPMNMBean,CompName,appVersion,targetServer,moduleType,simpleAppName,sso

        $argMap{$arg[0]} = $arg[1];

}

my $target = $argMap{'targetName'};
my $type   = $argMap{'targetType'};
my $hostname  = $argMap{'MachineName'};
my $port   = $argMap{'Port'};
my $weblogichome   = $argMap{'WeblogicHome'};
my $protocol   = $argMap{'Protocol'};
my $opmnmbean   = $argMap{'OPMNMBean'};
my $componentname   = $argMap{'CompName'};
my $appVersion   = $argMap{'appVersion'};
my $targetServer   = $argMap{'targetServer'};
my $moduleType   = $argMap{'moduleType'};
my $simpleAppName   = $argMap{'simpleAppName'};
my $sso   = $argMap{'sso'};
my $clusterName = $argMap{'ClusterName'};
my $customTarget= $argMap{'customTarget'};
my $customTargets= $argMap{'customTargets'};
my $extraParams = $argMap{'extraParams'};

EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$flagtype = $flagtype \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$oper = $oper \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$oraHome = $oraHome \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$pluginRoot = $pluginRoot \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$agentStateDir = $agentStateDir \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$pathSep = $pathSep \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$sep = $sep \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$target = $target \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$type   = $type   \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$hostname  = $hostname  \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$port   = $port   \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$weblogichome   = $weblogichome   \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$protocol   = $protocol   \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$opmnmbean   = $opmnmbean   \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$componentname   = $componentname   \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$appVersion   = $appVersion   \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$targetServer   = $targetServer   \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$moduleType   = $moduleType   \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$simpleAppName   = $simpleAppName   \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$sso   = $sso   \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$clusterName = $clusterName \n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$customTarget= $customTarget\n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$customTargets= $customTargets\n");
EMD_PERL_DEBUG("EMFA Fusion Middleware Control \$extraParams = $extraParams \n");

my $implClass = "";

# Special case code for oracle_gop_server targets
if (($flagtype eq "OPMNComp") && ($type eq "oracle_gop_server")) {
    $flagtype = "customCmdline";
    $implClass = "oracle.sysman.fa.agent.pojo.gop.GOPProcessControl";

    EMD_PERL_DEBUG("EMFA Fusion Middleware Control Special case for oracle_gop_server targets \$implClass = $implClass \n");
}

my $classpath = 
    $oraHome."/lib/xmlparserv2.jar".
    $pathSep.$oraHome."/sysman/jlib/emagentSDK.jar".
    $pathSep.$pluginRoot."/archives/em-fa-agent-pojo.jar".
    $pathSep.$pluginRoot."/archives/jlib/emasSDK.jar".
    $pathSep.$weblogichome."/server/lib/weblogic.jar".
    $pathSep.$weblogichome."/server/lib/wljmxclient.jar".
    $pathSep.$weblogichome."/server/lib/wlclient.jar".
    $pathSep.$pluginRoot."/archives/jlib/wljmxclient.jar".
    $pathSep.$pluginRoot."/archives/jlib/wlclient.jar";



if($flagtype eq "customCmdline") {
        my ($exitcode,$response) = customCmdlineTargetHandler();        
        print $response;
        exit $exitcode;

}

chomp($os = $^O);
EMD_PERL_DEBUG("EMFA Fusion Middleware control operation for target $target and type $type");
EMD_PERL_DEBUG("EMFA Fusion Middleware control operation=$oper");
EMD_PERL_DEBUG("EMFA Fusion Middleware control hostname=$hostname and port $port");

sub getPathSep()
{
        my $sep;
        chomp($os = $^O);
    if (($os ne "MSWin32") && ($os ne "MSWin64")) 
    {
        $sep = ":";
    }
        else
    {
        $sep = ";";
    }
        return $sep;
        
}


sub customCmdlineTargetHandler
{
        EMD_PERL_DEBUG("EMFA Fusion Middleware control operation for $type");

        my $command = $oraHome."/jdk/bin/java ";
        if(("t3s" eq $protocol) || ("iiops" eq protocol))
        {
                $command = $command." -Djavax.net.ssl.trustStore=".$keystoreFilename;
        }

        # To add an additional parameter first put dot (.) for string concatination,followed by
        # a space (" ") to be left between params, followed by again dot (.),followed by double-quote start
        # ("\""), followed by actual parameter (eg $port), followed by dot and double-quote end ("\"")
        $command = $command." -cp ".$classpath." oracle.sysman.emas.sdk.process.StartStopFMW ".
                "\"".$hostname. "\""." ". "\"".$port. "\""." ". "\"".$protocol. "\""." ". "\"".$target. "\""." ". "\"".$type. "\""." ". "\"".$oper. "\""." ". "\"".$flagtype. "\""." ". "\"".$extraParams. "\"";


        #Handle custom components based on j2ee app
        if(((defined $simpleAppName) && ($simpleAppName ne ""))
           || (defined $implClass) && ($implClass ne "")){ 
         $command = $command." ". "\"".$appVersion. "\""." ". "\"".$targetServer."\""." ". "\"".$moduleType."\""." ". "\"".$simpleAppName."\""." ". "\"".$sso."\"";

         # Finally add the implClass as argument 13
         if((defined $implClass) && ($implClass ne "")){ 
           $command = $command." ". "\"".$implClass."\"";
         }
        }

        EMD_PERL_DEBUG("EMFA Fusion Middleware control operation for target with customCmdline handler: $command");
        my $result =`$command`;
        EMD_PERL_DEBUG("EMFA Fusion Middleware control operation result=$result");

        return echoResult($result);
}



sub echoResult {

my $result = @_[0];

my $exitcode = 0;
my $response = "";
 if ( $result =~ m/<Responses>/)
    {
        my $ind = index($result, "<Responses>");
        my $indend = index($result, "</Responses>");
        my $offset = $indend - $ind +  length("</Responses>");
        $result = substr($result,$ind, $offset);
        # this logic fails in case of multiple Response elements and hence multiple ExitCode elements
        my $ind1 =  index($result, "<ExitCode>");
        my $offset1 = 1;
        #Get first character after <ExitCode>. It will be a number
        $exitcode =  substr($result,$ind1+length("<Response>"), $offset1);

        my $ind2 = index($result, "<ResponseMessage>");
        my $indend2 = index($result, "</ResponseMessage>");
        my $offset2 = $indend2 - $ind2 -  length("<ResponseMessage>") ;
        $response = substr($result,$ind2 + length("<ResponseMessage>"), $offset2);

    }

        return ($exitcode,$response);
}
