#!/usr/local/bin/perl
# 
# $Header: emfa/agent/scripts/fusionapps/printFusionInstancePfAssociations.pl /main/1 2011/06/29 20:52:43 vidykris Exp $
#
# printFusionInstancePfAssociations.pl
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      printFusionInstancePfAssociations.pl - Fusion Instance Product Family associations
#
#    DESCRIPTION
#      All these associations will have a contains relationship
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vidykris    05/04/11 - Remove explicit OH asociation
#    vidykris    09/01/10 - XbranchMerge vidykris_bug-10014386 from
#                           st_emll_10.3.4
#    vidykris    08/27/10 - XbranchMerge vidykris_fa_ocm_072810_dm from
#                           st_emll_10.3.4
#    vidykris    08/11/10 - Bug fix 10014386
#    vidykris    08/02/10 - Pass the Appl_Top for resolving resolutions
#    vidykris    06/10/10 - Creation
# 
use strict;

my $oracleHome = $ENV{'ORACLE_HOME'};
my $applTop = shift(@ARGV);
my $hostName = shift(@ARGV);
my $instance_pfs = shift(@ARGV);

my $assoc = 'contains';
my @params = split('\|', $instance_pfs);
my $paramsLength = scalar(@params);
my $index = 0;

for($index  = 0;  $index < $paramsLength; $index+=3)
{
  my $targetName = $params[$index];
  if (!($targetName eq '' || $targetName =~ /^%.*%$/))
  {
    my $targetType = $params[$index+1];
    my $hostName = $params[$index+2];
    if (!($targetType eq '' || $targetType =~ /^%.*%$/ || $hostName eq '' || $hostName =~ /^%.*%$/))
    {
      print "em_result=$assoc|$targetName|$targetType|$hostName:$applTop\n";
    }
  }
}
