#!/usr/local/bin/perl
# 
# $Header: emfa/agent/scripts/printFusionAppsAssociations.pl /main/1 2011/04/29 17:45:34 vidykris Exp $
#
# emll/sysman/admin/scripts/fusionapps/printFusionAppsAssociations.pl
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      printFusionAppsAssociations.pl - Fusion Application associations
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vidykris    09/01/10 - XbranchMerge vidykris_bug-10014386 from
#                           st_emll_10.3.4
#    vidykris    08/27/10 - XbranchMerge vidykris_fa_ocm_072810_dm from
#                           st_emll_10.3.4
#    vidykris    08/11/10 - Bug fix 10014386
#    vidykris    08/02/10 - Pass the Appl_Top for resolving resolutions
#    vidykris    04/13/10 - Creation
# 
use strict;

my $oracleHome = $ENV{'ORACLE_HOME'};
my $applTop = shift(@ARGV);
my $hostName = shift(@ARGV);

# Find the last association with a unique type, that has a target name
my %assocs = ();
for my $assoc (@ARGV)
{
    my @params = split('\|', $assoc);
    my $assocType = $params[0];
    my $targetName = $params[1];
    if ($targetName eq '' || $targetName =~ /^%.*%$/)
    {
        # Target name is missing
        next;
    }
    $assocs{$assocType} = $assoc;
}
# Print associations including the target property <host name>:<oracle home>
for my $assocType (keys %assocs)
{
    my $assoc = $assocs{$assocType};
    print "em_result=$assoc|$hostName:$applTop\n";    
}

# Print the explicit OH association
# Since the Oracle Home target's OH is also proxied, use the real $applTop value in resolving the resolution
my $ohAssoc = "depends_on";
my $ohTargetType = "oracle_home";
print "em_result=$ohAssoc|$applTop|$ohTargetType|$hostName:$applTop\n";
