#!/usr/local/bin/perl
# 
# $Header: emcore/builtin_target_types/oracle.sysman.emrep/agent/scripts/emConsoleSecure.pl /main/2 2011/04/05 19:04:37 tsubrama Exp $
#
# emConsoleSecure.pl
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      emConsoleSecure.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED       (MM/DD/YY)
#    tsubrama        02/24/11 - pulled from EMLL label for model convergence.
#    raankire        02/16/10 - Creation
# 
#!/usr/local/bin/perl
##########################################################################################
################ LOGIC OF GETTING EM CONSOLE SECURE STATUS ###############################
##########################################################################################
#
#Inputs For this PL are 1) ORACLE HOME  
#                       2) oracle.sysman.emSDK.svlt.ConsoleServerPort(Server Port)
#                       3) oracle.sysman.emSDK.svlt.ConsoleServerHTTPSPort (HTTPS Port)
#Parsing the File : $OMS_HOME/sysman/config/httpd_em.conf and checking for the below logic
#
#   1. Searching for <VirtualHost *:<Server Port>> If not found then loading secure_status=NULL
#   2. Then searching for the string <Location /em/console>, From <VirtualHost *:<Server Port>> to </VirtualHost>
#         1. If not find it: console secure_status=unsecure
#	 The following points 2,3 and 4 will be searched between <Location /em/console> to </Location>
#        2. You find it and you do not have the line Deny from all: console secure_status=unsecure
#        3. You find it and you do have the line Deny from none: console secure_status=unsecure
#        4. You find it and you have the line Deny from all: Then 
#               1. Search for <VirtualHost *:<HTTPS Port>>
#               2. Search for the string <Location /em/console>, From <VirtualHost *:<HTTPS Port>> to </VirtualHost>
#                     1. You do not find it: console secure_status=unsecure
#                        The following points 2,3 and 4 will be searched between <Location /em/console> to </Location>
#                     2. You find it and you do not have the line Deny from all: console secure_status=unsecure 
#                     3. You find it and you have the line Deny from none: console secure_status=unsecure
#                     4. You find it and you have the line Deny from all: console secure_status=secure
#
#
########################################################################################
use strict;
use File::Spec;

#require "emd_common.pl";
#require "semd_common.pl";

require "emd_common_ocm.pl";

sub getConsoleSecure
{
if (@_ == 3) {
my $oracleHome =$_[0]; 

##Added by RAANKIRE for adding secure_status column

my $server_port=$_[1];
my $https_port=$_[2];
my $secure_status;

##Reading the file httpd_em.conf
my $oms_httpd_em_file = File::Spec->catfile( $oracleHome, "sysman", "config", "httpd_em.conf" );
my @httpd_em_file_content;

if (-f $oms_httpd_em_file)
{
    open (FILE, "<$oms_httpd_em_file") or EMD_PERL_DEBUG("Unable to open $! \n",$oms_httpd_em_file);
    my $line;
    my $i=0;
    #Scan through the file assigning the various parameters to get the values
    while ($line = <FILE>)
    {
        chomp;
       $line=~ s/#.*/comment/;                # no comments
       $line=~ s/^\s+//;               # no leading white
       $line=~ s/\s+$//;
	chomp $line;
               # no trailing white
	if ($line eq "comment") {
	} else {
	 $httpd_em_file_content[$i++]=$line;
        }

    }
    close FILE;
}


my $i;
##Getting VirtualHost tag start and end location for ServerPort
my $vh_sp_s="<VirtualHost *:$server_port>";
my $vh_sp_e="</VirtualHost>";

my $index_sp_s;
my $index_sp_e;

 ($index_sp_s) = grep $httpd_em_file_content[$_] eq $vh_sp_s, 0 .. $#httpd_em_file_content;

 if ($index_sp_s > 0) {
  ($index_sp_e) = grep $httpd_em_file_content[$_] eq $vh_sp_e, $index_sp_s .. $#httpd_em_file_content;
 }

if ($index_sp_s > 0 && $index_sp_e > 0) {
##Getting /em/console tag start and end location for ServerPort
  my $index_emconsole_sp_s;
  my $index_emconsole_sp_e;
  ($index_emconsole_sp_s) = grep $httpd_em_file_content[$_] eq "<Location /em/console>", $index_sp_s .. $index_sp_e;
  if ($index_emconsole_sp_s > 0) {
   my ($index_emconsole_sp_e) = grep $httpd_em_file_content[$_] eq "</Location>", $index_emconsole_sp_s .. $index_sp_e;
   if ($index_emconsole_sp_e > 0) {
    my $dfn;
    my $dfa;
     foreach $i ($index_emconsole_sp_s+1..$index_emconsole_sp_e-1) {
       if (lc($httpd_em_file_content[$i]) eq "deny from none") {
	$dfn="DFN";
       }elsif (lc($httpd_em_file_content[$i]) eq "deny from all") {
        $dfa="DFA";
       }
     }

     if ($dfn eq "DFN" && $dfa ne "DFA") {
      $secure_status="Unsecure";
     } elsif ($dfa eq "DFA") {
      
	##Repeat the same above logic form HTTPS Port
	my $k;
	my $vh_hp_s="<VirtualHost *:$https_port>";
	my $vh_hp_e="</VirtualHost>";

	my $index_hp_s;
	my $index_hp_e;
	
	 ($index_hp_s) = grep $httpd_em_file_content[$_] eq $vh_hp_s, 0 .. $#httpd_em_file_content;
	
	 if ($index_hp_s > 0) {
	  ($index_hp_e) = grep $httpd_em_file_content[$_] eq $vh_hp_e, $index_hp_s .. $#httpd_em_file_content;
	 }
	
	if ($index_hp_s > 0 && $index_hp_e > 0) {
	  my $index_emconsole_hp_s;
	  my $index_emconsole_hp_e;
	  ($index_emconsole_hp_s) = grep $httpd_em_file_content[$_] eq "<Location /em/console>", $index_hp_s .. $index_hp_e;
	  if ($index_emconsole_hp_s > 0) {
	   my ($index_emconsole_hp_e) = grep $httpd_em_file_content[$_] eq "</Location>", $index_emconsole_hp_s .. $index_hp_e;
	   if ($index_emconsole_hp_e > 0) {
	    my $dfn_hp;
	    my $dfa_hp;
	     foreach $k ($index_emconsole_hp_s+1..$index_emconsole_hp_e-1) {
	       if (lc($httpd_em_file_content[$k]) eq "deny from none") {
	        $dfn_hp="DFN";
	       }elsif (lc($httpd_em_file_content[$k]) eq "deny from all") {
	        $dfa_hp="DFA";
	       }
	     }
	     if ($dfn_hp eq "DFN" && $dfa_hp ne "DFA") {
	      $secure_status="Unsecure";
	     } elsif ($dfa_hp eq "DFA") {
	      $secure_status="Secure";
	
	     } else {
	      $secure_status="Unsecure";
	     }
	   } 

	
	  } else {
	   $secure_status="Unsecure";
	  }
	
	}	
	
	##Repeat
     } else {
      $secure_status="Unsecure";
     } 
   } 

  } else {
   $secure_status="Unsecure";
  }

}
##End of secure_status column code by RAANKIRE
return $secure_status;
}else {
EMD_PERL_DEBUG("Three arguments should pass to this subroutine");
return;
}
}

