#!/usr/local/bin/perl
# 
# $Header: emcore/builtin_target_types/oracle.sysman.emrep/agent/scripts/emrepConfiguration.pl /main/1 2010/12/30 01:36:17 tsubrama Exp $
#
# emrepConfiguration.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      emrepConfiguration.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    tsubrama    11/30/10 - creation
#    tsubrama    11/30/10 - Creation
#
use strict;
use Oraperl;
use Time::HiRes;
use DBI;
use DBD::Oracle qw(:ora_types);

require "emd_common.pl";
require "semd_common.pl";

my $param = shift;
my $db_connect = "";

if ( $ENV{CONNECTDESCRIPTOR} ne "" )
{
  #$db_connect = $ENV{EM_REPOS_USER} . "/" . $ENV{EM_REPOS_PWD} . "@" . $ENV{CONNECTDESCRIPTOR};
  $db_connect = $ENV{CONNECTDESCRIPTOR};
  EMD_PERL_DEBUG("Env CONNECTDESCRIPTOR $db_connect\n");
}
else
{
  #$db_connect = $ENV{EM_REPOS_USER} . "/" . $ENV{EM_REPOS_PWD} . "@" . $ENV{EM_TARGET_ADDRESS};
  $db_connect = $ENV{EM_TARGET_ADDRESS};
  EMD_PERL_DEBUG("Env EM_TARGET_ADDRESS $db_connect\n");
}



########## Using DBI to execute the stored procedure and get the required data ####
my $DB_Connection = DBI->connect("dbi:Oracle:$db_connect",
     $ENV{EM_REPOS_USER},
     $ENV{EM_REPOS_PWD},
    {
       RaiseError =>0
    }
);

if( !$DB_Connection ) {
   EMD_PERL_DEBUG("Getting repository connection failed. Error: $DBI::errstr $DBI::err $DBI::state\n");
   exit 0;
}



eval {
    my $config_data_cursor;
    $DB_Connection->{RaiseError} = 1;
    my $prepare_stmt = $DB_Connection->prepare(q{
        BEGIN
           :config_data_cursor := mgmt_emrep_oob_monitoring.GET_CONFIG_METRIC_DATA(:param);
        END;
    });
   $prepare_stmt->bind_param(":param",$param);
   $prepare_stmt->bind_param_inout(":config_data_cursor", \$config_data_cursor, 0, { ora_type => ORA_RSET });
   $prepare_stmt->execute;

   my @row_data;
   my $arry_size;
   my $index;
   my $row_data_txt;

   while ( @row_data = $config_data_cursor->fetchrow_array )
   {
     $arry_size = scalar(@row_data);

     if($arry_size gt 0)
     {
       $index = 0;
       $row_data_txt = "";
       for($index=0;$index<$arry_size;$index++){
          if ($index eq 0 )
          {
            $row_data_txt = $row_data[$index];
          }
          else
          {
            $row_data_txt =  $row_data_txt. '|' .  $row_data[$index];
          }
        } # end of for loop

       print  "em_result=$row_data_txt\n"   
     }# end of if

   } # end of while loop


 }; # end of eval


if( $@ ) {
  my $err_msg =  $DBI::errstr;

  ## check whether error is for plsql package/function not available.
  if(index($err_msg,"ORA-06550:")>-1){

     EMD_PERL_DEBUG("Getting data from repository failed. Check OMS version compatibility. Error: $err_msg $DBI::err $DBI::state\n");
     close_dbconnection($DB_Connection);
     exit 0;

  }else{ ## any other errors.

    EMD_PERL_DEBUG("Getting data from repository failed. Error: $err_msg $DBI::err $DBI::state\n");
    close_dbconnection($DB_Connection);
    exit 0;

  }

}

## close the db connection after getting the data.
close_dbconnection($DB_Connection);

exit 0;

sub close_dbconnection
{
   my $l_conn = $_[0];
   if ($l_conn)
   {
     $l_conn->disconnect ;
     EMD_PERL_DEBUG("Closing DB Connection\n");
   }
}


