#  $Header: emcore/builtin_target_types/oracle.sysman.emrep/agent/scripts/emrep_dynamic_props.pl /main/3 2011/06/12 20:51:24 tsubrama Exp $
#
# Copyright (c) 2001, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      emrep_dynamic_props.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <description>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#      tsubrama  06/07/11 - removing isPre12G because ocm will not discover
#                           emrep target
#      tsubrama  04/26/11 - getting value for isPre12G
#      tsubrama  12/15/10 - Creation
#

use strict;
use Oraperl;
use DBI;
use DBD::Oracle qw(:ora_types);
use Time::HiRes;

require "emd_common.pl";
require "semd_common.pl";
require "mtm_util.pl";

my $db_connect = "";
EMD_PERL_DEBUG("Connectdescriptor $ENV{CONNECTDESCRIPTOR}");
if ( $ENV{CONNECTDESCRIPTOR} ne "" )
{
  $db_connect = $ENV{CONNECTDESCRIPTOR};
}
else
{
  $db_connect = $ENV{EM_TARGET_ADDRESS};
}

my $start_time = Time::HiRes::time;
########## Using DBI to execute the stored procedure and get the required data ####
my $DB_Connection = DBI->connect("dbi:Oracle:$db_connect",
     $ENV{EM_REPOS_USER},
     $ENV{EM_REPOS_PWD},
    {
       RaiseError =>0
    }
);

if( !$DB_Connection ) {
   EMD_PERL_DEBUG("Getting repository connection failed. Error: $DBI::errstr $DBI::err $DBI::state");
   exit 0;
}


my $emrep_version;


eval {
    my $data_cursor;
    $DB_Connection->{RaiseError} = 1;
    my $prepare_stmt = $DB_Connection->prepare(q{
        BEGIN
           :data_cursor := mgmt_emrep_oob_monitoring.GET_OOB_DATA_FOR_STATUS();
        END;
    });
   $prepare_stmt->bind_param_inout(":data_cursor", \$data_cursor, 0, { ora_type => ORA_RSET });
   $prepare_stmt->execute;

   my @row_data;
   @row_data = $data_cursor->fetchrow_array;

   EMD_PERL_DEBUG("data from repository... @row_data");

   my $arry_size = scalar(@row_data);
   if($arry_size>=5){
      $emrep_version = $row_data[4];
   }
};

if( $@ ) {
    my $err_msg =  $DBI::errstr;

    EMD_PERL_DEBUG("Getting data from repository failed. Error: $err_msg $DBI::err $DBI::state");
    close_dbconnection($DB_Connection);
    exit 0;

}

print "em_result=$emrep_version\n";

## close the db connection after getting the data.
close_dbconnection($DB_Connection);


sub close_dbconnection
{
   my $l_conn = $_[0];
   $l_conn->disconnect if ($l_conn);
   my $end_time = Time::HiRes::time;
   my $logon_time = ($end_time - $start_time) * 1000;
   EMD_PERL_DEBUG("Time in getting data from repos: $logon_time" );

}

