# insert the commands you wish to execute when eml fails to stay running. 
#
#
# Mail to specified user
#
#  The message text is passed in as the first parameter. 
#  The subject is passed in as the optional second parameter.  Default subject is 'Enterprise Manager is down'
#

use strict;
use Oraperl;
use Net::SMTP;
use File::Spec;

require "emd_common.pl";
require "semd_common.pl";
require "mtm_util.pl";

# Sends e-mail
# 1st arg: gateway
# 2nd arg: to address
# 3rd arg: from address
# 4th arg: subject
# 5th arg: body
sub sendMail
{
  my $smtp;
  my $gateway = $_[0];
  my $toEmail = $_[1];
  my $fromEmail = $_[2];
  my $subject = $_[3];
  my $body = $_[4];

  # split the email ids by ","
  my @toEmail_ids = split(/,/,$toEmail); 
  my $mail_id;

  $smtp = Net::SMTP->new($gateway);
  $smtp->mail($fromEmail);

  foreach $mail_id (@toEmail_ids){
    $mail_id = trim($mail_id);
    if( length($mail_id)>0 ){
       $smtp->to($mail_id);
    }
  }

  $smtp->data();
  $smtp->datasend("From: $fromEmail");
  $smtp->datasend("\n");

  foreach $mail_id (@toEmail_ids){
    $mail_id = trim($mail_id);
    if( length($mail_id)>0 ){
       $smtp->datasend("To: $mail_id");
       $smtp->datasend("\n");
    }
  }

  $smtp->datasend("Subject: $subject\n");
  $smtp->datasend("\n");
  $smtp->datasend("$body");
  $smtp->dataend();
  $smtp->quit();
}


my $agent_dir;

if ( $ENV{EMSTATE} ne "" ) 
{
  $agent_dir =  $ENV{EMSTATE};
}
elsif ( $ENV{EMDROOT} ne "" ) 
{
  $agent_dir =  $ENV{EMDROOT};
}
my $filename = File::Spec->catfile( $agent_dir, "sysman", "config", "emd.properties" );


if(!open(FILE, "<$filename"))
{
  EMD_PERL_ERROR("emrepdown: Could not open $filename to get e-mail addresses");
}

my $toEmail;
my $fromEmail;
my $gateway;
my $rest;

while(<FILE>)
{
  if($_ !~ /#/)
  {
    if($_ =~ /emd_email_address=/)
    {
      s/emd_email_address=//;

      ($toEmail, $rest) = split(' ', $_, 2);
      EMD_PERL_DEBUG ("emrepdown: emd_email_address=$toEmail");
    }
    elsif($_ =~ /emd_from_email_address=/)
    {
      s/emd_from_email_address=//;

      ($fromEmail, $rest) = split(' ', $_, 2);
      EMD_PERL_DEBUG ("emrepdown: emd_from_email_address=$fromEmail");
    }
    elsif($_ =~ /emd_email_gateway=/)
    {
      s/emd_email_gateway=//;

      ($gateway, $rest) = split(' ', $_, 2);
      EMD_PERL_DEBUG ("emrepdown: emd_email_gateway=$gateway");
    }
  }
}

if(!defined $toEmail)
{
  EMD_PERL_ERROR("emrepdown: emd_email_address is not correctly defined in $filename");
  # exit(-1);
  return 0;
}
if(!close(FILE))
{
  EMD_PERL_ERROR("emrepdown: Could not close $filename");
}

chomp($fromEmail);
chomp($toEmail);

if(!defined $gateway)
{
  EMD_PERL_WARN("emrepdown: emd_email_gateway is not correctly defined in $filename");
  EMD_PERL_WARN("emrepdown: using mailhost as default");
  $gateway = 'mailhost';
}

if(!defined $fromEmail)
{
  EMD_PERL_WARN("emrepdown: emd_from_email_address is not correctly defined in $filename");
  EMD_PERL_WARN("emrepdown: using nobody as default");
  $fromEmail = 'nobody';
}

my $subject="Enterprise Manager is Down";
my $errorMsg=".\n";

if ($#ARGV+1 > 0) 
{
  $errorMsg = "$ARGV[0]\n";

  if ($#ARGV+1 > 1) 
  {
    $subject = $ARGV[1]; 
  } 
} 
EMD_PERL_DEBUG("emrepdown: subject=$subject");
EMD_PERL_DEBUG("emrepdown: $errorMsg");

my $body = scalar(localtime) . "\n$subject\n$errorMsg";

sendMail($gateway, $toEmail, $fromEmail, $subject, $body);

return 0;

