#  $Header: emcore/builtin_target_types/oracle.sysman.emrep/agent/scripts/emrepnotif.pl /main/3 2011/07/17 08:58:32 jianpeng Exp $
#
# Copyright (c) 2001, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      emrepnotif.pl 
#
#    DESCRIPTION
#      It connects to a database, executes a user-defined SQL
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#      sreddy   11/07/14 - fix bug#10297267, fix data collection.
#      tsubrama 12/16/10 - using mtm_util
#      tsubrama 04/15/10 - moving this file to plugin
#      mveena   01/09/09 - fix for bug 7695901
#      tsubrama 07/30/08 - using plsql function instead of direct queries bug#7277905
#      tsubrama 05/17/07 - removing double quotes in the subject and msg
#      aholser  01/24/05 - improve reliability
#      aholser  09/10/04 - linux port
#      kranjan  07/19/04 - Fix for Bug 3734381
#      aholser  10/21/03 - remove tracing pwd 
#      aholser  10/18/03 - 
#      aholser  08/04/03 - notif delivery job gone 
#      aholser  04/29/03 - minor changes
#      aholser  04/15/03 - aholser_aa
#      aholser  04/15/03 - 
#      aholser  12/31/02 - Creation
#

use strict;
use Oraperl;
use Time::HiRes;
use DBI;
use DBD::Oracle qw(:ora_types);

require "emd_common.pl";
require "semd_common.pl";
require "mtm_util.pl";

my $targetname = "";
my $db_connect = "";
 
EMD_PERL_DEBUG("emrepnotif: Connectdescriptor $ENV{CONNECTDESCRIPTOR}");
if ( $ENV{CONNECTDESCRIPTOR} ne "" )
{
  #$db_connect = $ENV{EM_REPOS_USER} . "/" . $ENV{EM_REPOS_PWD} . "@" . $ENV{CONNECTDESCRIPTOR};
  $db_connect = $ENV{CONNECTDESCRIPTOR};
  #$targetname = $ENV{EM_REPOS_USER}."test";
}
else
{
  #$db_connect = $ENV{EM_REPOS_USER} . "/" . $ENV{EM_REPOS_PWD} . "@" . $ENV{EM_TARGET_ADDRESS};
  $db_connect = $ENV{EM_TARGET_ADDRESS};
  #$targetname = $ENV{SID}.$ENV{PORT};
}
$targetname = $ENV{EM_REPOS_USER}."test";

my $start_time = Time::HiRes::time;


#my $targetname = $ENV{SID}.$ENV{PORT};
my $timeCounterFile = get_tmp_filename ($targetname, "emrepnotif_ts");
EMD_PERL_DEBUG("emrepnotif: $targetname, $timeCounterFile");

########## Using DBI to execute the stored procedure and get the required data ####
my $DB_Connection = DBI->connect("dbi:Oracle:$db_connect",
     $ENV{EM_REPOS_USER},
     $ENV{EM_REPOS_PWD},
    {
       RaiseError =>0
    }
);

if( !$DB_Connection ) {

   # If we can't connect we'll exit.  The error will be caught by emrepresp.pl and notification will be sent from there.
   EMD_PERL_DEBUG("Getting repository connection failed. Error: $DBI::errstr $DBI::err $DBI::state");
   exit 0;
}

my $status;
my $statusMessage;

eval {
    my $data_cursor;
    $DB_Connection->{RaiseError} = 1;
    my $prepare_stmt = $DB_Connection->prepare(q{
        BEGIN
           :data_cursor := mgmt_emrep_oob_monitoring.GET_OOB_DATA_FOR_NOTIF();
        END;
    });
   $prepare_stmt->bind_param_inout(":data_cursor", \$data_cursor, 0, { ora_type => ORA_RSET });
   $prepare_stmt->execute;

   my @row_data;
   @row_data = $data_cursor->fetchrow_array;

   EMD_PERL_DEBUG("data from repository... @row_data");

   my $arry_size = scalar(@row_data);
   if($arry_size>=2){
      $status = $row_data[0];
      $statusMessage = $row_data[1];
   }

  #my $close_cur = $DB_Connection->prepare("BEGIN CLOSE :cursor; END;");
  #$close_cur->bind_param_inout(":cursor", \$data_cursor, 0, { ora_type => ORA_RSET } );
  #$close_cur->execute;
};


if( $@ ) {
  my $err_msg =  $DBI::errstr;

  ## check whether error is for plsql package/function not available.
  if(index($err_msg,"ORA-06550:")>-1){
     #emrepresp.pl will take care of sending notification to the user.
     EMD_PERL_DEBUG("Getting data from repository failed. Check OMS version compatibility. Error: $err_msg $DBI::err $DBI::state");
     close_dbconnection($DB_Connection);
     exit 0;

  }else{ ## any other errors.
    #emrepresp.pl will take care of sending notification to the user.
    EMD_PERL_DEBUG("Getting data from repository failed. Error: $err_msg $DBI::err $DBI::state");
    close_dbconnection($DB_Connection);
    exit 0;

  }
}


EMD_PERL_DEBUG("emrepnotif: query result is: em_result=$status|$statusMessage\n");

print ("em_result=$status|$statusMessage");
if ($status eq "UP")
{
  ### remove the tmp file used to determine the interval for sending mail.
  ### because no issues are there if execution happens at this place.
  my $tmpFileExists = -e $timeCounterFile;
  if($tmpFileExists >= 1)
  {
    unlink($timeCounterFile);
  }
}
else
{
  EMD_PERL_ERROR("$statusMessage");
  processfailure("$statusMessage");
}

## close the db connection after getting the data.
close_dbconnection($DB_Connection);
exit 0;

sub close_dbconnection
{
   my $l_conn = $_[0];
   $l_conn->disconnect if ($l_conn);
   my $end_time = Time::HiRes::time;
   my $logon_time = ($end_time - $start_time) * 1000;
   EMD_PERL_DEBUG("Time in getting data from repos: $logon_time" );
}

sub processfailure
{
   # get the currently executing file with full path.
   my $thisFileWithPath = $0;
   # replace the currently executing file name with emrepdown.pl
   $thisFileWithPath=~ s/emrepnotif.pl/emrepdown.pl/ig;

   my $mailscript = $thisFileWithPath;
   my $interval_in_mins = 60;
   my $interval = $interval_in_mins/(24*60); # send email notification in each $interval_in_mins mins.
   my $mailSubject = "Severe Oracle Enterprise Manager Notification subsystem problem";
   my ($mailText) = @_;

   SendEmailNotification($mailscript, $timeCounterFile, $interval, $mailSubject, $mailText);

}



