use strict;
use Config; # for callEmctl

# function to get whether the target is pre12GC. Need to pass version of the target
# to this function. Ex: isPre12gcTarget("12.1.0.1")
sub isPre12gcTarget
{
  my ($tgt_version) = @_;
  my $dot_index = index($tgt_version,".");
  my $tgt_max_version;
	
  my $isPre12G_Target = 'Yes';
	
  # if "." is found, get max version number
  if ($dot_index > -1)
  {
      $tgt_max_version = substr($tgt_version,0,$dot_index);
      # if max version number is greater than or equal to 12, then it is not pre12G target.
      if($tgt_max_version >= 12)
      {
         $isPre12G_Target = 'No';
      }
  }

  return $isPre12G_Target;

}

sub isWindowsOS
{
   my $OSNAME = $Config{'osname'};
   my $IsWin32 = ($OSNAME eq 'MSWin32');
   return $IsWin32;
}


# Routine to run emctl command by passing OracleHome and Emctl command.
# Ex: callEmctlCommand('c:/oracle/OraHome','status oms');
sub callEmctlCommand
{
    my $oracleHome = shift;
    my $emctlParam = shift;
    my @getemctl_output;

    my $emctl_file = File::Spec->catfile( $oracleHome, "bin", "emctl");

    # If we are on windows then get emctl.bat rather than emctl
    my $IsWin32 = isWindowsOS();

    if($IsWin32)
    {
        $emctl_file = File::Spec->catfile( $oracleHome, "bin", "emctl.bat" );
    }

    @getemctl_output = `$emctl_file $emctlParam`;
    return @getemctl_output;
}

# It removes the space around the string OR strings in array passed to it.
sub trim {
    my @out = @_;
    for (@out) {
        s/^\s+//;
        s/\s+$//;
    }
    return wantarray ? @out : $out[0];
}

# This sub-routine is used to send OOTB email notification. Arguments to this routine are given below.
   # $mailingScript -- Perl file (with full path) which is sending email notification.
   # $tmpTextfileName -- Text file which has timestamp stored. This timestamp will be used to determine when email should be resent.
   # $mailResendInterval -- Time interval for resending the email
   # $mailSubjectText -- Subject of the email
   # $mailBodyText -- Message of the email

sub SendEmailNotification
{
   my ($mailingScript,$tmpTextfileName, $mailResendInterval, $mailSubjectText, $mailBodyText ) = @_;

   my $mailscript = $mailingScript;
   my $tmpFileExists = -e $tmpTextfileName;
   my $mailscriptexists = -e $mailscript;
   my $accesstime = 0;
   if($tmpFileExists >= 1)
   {
       # if file exists,get the last modified of the tmp file.
       $accesstime = -M $tmpTextfileName;
   }
   my $interval = $mailResendInterval;
   EMD_PERL_DEBUG("tmpFileExists=$tmpFileExists, accesstime=$accesstime, interval=$interval mailscriptexists=$mailscriptexists" );


   # Email is sent if the error is new ($tmpTextfileName doesn't exist) or more than one hour has elapsed.
   if(($tmpFileExists < 1) || ($accesstime > $interval))
   {

        # Write  the time in the file to make the file modification date change.
        if( length( trim($tmpTextfileName) ) >0 )
        {
           open(FILE, ">".$tmpTextfileName);
           print FILE scalar localtime;
           close(FILE);
        }

        # if emrepdown.pl is not in current path, log an error and exit.
        if($mailscriptexists < 1)
        {
              EMD_PERL_DEBUG("Can't locate mailing script $mailingScript");
              return;
        }
        else
        {
              local @ARGV;

              $ARGV[0] = $mailBodyText ;
              $ARGV[1] = $mailSubjectText;

              EMD_PERL_ERROR("call for sending email notification by $mailscript, Message:$ARGV[0], Subject:$ARGV[1]");

              #since ARGV is local variable,it's values are directly accessible in the mailscript.
              #The do() method executes the contents of the file as a Perl script.
              do($mailscript);
       }
  }
  else
  {
      EMD_PERL_DEBUG("processfailure $tmpTextfileName already exists");
  }
} # end of SendEmailNotification

1;



