#!/usr/local/bin/perl
# 
# $Header: emcore/builtin_target_types/oracle.sysman.emrep/agent/scripts/omsConfiguration.pl /main/4 2011/07/23 21:57:28 tsubrama Exp $
#
# omsConfiguration.pl
# 
# Copyright (c) 2005, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      omsConfiguration.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    tsubrama    07/20/11 - take version from releaseVersion
#    tsubrama    02/24/11 - pulled from EMLL label for model convergence.
#    raankire    02/17/10 - adding SECURE_STATUS column to MGMT_ECM_OMS_CONFIG_PARAMS metric
#    nmittal     10/02/09 - XbranchMerge nmittal_bug-8629030 from
#                           st_emll_10.3.2
#    nmittal     09/17/09 - handling wls stack changes
#    rstorrie    12/03/08 - Remove \'s from name and connect string
#    rstorrie    06/01/06 - Addition of version metric 
#    rstorrie    12/01/05 - OMS configuration collection 
#    rstorrie    12/01/05 - OMS configuration collection 
#    rstorrie    12/01/05 - Creation
# 
use strict;
use File::Spec;
use ias::simpleXPath;
use Switch;

#require "emd_common.pl";
#require "semd_common.pl";
require "emd_common_ocm.pl";
require "emConsoleSecure.pl";

my $oracleHome = shift;
my $wlsStack = shift;
my $instanceHome = shift;

if ($oracleHome eq "") 
{
    EMD_PERL_DEBUG("No valid ORACLE_HOME supplied, exiting\n");
    exit;
}

if($wlsStack eq "")
{
   EMD_PERL_DEBUG("Invalid WLS_STACK value, exiting\n");
    exit;
}

if($wlsStack eq "TRUE" && $instanceHome eq "")
{
   EMD_PERL_DEBUG("No valid INSTANCE_HOME supplied, exiting\n");
   exit;
}

my %configParams;
my $omsCoreVersion;
my $oms_properties_file;
my $file_opened = "true";

if($wlsStack eq "TRUE")
{
   $oms_properties_file = File::Spec->catfile( $instanceHome, "sysman", "ocm", "emoms.properties" );
   my $version_prop_file = File::Spec->catfile( $instanceHome, "sysman", "ocm", "emVersion.properties");
   if(-f $version_prop_file)
   {
       open (FILE, "<$version_prop_file") or ($file_opened="false"); 
       if($file_opened eq "true")
       {
          my $ver_line;

          #Scan through the file assigning the various parameters to get the values
          while ($ver_line = <FILE>)
          {
             chomp $ver_line;
             if ( $ver_line =~ /^\s*(.*?)\s*=\s*(.*?)$/)
             {
                my $ver_value = $2;
                my $ver_parameter = $1;
                if($ver_parameter eq "releaseVersion")
                {
                   $omsCoreVersion = $ver_value;
                   last; # exit if release version is found.
                }

                if($ver_parameter eq "coreVersion")
                {
                   $omsCoreVersion = $ver_value;
                }
             }
          }
          close FILE;
       }
       else
       {
          EMD_PERL_DEBUG("Unable to open $! \n",$version_prop_file);
       }
   }
}
else
{
   $oms_properties_file = File::Spec->catfile( $oracleHome, "sysman", "config", "emoms.properties" );
   # Setup a filename to get the oms version
   # then parse this using simpleXPathQuery
   my $oms_version_file = File::Spec->catfile( $oracleHome, "j2ee", "OC4J_EM", "applications","em","em","WEB-INF","config","emVersion.xml");
   if (-f $oms_version_file)
   {
      open (FILE, "<$oms_version_file") or ($file_opened="false");
      if($file_opened eq "true")
      {
         close FILE;
         my @omsVersion = simpleXPathQuery($oms_version_file,'Product');

         foreach my $refOmsVersion (@omsVersion)
         {
             $omsCoreVersion = $refOmsVersion->{'coreVersion'};
         }
       }
       else
       {
         EMD_PERL_DEBUG("Unable to open $! \n",$oms_version_file);
       }
    }
}

if ($file_opened eq "true" and -f $oms_properties_file)
{
my $secure_status;

    open (FILE, "<$oms_properties_file") or ($file_opened="false");
    if($file_opened eq "true")
    {
       my $line;
       #Only if we can open the file then perform collection
       #Scan through the file assigning the various parameters to get the values
       while ($line = <FILE>)
       {
          chomp $line;
          if ( $line =~ /^\s*(.*?)\s*=\s*(.*?)$/)
          {
             my $value = $2;
             my $parameter = $1;

             #replace any \: with : and \= with =
             $value =~ s/\\:/:/g;
             $value =~ s/\\=/=/g;
             $configParams{"$parameter"}=$value;
          }
       }
       close FILE;

#Getting secure_status from emConsoleSecure.pl
if($wlsStack ne "TRUE")
{
$secure_status=getConsoleSecure("$oracleHome",$configParams{"oracle.sysman.emSDK.svlt.ConsoleServerPort"},$configParams{"oracle.sysman.emSDK.svlt.ConsoleServerHTTPSPort"});
}
       $configParams{"version"}=$omsCoreVersion;  

       print "em_result=" . $configParams{"oracle.sysman.emSDK.svlt.ConsoleServerName"} . "|"
                          . $configParams{"oracle.sysman.emSDK.svlt.ConsoleServerPort"} . "|"
                          . $configParams{"oracle.sysman.emSDK.svlt.ConsoleServerHTTPSPort"} . "|"
                          . $configParams{"oracle.sysman.emSDK.svlt.ConsoleServerHost"} . "|"
                          . $configParams{"emdrep.ping.pingCommand"} . "|"
                          . $configParams{"em_oob_shutdown"} . "|"
                          . $configParams{"em_oob_crash"} . "|"
                          . $configParams{"LargeRepository"} . "|"
                          . $configParams{"oracle.sysman.eml.mntr.emdRepUser"} . "|"
                          . $configParams{"oracle.sysman.eml.mntr.emdRepServer"} . "|"
                          . $configParams{"oracle.sysman.eml.mntr.emdRepPort"} . "|"
                          . $configParams{"oracle.sysman.eml.mntr.emdRepSID"} . "|"
                          . $configParams{"oracle.sysman.eml.mntr.emdRepConnectDescriptor"} . "|"
                          . $configParams{"em_email_address"} . "|"
                          . $configParams{"em_from_email_address"} . "|"
                          . $configParams{"em_from_email_name"} . "|"
                          . $configParams{"em_email_gateway"} . "|"
                          . $configParams{"em.ip.ui.enable"} . "|"
                          . $configParams{"oracle.sysman.emSDK.svlt.PublicServletEnabled"} . "|"
                          . $configParams{"oracle.sysman.db.isqlplusUrl"} . "|"
                          . $configParams{"oracle.sysman.db.isqlplusWebDBAUrl"} . "|"
                          . $configParams{"em.oms.dumpModules"} . "|"
                          . $configParams{"oracle.sysman.emkeyfile"} . "|" 
                          . $configParams{"version"} . "|"
			  . $secure_status. "\n";
   }
   else
   {
       EMD_PERL_DEBUG("Unable to open $! \n",$oms_properties_file);
   }
}
