#!/usr/local/bin/perl
# 
# $Header: emcore/builtin_target_types/oracle.sysman.emrep/agent/scripts/oms_assoc.pl /main/1 2011/04/05 19:04:37 tsubrama Exp $
#
# oms_assoc.pl
# 
# Copyright (c) 2005, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oms_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    tsubrama    03/15/11 - pulled from EMLL for model convergence
#    rstorrie    03/29/10 - Correct the association so that NO_VALUE is not a
#                           valid entry for repHost and repSID
#    nmittal     11/13/09 - XbranchMerge nmittal_bug-9118047 from
#                           st_emll_10.3.2
#    nmittal     11/13/09 - adding emd_common.pl to include perl debug module
#    nmittal     10/16/09 - XbranchMerge nmittal_bug-8943752 from
#                           st_emll_10.3.2
#    nmittal     10/13/09 - adding relationship between oms and weblogic server
#                           target
#    nmittal     10/02/09 - XbranchMerge nmittal_bug-8629030 from
#                           st_emll_10.3.2
#    nmittal     09/18/09 - handling wls stack changes
#    rstorrie    12/02/05 - Association script for OMS target, includes 
#                           repository and OC4J 
#    rstorrie    12/02/05 - Association script for OMS target, includes 
#                           repository and OC4J 
#    rstorrie    12/02/05 - Creation
# 

use strict;
#use ecmAssoc;
use File::Spec;
use Switch;
#require "emd_common.pl";

$ENV{EMDROOT} = $ENV{CCR_HOME};
#require "$ENV{CCR_HOME}/sysman/admin/scripts/db/net/listenerUtil.pl";

my $oracleHome = shift;
my $targetName = shift;
my $wlsStack = shift;
my $instanceHome = shift;

my $ORACLE_WEBLOGIC_SERVER = 'weblogic_j2eeserver';
my $OC4J_TYPE = 'oc4j';
my $CONNECTS_TO = 'connects_to';
my $ORACLE_DATABASE_TYPE = 'oracle_database';
my $DEPENDS_ON = 'depends_on';


if ($oracleHome eq "" || $targetName eq "") 
{
    EMD_PERL_DEBUG ("No valid ORACLE_HOME or OMS Name supplied, exiting\n");
    exit;
}

if($wlsStack eq "")
{
   EMD_PERL_DEBUG( "Invalid WLS_STACK value, exiting\n");
   exit;
}

if($wlsStack eq "TRUE" && $instanceHome eq "")
{
   EMD_PERL_DEBUG("No valid INSTANCE_HOME supplied, exiting\n");
   exit;
}

my %configParams;

my $oms_properties_file;
my $mwTargetName;
my $mwTargetType;
my $mwTargetProperties;
my $file_opened = "true";

if($wlsStack eq "TRUE")
{
   $oms_properties_file = File::Spec->catfile( $instanceHome, "sysman", "ocm", "emoms.properties" );
   $mwTargetType = $ORACLE_WEBLOGIC_SERVER;
   my $emgc_properties_file = File::Spec->catfile( $instanceHome, "emgc.properties");
   if(open (FILE, "<$emgc_properties_file"))
   {
      my $line;
      my %emgcParams;

      #Scan through the file assigning the various parameters to get the values
      while ($line = <FILE>)
      {
         chomp $line;
         if ( $line =~ /^\s*(.*?)\s*=\s*(.*?)$/)
         {
             my $value = $2;
             my $parameter = $1;

             #replace any \: with : and \= with =
             $value =~ s/\\:/:/g;
             $value =~ s/\\=/=/g;
             $emgcParams{"$parameter"}=$value;
          }
      }
      close FILE;
      my $domainName = $emgcParams{"EM_DOMAIN_NAME"};
      my $omsName = $emgcParams{"OMSNAME"};
      my $domainHome = $emgcParams{"EM_DOMAIN_HOME"};
      $mwTargetName = "/Farm_$domainName/$domainName/$omsName";
      $mwTargetProperties = $domainHome;
   }
   else
   {
     EMD_PERL_DEBUG("Error in opening $emgc_properties_file\n");   
   }
}
else
{
  $oms_properties_file = File::Spec->catfile( $oracleHome, "sysman", "config", "emoms.properties" );
  $mwTargetName = $targetName . "_OC4J_EM";
  $mwTargetType = $OC4J_TYPE;
}

if (-f $oms_properties_file)
{
    open (FILE, "<$oms_properties_file") or ($file_opened="false");
    if($file_opened eq "true")
    {
       my $line;

       #Scan through the file assigning the various parameters to get the values
       while ($line = <FILE>)
       {
           chomp $line;
           if ( $line =~ /^\s*(.*?)\s*=\s*(.*?)$/)
           {
               $configParams{"$1"}=$2;
           }
       }
       close FILE;
    
       my $repHost = $configParams{"oracle.sysman.eml.mntr.emdRepServer"};
       my $repSid = $configParams{"oracle.sysman.eml.mntr.emdRepSID"};
       my $repPort = $configParams{"oracle.sysman.eml.mntr.emdRepPort"};
       my $repConn = $configParams{"oracle.sysman.eml.mntr.emdRepConnectDescriptor"};
    
       $repConn =~ s/\\=/=/g;
       if ( $repHost ne '' && $repHost ne 'NO_VALUE' && $repSid ne '' && $repSid ne 'NO_VALUE' &&  $repPort ne '' )
       {        
          print ("em_result=$CONNECTS_TO||$ORACLE_DATABASE_TYPE|$repHost:$repPort:$repSid\n");
       }
       elsif ( $repConn ne '' )
       {
          my $addresses = getParamValueListFor($repConn,"ADDRESS");
          my $connectData = getParamValueListFor($repConn,"CONNECT_DATA");
          my $sidOrService = "";
          my ($addrInfo,$connInfo);
          foreach $addrInfo(@$addresses)
          {
              foreach $connInfo(@$connectData)
              {
                  if (defined($connInfo->{SERVICE_NAME}))
                  {
                      $sidOrService = $connInfo->{SERVICE_NAME};
                  }
                  elsif (defined($connInfo->{SID}))
                  {
                      $sidOrService = $addrInfo->{PORT}.":".$connInfo->{SID};
                  }
                  print ("em_result=$CONNECTS_TO||$ORACLE_DATABASE_TYPE|$addrInfo->{HOST}:$sidOrService\n");
             }
          }
       }
       else
       {
           EMD_PERL_DEBUG("No valid database connection found in emoms.properties\n");   
       }
    }
    else
    {
      EMD_PERL_DEBUG("Unable to open $! \n",$oms_properties_file);
    }
    print ("em_result=$DEPENDS_ON|$mwTargetName|$mwTargetType|$mwTargetProperties|\n");
} 

#Gets the parameter values for a give parameter and given NV String
#For example:
# Given $line as below:
#$line = "SID_LIST_LISTENER12 =  (SID_LIST =    (SID_DESC =      
# (SID_NAME = emdw1)   (ORACLE_HOME = home2) )   
# (SID_DESC = (GLOBAL_DBNAME = gdbname) (SID_NAME = orcl) (ORACLE_HOME = home1)))
# And $paramName = SID_DESC,
# then this routine will return an array of two Hashes like
# (
#   {
#      SID_NAME => emdw1,
#      ORACLE_HOME => home2
#    },
#    {
#      GLOBAL_DBNAME => gdbname,
#      SID_NAME => orcl
#      ORACLE_HOME => home1
#    },
# )

sub getParamValueListFor
{
  my ($line,$paramName) = @_;
  my @delimiters = ('(','=',')');
  my @toknizedLiterals = tokenize($line,@delimiters);
  $paramName = uc ($paramName);
  my $expectingParam = 0;
  my $expectingValue = 0;
  my $paramStartFound = 0;
  my $currWord;
  my $paramFound = 0;
  my $paramValueMarker = 0;
  my %tempParamValue;
  my @retParamValueList;
  my $curPoint = 0;
  my $tempParamName;
  my $bError;
  while ( ($currWord = getNextWord($curPoint++,@toknizedLiterals)) ne "")
  {
      if ($currWord eq "(" )
      {
        $expectingParam = 1;
        $expectingValue = 0;
        if($paramFound)
        {
          $paramFound++;
          $paramStartFound = 1;
        }
      }
      elsif ($currWord eq ")" )
      {
        $expectingParam = 0;
        $expectingValue = 0;
        if($tempParamName ne "")
        {
          # Need to add empty paramvalue
          $tempParamValue{uc $tempParamName} = "";
          $tempParamName = "";
        }
        if($paramFound)
        {
          $paramFound--;
          #if($paramStartFound eq 0)
          if(!$paramFound)
          {
            #end of param found;
            push(@retParamValueList, {%tempParamValue});
          }
          else
          {
            $paramStartFound = 0;
          }
        }
      }
      elsif ($currWord eq "=")
      {
        $expectingValue = 1;
        $expectingParam = 0;
      }
      else
      {
        if($paramFound)
        {
          if($expectingParam)
          {
            $tempParamName = $currWord;
          }
          else
          {
            $tempParamValue{uc $tempParamName} = $currWord;
            $tempParamName = "";
          }
        }
        elsif($expectingParam && $paramName eq uc ($currWord))
        {
           $paramFound = 1;
           %tempParamValue = ();
	   my $key;
            foreach $key (keys %tempParamValue)
            {
              delete $tempParamValue{$key};
            }
        }
      }#End of Else
  }
  return \@retParamValueList;
}


#Gets the next word in an array of words or strings
#if end of array is reached empty char "" is returned.
sub getNextWord
{
     my ($curPoint,@parsedChars) = @_;
     my $char = "";

     if ($curPoint < @parsedChars)
     {
        $char = $parsedChars[$curPoint];
     }
     return $char;
}


#This subroutine tokenizes the given line based on the specified delimiters 
# For the following delimiters
# ( , =  and )
# and 
#$line = "(SID_LIST =    (SID_DESC =      
# (SID_NAME = emdw1)   (ORACLE_HOME = home2) )   
# (SID_DESC = (GLOBAL_DBNAME = gdbname) (SID_NAME = orcl) (ORACLE_HOME = home1)))
# the return value will be and array as follows
# (
#"(", "SID_LIST", "=", "(" , "SID_DESC", "=" ,
#"(" , "SID_NAME", "=","emdw1", ")", "(" , "ORACLE_HOME", "=" , "home2" , ")", ")",
#"(", "SID_DESC", "=", "(" , "GLOBAL_DBNAME", "=" , "gdbname", ")",
#"(" , "SID_NAME", "=","orcl", ")", "(" , "ORACLE_HOME", "=" , "home1" , ")", ")", ")" )
sub tokenize
{
  my ($line,@delimiters) = @_;
  if( $#delimiters == -1)
  {
    @delimiters = ('(','=',')');
  }
  my $quotedLiteral = 0;
  my $quoteChar;
  my $currChar;
  my @parsedChars =  parseStrToChars($line);
  my $curPoint = 0;
  my @paramValue;
  my $tempLiteral;
  my $literalFound;
  my $backSlashFound;
  while ( ($currChar = getNextWord($curPoint++,@parsedChars)) ne "")
  {
      if($currChar =~ /\s/)
      {
        next;
      }
      elsif (contains($currChar,@delimiters))
      {
        push(@paramValue,$currChar);
      }
      else
      {
         $tempLiteral = $currChar;
         if($currChar eq "\"" || $currChar eq "'")
         {
          $quotedLiteral = 1;
          $quoteChar = $currChar;
         }
         else
         {
          $quotedLiteral = 0;
         }

         $backSlashFound = 0;
         $literalFound = 0;
         while ( ($currChar = getNextWord($curPoint++,@parsedChars)) ne "")
         {
                #On a backslash (escaped character), save the backslash and
                #following character into the literal.
                if ($currChar eq "\\")
                {
                    $tempLiteral .= $currChar;
                    $backSlashFound = 1;
                    next;
                }

                if($backSlashFound)
                {
                  #don't process this char and reset the back slash found flag
                  $backSlashFound = 0;
                }
                else
                {
                  if ($quotedLiteral)          # literal wrapped with quotes
                  {
                      if ($currChar eq $quoteChar)     # quote terminator found
                      {
                          $tempLiteral .= $currChar;
                          $literalFound = 1;
                          last;
                      }
                  }
                  else
                  {    #did we hit unescaped meta character ( ) or =
                      if (contains($currChar,@delimiters))
                      {
                          #terminate string - do NOT increment POS, or it will
                          #swallow the metacharacter into the literal
                          $curPoint--;
                         # if($currChar eq ")" || $currChar eq "=")
                          {
                            $literalFound = 1;
                          }
                          last;
                      }
                  }
                }#End of if($backSlashFound)
                $tempLiteral .= $currChar;
         }#End of while ( ($currChar = getNextChar($curPoint++,@parsedChars)) ne "")
        if($currChar eq "")
        {
          $literalFound = 1;
        }
        #String.substring() is exclusive for end (does not include end
        # character.
        if($literalFound)
        {
          push(@paramValue,trim($tempLiteral));
        }
      }#else
   }#while
   return @paramValue;
}


#parse line into characters
#for $line=(SID_NAME = emdw1)
# the return value will be and array as follows
# (
#"(", "S", "I" , "D", "_" , "N" , "A" , "M" , "E", " ", "=", " " ,"e","m","d","w","1",")"
# ).
sub parseStrToChars
{
  my ($parseStr) = @_;
  my @parsedChars ;
#  #print "In parseStrToChars\n";
  if(defined($parseStr) || $parseStr ne "")
  {
          while ($parseStr =~ /(.)/g)
          {
        #    #print "[$1]\n";
                push(@parsedChars,$1);
          }
  }
  return @parsedChars;
}

#checks if an array contains an item
sub contains
{
  my ($item,@array) = @_;
  my $anItem;
  foreach $anItem (@array)
  {
      if ($anItem eq $item)
      {
          return 1;
          last;
      }
  }
  return 0;
}

#Strips leading and trailing spaces and returns the string
sub trim 
{
  my $origStr = $_[0];
  #Strip trailing and leading
  $origStr =~ s/^\s*|\s*$//g;
  return $origStr;
}

