#  $Header: emcore/builtin_target_types/oracle.sysman.emrep/agent/scripts/oms_dynamic_props.pl /main/5 2012/03/09 17:36:33 jashukla Exp $
#
# Copyright (c) 2001, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oms_dynamic_props.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <description>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#      tsubrama  02/03/12 - fix for 13653571
#      tsubrama  06/07/11 - removing isPre12G because ocm will not discover oms
#                           target
#      tsubrama  06/06/11 - getting isPre12G only for oms
#      tsubrama  04/26/11 - getting value for isPre12G
#      tsubrama  12/16/10 - using mtm_util
#      tsubrama  12/14/10 - getting oracle home canonical dir
#      mswamyt   05/28/10 - scripts for oms targets
#      tsubrama  03/03/10 - Creation
#
# use Oraperl;
# use Time::HiRes;
use Cwd 'abs_path';
use File::Spec;

require "emd_common.pl";
require "semd_common.pl";
require "mtm_util.pl";

my $targetType = shift;

my $oms_oracle_home = $ENV{OMS_ORACLE_HOME};

# get the absolute path.
my $OracleHomeCanonicalDir = abs_path($oms_oracle_home);

# get the path separators corrected in the absolute path got above.
my $no_file = true;
(my $volume,my $directories,my $file) = File::Spec->splitpath( $OracleHomeCanonicalDir,$no_file );
my @dirs = File::Spec->splitdir( $directories );
my $directories_new = File::Spec->catdir( @dirs);
$OracleHomeCanonicalDir = File::Spec->catpath( $volume, $directories_new, $file );

my @cmd_output = callEmctlCommand($oms_oracle_home,"getversion oms");

EMD_PERL_DEBUG("command output: @cmd_output ");

my $find_word = "oms version";

foreach $line (@cmd_output)
{
   $line = lc($line);
   if (index($line, $find_word) > -1)
   {
           @split_words = split (/$find_word/, $line);
   }
}
my $oms_version  = trim( $split_words[1]);
EMD_PERL_DEBUG("oms version : $oms_version");


print "em_result=$oms_version|$OracleHomeCanonicalDir\n";




