#  $Header: emcore/builtin_target_types/oracle.sysman.emrep/agent/scripts/oms_resp.pl /main/5 2012/03/09 17:36:33 jashukla Exp $
#
# Copyright (c) 2001, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oms_resp.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <description>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#      tsubrama  03/31/11 - adding more informative err msg#bug11782466
#      tsubrama  12/16/10 - using mtm_util
#      mswamyt   05/28/10 - scripts for oms targets
#      tsubrama  03/03/10 - Creation
#
use Oraperl;
use Time::HiRes;

require "emd_common.pl";
require "semd_common.pl";
require "mtm_util.pl";


my $targetType = shift;
my $oms_oracle_home = $ENV{OMS_ORACLE_HOME};

EMD_PERL_DEBUG("oms oracle home : $oms_oracle_home");
my @cmd_output = callEmctlCommand($oms_oracle_home,"status oms");

EMD_PERL_DEBUG("command output: @cmd_output");

my $find_word = "oracle management server is";
my $find_pbs_only_word = "oracle management server is up in pbs only mode";
my $find_console_only_word = "oracle management server is up in console only mode";
my $pbs_only_up = "false";
my $console_only_up = "false";
my $emctlOutputText = "";

foreach $line (@cmd_output)
{
   chomp($line);
   $emctlOutputText = $emctlOutputText ." ". $line;
   $line = lc($line);
   if (index($line, $find_word) > -1)
   {
           @split_words = split (/$find_word/, $line);
   }
   if (index($line, $find_pbs_only_word) > -1)
   {
           $pbs_only_up = "true";
   }
   if (index($line, $find_console_only_word) > -1)
   {
           $console_only_up = "true";
   }
}

$emctlOutputText = trim($emctlOutputText);
EMD_PERL_DEBUG("emctlOutputText: $emctlOutputText");

my $status = trim( $split_words[1]);
EMD_PERL_DEBUG("Status: $status");

my $status_code = 0;
my $message = "Status not found.";
if ($status =~ m/^up/) 
{
	$status_code = 1;
        if ($targetType eq 'oracle_oms')
        {
           $message = "Oracle Management Service is Up.";
        }
        elsif ($targetType eq 'oracle_oms_console')
        {
           if($status eq 'up' || $console_only_up eq 'true')
           {
              $message = "OMS Console is Up.";
           }
           else
           {
              $message = "OMS Console is Down.";
              $status_code = 0;
           }
        }
        elsif ($targetType eq 'oracle_oms_pbs')
        {
           if($status eq 'up' || $pbs_only_up eq 'true')
           {
              $message = "OMS Platform is Up.";
           }
           else
           {
              $message = "OMS Platform is Down.";
              $status_code = 0;
           }
        }
}
elsif ($status eq 'down') 
{
	$status_code = 0;
        if ($targetType eq 'oracle_oms')
        {
	   $message = "Oracle Management Service is Down.";
        }
        elsif ($targetType eq 'oracle_oms_console')
        {
           $message = "OMS Console is Down.";
        }
        elsif ($targetType eq 'oracle_oms_pbs')
        {
           $message = "OMS Platform is Down.";
        }

}
else
{
  #if OMS is not Up or not Down, make the oms status as down and print the entire "emctl status oms"
  #command output.
  $status_code = 0;
  $message = $emctlOutputText;
}

print ("em_result=$status_code|$message\n");

exit 0;


