#!/usr/local/bin/perl
# 
# $Header: emcore/builtin_target_types/oracle.sysman.oh/agent/scripts/OHDynamicProps.pl /main/2 2011/07/13 09:31:57 hmodawel Exp $
#
# OHDynamicProps.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OHDynamicProps.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hmodawel    07/11/11 - change method name
#    ravpatel    06/22/11 - Script to collect Dynamic Properties of Oracle Home
#    ravpatel    06/22/11 - Creation
#

use OH_Utilities;
use OH_Error;
use OH_ParseOHPropXml;
use OH_OUI;

my $home_loc = shift;
my $OHPropXml = File::Spec->catfile($home_loc,"inventory","ContentsXML","oraclehomeproperties.xml");
my $failed = OH_Utilities::checkPermissions($OHPropXml);

if (!$failed)
{
  my $OHProps = new OH_ParseOHPropXml(XML_FILE=>$OHPropXml);
  my $warnings = new Warn();
  my $error = new Error();
  my $retVal =  $OHProps->getOHProperties($warnings,$error);

  # we are deliberatly not dumping any warnings here.
  # Any issue reading oraclehomeproperties.xml will be dumped in HomeInfo metric.
  if (!$retVal)
  {
    my $homeGuid   = $OHProps->{HOME_GUID};
    my $aruId      = $OHProps->{ARU_ID};
    my $oracleBase = OH_OUI::getOracleHomeProperty("ORACLE_BASE", $OHProps);
    print "em_result=$homeGuid|$aruId|$oracleBase\n"; 
  }
}
 
