# $Header: emcore/builtin_target_types/oracle.sysman.oh/agent/scripts/ValidArgs.pm /main/2 2011/12/27 00:12:29 hmodawel Exp $
#
# ValidateArgs.pm
#
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ValidateArgs.pm - Validates the arguments passed to OHConfigCollector script
#
#    DESCRIPTION
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hmodawel    12/22/11 - plugin home metrics
#    irraju      03/28/10 - Collection script that calls various metrics aftere
#                           validation
#    irraju      03/28/10 - Creation
#
#TO VALIDATE METRIC NAMES
package ValidArgs;

use Exporter;
use base 'Exporter';

our @EXPORT = qw(
    %isThisHomeTypeValid
    %isThisOuiMetricValid
    %isThisWlsMetricValid
    %subRoutineFor
    %isPluginHomeMetricValid
    );

%isThisOuiMetricValid =
    (
        comps       =>    1,
        comp_deps    =>   1,
        patches	    =>    1,
        patchsets   =>    1,
        ver_patches  =>   1,
        inst_types   =>   1,
        patch_bugs   =>   1,
        patch_comps  =>   1,
        patch_files  =>   1,
        home_info    =>	  1,
        tl_comps     =>   1,
        home_guid    =>   1,
        aru_id	     =>	  1,
        aru_desc     =>   1,
        permissions  =>   1,
        dep_homes    =>   1,
        clone_props  =>   1,
        crs_nodes    =>   1
    );

%isThisWlsMetricValid =
    (
        comps        =>   1,
        comp_deps    =>   1,
        patches	     =>   1,
        home_info    =>   1,
        tl_comps     =>   1,
        home_guid    =>	  1,
        aru_id	     =>	  1,
        aru_desc     =>   1,
        permissions  =>   1
    );

%isPluginHomeMetricValid =
   (
       comps       =>    1,
       patches     =>    1,
       patch_bugs   =>   1,
       patch_comps  =>   1
   );

%isThisHomeTypeValid =
    (
        o => 1,
        w => 1
    );
    
#___HASH subRoutineFor ___
# This hash tells which subroutine to call for a given metric. Key is the name of the
# metric and value is the subRoutine to be called for getting that metric.

%subRoutineFor =
    (
        comps       => "getComponents",
        tl_comps    => "getTopLevelComponents",
        comp_deps   => "getComponentDependencies",
        home_info   => "getHomeInfo",
        inst_types  => "getInstallTypes",
        patches	    => "getPatches",
        patchsets   => "getPatchSets",
        ver_patches => "getVersionPatches",
        patch_bugs  => "getPatchedBugs",
        patch_comps => "getPatchedComps",
        patch_files => "getPatchedFiles",
        aru_id	    => "getAruId",
        aru_desc    => "getAruIdDesc",
        perms	    => "getOHPermissions",
        home_guid   => "getHomeGuid",
        ouiid       => "getOuiPlatformId",
        permissions => "getOHPermissions",
        dep_homes   => "getDepHomes",
        clone_props => "getCloneProperties",
        crs_nodes   => "getCRSNodes"

    );
1;
